// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnClusterSoftwarePackageGetReader is a Reader for the DcnClusterSoftwarePackageGet structure.
type DcnClusterSoftwarePackageGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnClusterSoftwarePackageGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnClusterSoftwarePackageGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnClusterSoftwarePackageGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnClusterSoftwarePackageGetOK creates a DcnClusterSoftwarePackageGetOK with default headers values
func NewDcnClusterSoftwarePackageGetOK() *DcnClusterSoftwarePackageGetOK {
	return &DcnClusterSoftwarePackageGetOK{}
}

/*
DcnClusterSoftwarePackageGetOK describes a response with status code 200, with default header values.

OK
*/
type DcnClusterSoftwarePackageGetOK struct {
	Payload *models.DcnClusterSoftwarePackage
}

// IsSuccess returns true when this dcn cluster software package get o k response has a 2xx status code
func (o *DcnClusterSoftwarePackageGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster software package get o k response has a 3xx status code
func (o *DcnClusterSoftwarePackageGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster software package get o k response has a 4xx status code
func (o *DcnClusterSoftwarePackageGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster software package get o k response has a 5xx status code
func (o *DcnClusterSoftwarePackageGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster software package get o k response a status code equal to that given
func (o *DcnClusterSoftwarePackageGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn cluster software package get o k response
func (o *DcnClusterSoftwarePackageGetOK) Code() int {
	return 200
}

func (o *DcnClusterSoftwarePackageGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/software/packages/{uuid}][%d] dcnClusterSoftwarePackageGetOK %s", 200, payload)
}

func (o *DcnClusterSoftwarePackageGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/software/packages/{uuid}][%d] dcnClusterSoftwarePackageGetOK %s", 200, payload)
}

func (o *DcnClusterSoftwarePackageGetOK) GetPayload() *models.DcnClusterSoftwarePackage {
	return o.Payload
}

func (o *DcnClusterSoftwarePackageGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnClusterSoftwarePackage)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterSoftwarePackageGetDefault creates a DcnClusterSoftwarePackageGetDefault with default headers values
func NewDcnClusterSoftwarePackageGetDefault(code int) *DcnClusterSoftwarePackageGetDefault {
	return &DcnClusterSoftwarePackageGetDefault{
		_statusCode: code,
	}
}

/*
DcnClusterSoftwarePackageGetDefault describes a response with status code -1, with default header values.

Error
*/
type DcnClusterSoftwarePackageGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn cluster software package get default response has a 2xx status code
func (o *DcnClusterSoftwarePackageGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn cluster software package get default response has a 3xx status code
func (o *DcnClusterSoftwarePackageGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn cluster software package get default response has a 4xx status code
func (o *DcnClusterSoftwarePackageGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn cluster software package get default response has a 5xx status code
func (o *DcnClusterSoftwarePackageGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn cluster software package get default response a status code equal to that given
func (o *DcnClusterSoftwarePackageGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn cluster software package get default response
func (o *DcnClusterSoftwarePackageGetDefault) Code() int {
	return o._statusCode
}

func (o *DcnClusterSoftwarePackageGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/software/packages/{uuid}][%d] dcn_cluster_software_package_get default %s", o._statusCode, payload)
}

func (o *DcnClusterSoftwarePackageGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/software/packages/{uuid}][%d] dcn_cluster_software_package_get default %s", o._statusCode, payload)
}

func (o *DcnClusterSoftwarePackageGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnClusterSoftwarePackageGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
