// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnClusterSoftwarePackageModifyCollectionReader is a Reader for the DcnClusterSoftwarePackageModifyCollection structure.
type DcnClusterSoftwarePackageModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnClusterSoftwarePackageModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnClusterSoftwarePackageModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnClusterSoftwarePackageModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnClusterSoftwarePackageModifyCollectionOK creates a DcnClusterSoftwarePackageModifyCollectionOK with default headers values
func NewDcnClusterSoftwarePackageModifyCollectionOK() *DcnClusterSoftwarePackageModifyCollectionOK {
	return &DcnClusterSoftwarePackageModifyCollectionOK{}
}

/*
DcnClusterSoftwarePackageModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DcnClusterSoftwarePackageModifyCollectionOK struct {
}

// IsSuccess returns true when this dcn cluster software package modify collection o k response has a 2xx status code
func (o *DcnClusterSoftwarePackageModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster software package modify collection o k response has a 3xx status code
func (o *DcnClusterSoftwarePackageModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster software package modify collection o k response has a 4xx status code
func (o *DcnClusterSoftwarePackageModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster software package modify collection o k response has a 5xx status code
func (o *DcnClusterSoftwarePackageModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster software package modify collection o k response a status code equal to that given
func (o *DcnClusterSoftwarePackageModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn cluster software package modify collection o k response
func (o *DcnClusterSoftwarePackageModifyCollectionOK) Code() int {
	return 200
}

func (o *DcnClusterSoftwarePackageModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /dcn/cluster/software/packages][%d] dcnClusterSoftwarePackageModifyCollectionOK", 200)
}

func (o *DcnClusterSoftwarePackageModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /dcn/cluster/software/packages][%d] dcnClusterSoftwarePackageModifyCollectionOK", 200)
}

func (o *DcnClusterSoftwarePackageModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDcnClusterSoftwarePackageModifyCollectionDefault creates a DcnClusterSoftwarePackageModifyCollectionDefault with default headers values
func NewDcnClusterSoftwarePackageModifyCollectionDefault(code int) *DcnClusterSoftwarePackageModifyCollectionDefault {
	return &DcnClusterSoftwarePackageModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	DcnClusterSoftwarePackageModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 203882497 | DCN software package cannot be staged prior to creating an ONTAP cluster. |
| 203882498 | No data compute nodes have been discovered to stage the software upgrade to. |
| 203882499 | The 'staged' field is required to stage the DCN software upgrade. |
| 203882500 | The DCN software package cannot be unstaged. |
| 203882501 | The DCN software package is in a disallowed state to perform staging. |
| 203882502 | The DCN software package is already staged. |
| 203882503 | Internal error. Failed to determine compatibility of the DCN software package with the ONTAP cluster. |
| 203882504 | The selected DCN software package is not compatible with the current ONTAP cluster version. |
| 203882505 | Internal error. Failed to remove the pre-existing DCN software package. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DcnClusterSoftwarePackageModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn cluster software package modify collection default response has a 2xx status code
func (o *DcnClusterSoftwarePackageModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn cluster software package modify collection default response has a 3xx status code
func (o *DcnClusterSoftwarePackageModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn cluster software package modify collection default response has a 4xx status code
func (o *DcnClusterSoftwarePackageModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn cluster software package modify collection default response has a 5xx status code
func (o *DcnClusterSoftwarePackageModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn cluster software package modify collection default response a status code equal to that given
func (o *DcnClusterSoftwarePackageModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn cluster software package modify collection default response
func (o *DcnClusterSoftwarePackageModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DcnClusterSoftwarePackageModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/software/packages][%d] dcn_cluster_software_package_modify_collection default %s", o._statusCode, payload)
}

func (o *DcnClusterSoftwarePackageModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/software/packages][%d] dcn_cluster_software_package_modify_collection default %s", o._statusCode, payload)
}

func (o *DcnClusterSoftwarePackageModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnClusterSoftwarePackageModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DcnClusterSoftwarePackageModifyCollectionBody dcn cluster software package modify collection body
swagger:model DcnClusterSoftwarePackageModifyCollectionBody
*/
type DcnClusterSoftwarePackageModifyCollectionBody struct {

	// links
	Links *models.DcnClusterSoftwarePackageInlineLinks `json:"_links,omitempty"`

	// DCN software compatibility with ONTAP.
	// Example: true
	// Read Only: true
	Compatible *bool `json:"compatible,omitempty"`

	// Indicates when this package was placed on the system.
	// Example: 2025-05-20 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// dcn cluster software package response inline records
	DcnClusterSoftwarePackageResponseInlineRecords []*models.DcnClusterSoftwarePackage `json:"records,omitempty"`

	// install status
	InstallStatus *models.DcnClusterSoftwareInstallStatus `json:"install_status,omitempty"`

	// Size of the package in bytes.
	// Example: 5368709120
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// True if this software package is currently pending for upgrade. Set to true to start the upgrade.
	// Example: true
	Staged *bool `json:"staged,omitempty"`

	// Current status of the package.
	// Read Only: true
	// Enum: ["available","validating","valid","invalid","unavailable","installing","installed","install_failed","processing","downloading"]
	State *string `json:"state,omitempty"`

	// UUID of this entry.
	// Example: f0ce5ac2-3347-4fa9-9335-ff8f2212bdad
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// version
	Version *models.DcnVersion `json:"version,omitempty"`
}

// Validate validates this dcn cluster software package modify collection body
func (o *DcnClusterSoftwarePackageModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDcnClusterSoftwarePackageResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInstallStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) validateDcnClusterSoftwarePackageResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DcnClusterSoftwarePackageResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DcnClusterSoftwarePackageResponseInlineRecords); i++ {
		if swag.IsZero(o.DcnClusterSoftwarePackageResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DcnClusterSoftwarePackageResponseInlineRecords[i] != nil {
			if err := o.DcnClusterSoftwarePackageResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) validateInstallStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.InstallStatus) { // not required
		return nil
	}

	if o.InstallStatus != nil {
		if err := o.InstallStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "install_status")
			}
			return err
		}
	}

	return nil
}

var dcnClusterSoftwarePackageModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","validating","valid","invalid","unavailable","installing","installed","install_failed","processing","downloading"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnClusterSoftwarePackageModifyCollectionBodyTypeStatePropEnum = append(dcnClusterSoftwarePackageModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// available
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateAvailable captures enum value "available"
	DcnClusterSoftwarePackageModifyCollectionBodyStateAvailable string = "available"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// validating
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateValidating captures enum value "validating"
	DcnClusterSoftwarePackageModifyCollectionBodyStateValidating string = "validating"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// valid
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateValid captures enum value "valid"
	DcnClusterSoftwarePackageModifyCollectionBodyStateValid string = "valid"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// invalid
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateInvalid captures enum value "invalid"
	DcnClusterSoftwarePackageModifyCollectionBodyStateInvalid string = "invalid"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// unavailable
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateUnavailable captures enum value "unavailable"
	DcnClusterSoftwarePackageModifyCollectionBodyStateUnavailable string = "unavailable"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// installing
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateInstalling captures enum value "installing"
	DcnClusterSoftwarePackageModifyCollectionBodyStateInstalling string = "installing"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// installed
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateInstalled captures enum value "installed"
	DcnClusterSoftwarePackageModifyCollectionBodyStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// install_failed
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateInstallFailed captures enum value "install_failed"
	DcnClusterSoftwarePackageModifyCollectionBodyStateInstallFailed string = "install_failed"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// processing
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateProcessing captures enum value "processing"
	DcnClusterSoftwarePackageModifyCollectionBodyStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBody
	// DcnClusterSoftwarePackageModifyCollectionBody
	// state
	// State
	// downloading
	// END DEBUGGING
	// DcnClusterSoftwarePackageModifyCollectionBodyStateDownloading captures enum value "downloading"
	DcnClusterSoftwarePackageModifyCollectionBodyStateDownloading string = "downloading"
)

// prop value enum
func (o *DcnClusterSoftwarePackageModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnClusterSoftwarePackageModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(o.Version) { // not required
		return nil
	}

	if o.Version != nil {
		if err := o.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster software package modify collection body based on the context it is used
func (o *DcnClusterSoftwarePackageModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCompatible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDcnClusterSoftwarePackageResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInstallStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateCompatible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"compatible", "body", o.Compatible); err != nil {
		return err
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateDcnClusterSoftwarePackageResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DcnClusterSoftwarePackageResponseInlineRecords); i++ {

		if o.DcnClusterSoftwarePackageResponseInlineRecords[i] != nil {
			if err := o.DcnClusterSoftwarePackageResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateInstallStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.InstallStatus != nil {
		if err := o.InstallStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "install_status")
			}
			return err
		}
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *DcnClusterSoftwarePackageModifyCollectionBody) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if o.Version != nil {
		if err := o.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnClusterSoftwarePackageModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnClusterSoftwarePackageModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DcnClusterSoftwarePackageModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DcnClusterSoftwarePackageInlineLinks dcn cluster software package inline links
swagger:model dcn_cluster_software_package_inline__links
*/
type DcnClusterSoftwarePackageInlineLinks struct {

	// self
	Self *models.DcnClusterSoftwarePackageInlineLinksInlineSelf `json:"self,omitempty"`
}

// Validate validates this dcn cluster software package inline links
func (o *DcnClusterSoftwarePackageInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnClusterSoftwarePackageInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster software package inline links based on the context it is used
func (o *DcnClusterSoftwarePackageInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnClusterSoftwarePackageInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnClusterSoftwarePackageInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnClusterSoftwarePackageInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnClusterSoftwarePackageInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DcnClusterSoftwarePackageInlineLinksInlineSelf dcn cluster software package inline links inline self
swagger:model dcn_cluster_software_package_inline__links_inline_self
*/
type DcnClusterSoftwarePackageInlineLinksInlineSelf struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this dcn cluster software package inline links inline self
func (o *DcnClusterSoftwarePackageInlineLinksInlineSelf) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnClusterSoftwarePackageInlineLinksInlineSelf) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster software package inline links inline self based on the context it is used
func (o *DcnClusterSoftwarePackageInlineLinksInlineSelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnClusterSoftwarePackageInlineLinksInlineSelf) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnClusterSoftwarePackageInlineLinksInlineSelf) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnClusterSoftwarePackageInlineLinksInlineSelf) UnmarshalBinary(b []byte) error {
	var res DcnClusterSoftwarePackageInlineLinksInlineSelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
