// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnClusterSoftwarePackageModifyReader is a Reader for the DcnClusterSoftwarePackageModify structure.
type DcnClusterSoftwarePackageModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnClusterSoftwarePackageModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnClusterSoftwarePackageModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnClusterSoftwarePackageModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnClusterSoftwarePackageModifyOK creates a DcnClusterSoftwarePackageModifyOK with default headers values
func NewDcnClusterSoftwarePackageModifyOK() *DcnClusterSoftwarePackageModifyOK {
	return &DcnClusterSoftwarePackageModifyOK{}
}

/*
DcnClusterSoftwarePackageModifyOK describes a response with status code 200, with default header values.

OK
*/
type DcnClusterSoftwarePackageModifyOK struct {
}

// IsSuccess returns true when this dcn cluster software package modify o k response has a 2xx status code
func (o *DcnClusterSoftwarePackageModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster software package modify o k response has a 3xx status code
func (o *DcnClusterSoftwarePackageModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster software package modify o k response has a 4xx status code
func (o *DcnClusterSoftwarePackageModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster software package modify o k response has a 5xx status code
func (o *DcnClusterSoftwarePackageModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster software package modify o k response a status code equal to that given
func (o *DcnClusterSoftwarePackageModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn cluster software package modify o k response
func (o *DcnClusterSoftwarePackageModifyOK) Code() int {
	return 200
}

func (o *DcnClusterSoftwarePackageModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /dcn/cluster/software/packages/{uuid}][%d] dcnClusterSoftwarePackageModifyOK", 200)
}

func (o *DcnClusterSoftwarePackageModifyOK) String() string {
	return fmt.Sprintf("[PATCH /dcn/cluster/software/packages/{uuid}][%d] dcnClusterSoftwarePackageModifyOK", 200)
}

func (o *DcnClusterSoftwarePackageModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDcnClusterSoftwarePackageModifyDefault creates a DcnClusterSoftwarePackageModifyDefault with default headers values
func NewDcnClusterSoftwarePackageModifyDefault(code int) *DcnClusterSoftwarePackageModifyDefault {
	return &DcnClusterSoftwarePackageModifyDefault{
		_statusCode: code,
	}
}

/*
	DcnClusterSoftwarePackageModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 203882497 | DCN software package cannot be staged prior to creating an ONTAP cluster. |
| 203882498 | No data compute nodes have been discovered to stage the software upgrade to. |
| 203882499 | The 'staged' field is required to stage the DCN software upgrade. |
| 203882500 | The DCN software package cannot be unstaged. |
| 203882501 | The DCN software package is in a disallowed state to perform staging. |
| 203882502 | The DCN software package is already staged. |
| 203882503 | Internal error. Failed to determine compatibility of the DCN software package with the ONTAP cluster. |
| 203882504 | The selected DCN software package is not compatible with the current ONTAP cluster version. |
| 203882505 | Internal error. Failed to remove the pre-existing DCN software package. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DcnClusterSoftwarePackageModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn cluster software package modify default response has a 2xx status code
func (o *DcnClusterSoftwarePackageModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn cluster software package modify default response has a 3xx status code
func (o *DcnClusterSoftwarePackageModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn cluster software package modify default response has a 4xx status code
func (o *DcnClusterSoftwarePackageModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn cluster software package modify default response has a 5xx status code
func (o *DcnClusterSoftwarePackageModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn cluster software package modify default response a status code equal to that given
func (o *DcnClusterSoftwarePackageModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn cluster software package modify default response
func (o *DcnClusterSoftwarePackageModifyDefault) Code() int {
	return o._statusCode
}

func (o *DcnClusterSoftwarePackageModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/software/packages/{uuid}][%d] dcn_cluster_software_package_modify default %s", o._statusCode, payload)
}

func (o *DcnClusterSoftwarePackageModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/software/packages/{uuid}][%d] dcn_cluster_software_package_modify default %s", o._statusCode, payload)
}

func (o *DcnClusterSoftwarePackageModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnClusterSoftwarePackageModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
