// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDcnClusterSoftwarePackageUploadParams creates a new DcnClusterSoftwarePackageUploadParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDcnClusterSoftwarePackageUploadParams() *DcnClusterSoftwarePackageUploadParams {
	return &DcnClusterSoftwarePackageUploadParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDcnClusterSoftwarePackageUploadParamsWithTimeout creates a new DcnClusterSoftwarePackageUploadParams object
// with the ability to set a timeout on a request.
func NewDcnClusterSoftwarePackageUploadParamsWithTimeout(timeout time.Duration) *DcnClusterSoftwarePackageUploadParams {
	return &DcnClusterSoftwarePackageUploadParams{
		timeout: timeout,
	}
}

// NewDcnClusterSoftwarePackageUploadParamsWithContext creates a new DcnClusterSoftwarePackageUploadParams object
// with the ability to set a context for a request.
func NewDcnClusterSoftwarePackageUploadParamsWithContext(ctx context.Context) *DcnClusterSoftwarePackageUploadParams {
	return &DcnClusterSoftwarePackageUploadParams{
		Context: ctx,
	}
}

// NewDcnClusterSoftwarePackageUploadParamsWithHTTPClient creates a new DcnClusterSoftwarePackageUploadParams object
// with the ability to set a custom HTTPClient for a request.
func NewDcnClusterSoftwarePackageUploadParamsWithHTTPClient(client *http.Client) *DcnClusterSoftwarePackageUploadParams {
	return &DcnClusterSoftwarePackageUploadParams{
		HTTPClient: client,
	}
}

/*
DcnClusterSoftwarePackageUploadParams contains all the parameters to send to the API endpoint

	for the dcn cluster software package upload operation.

	Typically these are written to a http.Request.
*/
type DcnClusterSoftwarePackageUploadParams struct {

	/* File.

	   DCN package to upload.
	*/
	File runtime.NamedReadCloser

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the dcn cluster software package upload params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnClusterSoftwarePackageUploadParams) WithDefaults() *DcnClusterSoftwarePackageUploadParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dcn cluster software package upload params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnClusterSoftwarePackageUploadParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := DcnClusterSoftwarePackageUploadParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) WithTimeout(timeout time.Duration) *DcnClusterSoftwarePackageUploadParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) WithContext(ctx context.Context) *DcnClusterSoftwarePackageUploadParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) WithHTTPClient(client *http.Client) *DcnClusterSoftwarePackageUploadParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFile adds the file to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) WithFile(file runtime.NamedReadCloser) *DcnClusterSoftwarePackageUploadParams {
	o.SetFile(file)
	return o
}

// SetFile adds the file to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) SetFile(file runtime.NamedReadCloser) {
	o.File = file
}

// WithReturnRecords adds the returnRecords to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) WithReturnRecords(returnRecords *bool) *DcnClusterSoftwarePackageUploadParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the dcn cluster software package upload params
func (o *DcnClusterSoftwarePackageUploadParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *DcnClusterSoftwarePackageUploadParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.File != nil {

		if o.File != nil {
			// form file param file
			if err := r.SetFileParam("file", o.File); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
