// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnClusterSoftwarePackageUploadReader is a Reader for the DcnClusterSoftwarePackageUpload structure.
type DcnClusterSoftwarePackageUploadReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnClusterSoftwarePackageUploadReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnClusterSoftwarePackageUploadOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnClusterSoftwarePackageUploadDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnClusterSoftwarePackageUploadOK creates a DcnClusterSoftwarePackageUploadOK with default headers values
func NewDcnClusterSoftwarePackageUploadOK() *DcnClusterSoftwarePackageUploadOK {
	return &DcnClusterSoftwarePackageUploadOK{}
}

/*
DcnClusterSoftwarePackageUploadOK describes a response with status code 200, with default header values.

OK
*/
type DcnClusterSoftwarePackageUploadOK struct {
	Payload *models.DcnClusterSoftwarePackage
}

// IsSuccess returns true when this dcn cluster software package upload o k response has a 2xx status code
func (o *DcnClusterSoftwarePackageUploadOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster software package upload o k response has a 3xx status code
func (o *DcnClusterSoftwarePackageUploadOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster software package upload o k response has a 4xx status code
func (o *DcnClusterSoftwarePackageUploadOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster software package upload o k response has a 5xx status code
func (o *DcnClusterSoftwarePackageUploadOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster software package upload o k response a status code equal to that given
func (o *DcnClusterSoftwarePackageUploadOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn cluster software package upload o k response
func (o *DcnClusterSoftwarePackageUploadOK) Code() int {
	return 200
}

func (o *DcnClusterSoftwarePackageUploadOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/software/upload][%d] dcnClusterSoftwarePackageUploadOK %s", 200, payload)
}

func (o *DcnClusterSoftwarePackageUploadOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/software/upload][%d] dcnClusterSoftwarePackageUploadOK %s", 200, payload)
}

func (o *DcnClusterSoftwarePackageUploadOK) GetPayload() *models.DcnClusterSoftwarePackage {
	return o.Payload
}

func (o *DcnClusterSoftwarePackageUploadOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnClusterSoftwarePackage)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterSoftwarePackageUploadDefault creates a DcnClusterSoftwarePackageUploadDefault with default headers values
func NewDcnClusterSoftwarePackageUploadDefault(code int) *DcnClusterSoftwarePackageUploadDefault {
	return &DcnClusterSoftwarePackageUploadDefault{
		_statusCode: code,
	}
}

/*
	DcnClusterSoftwarePackageUploadDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10551359 | Internal error. Failed to process the package after download completed. Try uploading the file again or contact technical support for assistance. |
| 10551391 | Internal error. Contact technical support for assistance. |
| 10551496 | Firmware file already exists. |
| 10551797 | Internal error. Failed to create an entry for the software package. |
| 10551797 | Internal error. Failed to check if file upload is enabled. |
| 10551798 | File upload is disabled. Enable file upload by setting "ApacheUploadEnabled 1" in the web services configuration file or contact technical support for assistance. |
| 10551799 | The requested filename exceeds the maximum path length. Rename using a shorter name. |
| 10551800 | Internal error. Access permissions restrict file upload. This is likely due to a bad web jail setup. Contact technical support for assistance. |
| 10551801 | Internal error. A read/write error occurred when uploading this file. Contact technical support for assistance |
| 10551802 | An invalid argument was supplied to create a file handle. Try uploading the file again or contact technical support for assistance. |
| 10551803 | An unknown error occurred. Retry file upload operation again or contact technical support for assistance. |
| 10551804 | Internal error. There is not sufficient space in the file upload directory to upload this file. Contact technical support for assistance. |
| 10551805 | Internal error in JAIL setup. Contact technical support for assistance. |
| 10551806 | Internal error. Failed to write to file in the web jail directory. Contact technical support for assistance. |
| 10551807 | The request must only contain a single file. More than one file per request is not supported. |
| 10551808 | The request must be of type multipart/form-data. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DcnClusterSoftwarePackageUploadDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn cluster software package upload default response has a 2xx status code
func (o *DcnClusterSoftwarePackageUploadDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn cluster software package upload default response has a 3xx status code
func (o *DcnClusterSoftwarePackageUploadDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn cluster software package upload default response has a 4xx status code
func (o *DcnClusterSoftwarePackageUploadDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn cluster software package upload default response has a 5xx status code
func (o *DcnClusterSoftwarePackageUploadDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn cluster software package upload default response a status code equal to that given
func (o *DcnClusterSoftwarePackageUploadDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn cluster software package upload default response
func (o *DcnClusterSoftwarePackageUploadDefault) Code() int {
	return o._statusCode
}

func (o *DcnClusterSoftwarePackageUploadDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/software/upload][%d] dcn_cluster_software_package_upload default %s", o._statusCode, payload)
}

func (o *DcnClusterSoftwarePackageUploadDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/software/upload][%d] dcn_cluster_software_package_upload default %s", o._statusCode, payload)
}

func (o *DcnClusterSoftwarePackageUploadDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnClusterSoftwarePackageUploadDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
