// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeCollectionGetReader is a Reader for the DcnNodeCollectionGet structure.
type DcnNodeCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeCollectionGetOK creates a DcnNodeCollectionGetOK with default headers values
func NewDcnNodeCollectionGetOK() *DcnNodeCollectionGetOK {
	return &DcnNodeCollectionGetOK{}
}

/*
DcnNodeCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeCollectionGetOK struct {
	Payload *models.DcnNodeResponse
}

// IsSuccess returns true when this dcn node collection get o k response has a 2xx status code
func (o *DcnNodeCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node collection get o k response has a 3xx status code
func (o *DcnNodeCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node collection get o k response has a 4xx status code
func (o *DcnNodeCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node collection get o k response has a 5xx status code
func (o *DcnNodeCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node collection get o k response a status code equal to that given
func (o *DcnNodeCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node collection get o k response
func (o *DcnNodeCollectionGetOK) Code() int {
	return 200
}

func (o *DcnNodeCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes][%d] dcnNodeCollectionGetOK %s", 200, payload)
}

func (o *DcnNodeCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes][%d] dcnNodeCollectionGetOK %s", 200, payload)
}

func (o *DcnNodeCollectionGetOK) GetPayload() *models.DcnNodeResponse {
	return o.Payload
}

func (o *DcnNodeCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeCollectionGetDefault creates a DcnNodeCollectionGetDefault with default headers values
func NewDcnNodeCollectionGetDefault(code int) *DcnNodeCollectionGetDefault {
	return &DcnNodeCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DcnNodeCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DcnNodeCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node collection get default response has a 2xx status code
func (o *DcnNodeCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node collection get default response has a 3xx status code
func (o *DcnNodeCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node collection get default response has a 4xx status code
func (o *DcnNodeCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node collection get default response has a 5xx status code
func (o *DcnNodeCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node collection get default response a status code equal to that given
func (o *DcnNodeCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node collection get default response
func (o *DcnNodeCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes][%d] dcn_node_collection_get default %s", o._statusCode, payload)
}

func (o *DcnNodeCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes][%d] dcn_node_collection_get default %s", o._statusCode, payload)
}

func (o *DcnNodeCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
