// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeCreateReader is a Reader for the DcnNodeCreate structure.
type DcnNodeCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDcnNodeCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDcnNodeCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeCreateCreated creates a DcnNodeCreateCreated with default headers values
func NewDcnNodeCreateCreated() *DcnNodeCreateCreated {
	return &DcnNodeCreateCreated{}
}

/*
DcnNodeCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DcnNodeCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DcnNodeJobLinkResponse
}

// IsSuccess returns true when this dcn node create created response has a 2xx status code
func (o *DcnNodeCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node create created response has a 3xx status code
func (o *DcnNodeCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node create created response has a 4xx status code
func (o *DcnNodeCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node create created response has a 5xx status code
func (o *DcnNodeCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node create created response a status code equal to that given
func (o *DcnNodeCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the dcn node create created response
func (o *DcnNodeCreateCreated) Code() int {
	return 201
}

func (o *DcnNodeCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/nodes][%d] dcnNodeCreateCreated %s", 201, payload)
}

func (o *DcnNodeCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/nodes][%d] dcnNodeCreateCreated %s", 201, payload)
}

func (o *DcnNodeCreateCreated) GetPayload() *models.DcnNodeJobLinkResponse {
	return o.Payload
}

func (o *DcnNodeCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DcnNodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeCreateAccepted creates a DcnNodeCreateAccepted with default headers values
func NewDcnNodeCreateAccepted() *DcnNodeCreateAccepted {
	return &DcnNodeCreateAccepted{}
}

/*
DcnNodeCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DcnNodeCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DcnNodeJobLinkResponse
}

// IsSuccess returns true when this dcn node create accepted response has a 2xx status code
func (o *DcnNodeCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node create accepted response has a 3xx status code
func (o *DcnNodeCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node create accepted response has a 4xx status code
func (o *DcnNodeCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node create accepted response has a 5xx status code
func (o *DcnNodeCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node create accepted response a status code equal to that given
func (o *DcnNodeCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the dcn node create accepted response
func (o *DcnNodeCreateAccepted) Code() int {
	return 202
}

func (o *DcnNodeCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/nodes][%d] dcnNodeCreateAccepted %s", 202, payload)
}

func (o *DcnNodeCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/nodes][%d] dcnNodeCreateAccepted %s", 202, payload)
}

func (o *DcnNodeCreateAccepted) GetPayload() *models.DcnNodeJobLinkResponse {
	return o.Payload
}

func (o *DcnNodeCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DcnNodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeCreateDefault creates a DcnNodeCreateDefault with default headers values
func NewDcnNodeCreateDefault(code int) *DcnNodeCreateDefault {
	return &DcnNodeCreateDefault{
		_statusCode: code,
	}
}

/*
DcnNodeCreateDefault describes a response with status code -1, with default header values.

Error
*/
type DcnNodeCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node create default response has a 2xx status code
func (o *DcnNodeCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node create default response has a 3xx status code
func (o *DcnNodeCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node create default response has a 4xx status code
func (o *DcnNodeCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node create default response has a 5xx status code
func (o *DcnNodeCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node create default response a status code equal to that given
func (o *DcnNodeCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node create default response
func (o *DcnNodeCreateDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/nodes][%d] dcn_node_create default %s", o._statusCode, payload)
}

func (o *DcnNodeCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster/nodes][%d] dcn_node_create default %s", o._statusCode, payload)
}

func (o *DcnNodeCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
