// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDcnNodeDeleteCollectionParams creates a new DcnNodeDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDcnNodeDeleteCollectionParams() *DcnNodeDeleteCollectionParams {
	return &DcnNodeDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDcnNodeDeleteCollectionParamsWithTimeout creates a new DcnNodeDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewDcnNodeDeleteCollectionParamsWithTimeout(timeout time.Duration) *DcnNodeDeleteCollectionParams {
	return &DcnNodeDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewDcnNodeDeleteCollectionParamsWithContext creates a new DcnNodeDeleteCollectionParams object
// with the ability to set a context for a request.
func NewDcnNodeDeleteCollectionParamsWithContext(ctx context.Context) *DcnNodeDeleteCollectionParams {
	return &DcnNodeDeleteCollectionParams{
		Context: ctx,
	}
}

// NewDcnNodeDeleteCollectionParamsWithHTTPClient creates a new DcnNodeDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDcnNodeDeleteCollectionParamsWithHTTPClient(client *http.Client) *DcnNodeDeleteCollectionParams {
	return &DcnNodeDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
DcnNodeDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the dcn node delete collection operation.

	Typically these are written to a http.Request.
*/
type DcnNodeDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Date.

	   Filter by date
	*/
	Date *string

	/* ErrorCount.

	   Filter by error.count
	*/
	ErrorCount *int64

	/* ErrorMessage.

	   Filter by error.message
	*/
	ErrorMessage *string

	/* ErrorUnitType.

	   Filter by error.unit_type
	*/
	ErrorUnitType *string

	/* HardwareBoard.

	   Filter by hardware.board
	*/
	HardwareBoard *string

	/* HardwareCPUCount.

	   Filter by hardware.cpu.count
	*/
	HardwareCPUCount *int64

	/* HardwareCPUFirmwareRelease.

	   Filter by hardware.cpu.firmware_release
	*/
	HardwareCPUFirmwareRelease *string

	/* HardwareCPUMemorySize.

	   Filter by hardware.cpu.memory_size
	*/
	HardwareCPUMemorySize *int64

	/* HardwareCPUProcessor.

	   Filter by hardware.cpu.processor
	*/
	HardwareCPUProcessor *string

	/* HardwareFrusCount.

	   Filter by hardware.frus.count
	*/
	HardwareFrusCount *int64

	/* HardwareFrusFruType.

	   Filter by hardware.frus.fru_type
	*/
	HardwareFrusFruType *string

	/* HardwareFrusID.

	   Filter by hardware.frus.id
	*/
	HardwareFrusID *string

	/* HardwareGpuCount.

	   Filter by hardware.gpu.count
	*/
	HardwareGpuCount *int64

	/* HardwareGpuFirmwareRelease.

	   Filter by hardware.gpu.firmware_release
	*/
	HardwareGpuFirmwareRelease *string

	/* HardwareGpuMemorySize.

	   Filter by hardware.gpu.memory_size
	*/
	HardwareGpuMemorySize *int64

	/* HardwareGpuProcessor.

	   Filter by hardware.gpu.processor
	*/
	HardwareGpuProcessor *string

	/* Info.

	   Info specification
	*/
	Info DcnNodeDeleteCollectionBody

	/* Location.

	   Filter by location
	*/
	Location *string

	/* Membership.

	   Filter by membership
	*/
	Membership *string

	/* MetricCPUMemoryUsed.

	   Filter by metric.cpu.memory_used
	*/
	MetricCPUMemoryUsed *int64

	/* MetricCPUProcessorUtilization.

	   Filter by metric.cpu.processor_utilization
	*/
	MetricCPUProcessorUtilization *int64

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricGpuMemoryUsed.

	   Filter by metric.gpu.memory_used
	*/
	MetricGpuMemoryUsed *int64

	/* MetricGpuProcessorUtilization.

	   Filter by metric.gpu.processor_utilization
	*/
	MetricGpuProcessorUtilization *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* MetricUUID.

	   Filter by metric.uuid
	*/
	MetricUUID *string

	/* Model.

	   Filter by model
	*/
	Model *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NetworkExternalInterfaceMacAddress.

	   Filter by network.external_interface.mac_address
	*/
	NetworkExternalInterfaceMacAddress *string

	/* NetworkExternalInterfaceMtu.

	   Filter by network.external_interface.mtu
	*/
	NetworkExternalInterfaceMtu *int64

	/* NetworkExternalInterfaceName.

	   Filter by network.external_interface.name
	*/
	NetworkExternalInterfaceName *string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SoftwareCompatibility.

	   Filter by software.compatibility
	*/
	SoftwareCompatibility *string

	/* SoftwareVersionFull.

	   Filter by software.version.full
	*/
	SoftwareVersionFull *string

	/* SoftwareVersionGeneration.

	   Filter by software.version.generation
	*/
	SoftwareVersionGeneration *int64

	/* SoftwareVersionMajor.

	   Filter by software.version.major
	*/
	SoftwareVersionMajor *int64

	/* SoftwareVersionMinor.

	   Filter by software.version.minor
	*/
	SoftwareVersionMinor *int64

	/* SoftwareVersionPatch.

	   Filter by software.version.patch
	*/
	SoftwareVersionPatch *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsCPUMemoryUsed.

	   Filter by statistics.cpu.memory_used
	*/
	StatisticsCPUMemoryUsed *int64

	/* StatisticsCPUProcessorUtilizationBase.

	   Filter by statistics.cpu.processor_utilization_base
	*/
	StatisticsCPUProcessorUtilizationBase *int64

	/* StatisticsCPUProcessorUtilizationRaw.

	   Filter by statistics.cpu.processor_utilization_raw
	*/
	StatisticsCPUProcessorUtilizationRaw *int64

	/* StatisticsGpuMemoryUsed.

	   Filter by statistics.gpu.memory_used
	*/
	StatisticsGpuMemoryUsed *int64

	/* StatisticsGpuProcessorUtilizationBase.

	   Filter by statistics.gpu.processor_utilization_base
	*/
	StatisticsGpuProcessorUtilizationBase *int64

	/* StatisticsGpuProcessorUtilizationRaw.

	   Filter by statistics.gpu.processor_utilization_raw
	*/
	StatisticsGpuProcessorUtilizationRaw *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SystemID.

	   Filter by system_id
	*/
	SystemID *string

	/* Uptime.

	   Filter by uptime
	*/
	Uptime *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VendorSerialNumber.

	   Filter by vendor_serial_number
	*/
	VendorSerialNumber *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the dcn node delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnNodeDeleteCollectionParams) WithDefaults() *DcnNodeDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dcn node delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnNodeDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := DcnNodeDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithTimeout(timeout time.Duration) *DcnNodeDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithContext(ctx context.Context) *DcnNodeDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHTTPClient(client *http.Client) *DcnNodeDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DcnNodeDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDate adds the date to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithDate(date *string) *DcnNodeDeleteCollectionParams {
	o.SetDate(date)
	return o
}

// SetDate adds the date to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetDate(date *string) {
	o.Date = date
}

// WithErrorCount adds the errorCount to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithErrorCount(errorCount *int64) *DcnNodeDeleteCollectionParams {
	o.SetErrorCount(errorCount)
	return o
}

// SetErrorCount adds the errorCount to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetErrorCount(errorCount *int64) {
	o.ErrorCount = errorCount
}

// WithErrorMessage adds the errorMessage to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithErrorMessage(errorMessage *string) *DcnNodeDeleteCollectionParams {
	o.SetErrorMessage(errorMessage)
	return o
}

// SetErrorMessage adds the errorMessage to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetErrorMessage(errorMessage *string) {
	o.ErrorMessage = errorMessage
}

// WithErrorUnitType adds the errorUnitType to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithErrorUnitType(errorUnitType *string) *DcnNodeDeleteCollectionParams {
	o.SetErrorUnitType(errorUnitType)
	return o
}

// SetErrorUnitType adds the errorUnitType to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetErrorUnitType(errorUnitType *string) {
	o.ErrorUnitType = errorUnitType
}

// WithHardwareBoard adds the hardwareBoard to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareBoard(hardwareBoard *string) *DcnNodeDeleteCollectionParams {
	o.SetHardwareBoard(hardwareBoard)
	return o
}

// SetHardwareBoard adds the hardwareBoard to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareBoard(hardwareBoard *string) {
	o.HardwareBoard = hardwareBoard
}

// WithHardwareCPUCount adds the hardwareCPUCount to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareCPUCount(hardwareCPUCount *int64) *DcnNodeDeleteCollectionParams {
	o.SetHardwareCPUCount(hardwareCPUCount)
	return o
}

// SetHardwareCPUCount adds the hardwareCpuCount to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareCPUCount(hardwareCPUCount *int64) {
	o.HardwareCPUCount = hardwareCPUCount
}

// WithHardwareCPUFirmwareRelease adds the hardwareCPUFirmwareRelease to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareCPUFirmwareRelease(hardwareCPUFirmwareRelease *string) *DcnNodeDeleteCollectionParams {
	o.SetHardwareCPUFirmwareRelease(hardwareCPUFirmwareRelease)
	return o
}

// SetHardwareCPUFirmwareRelease adds the hardwareCpuFirmwareRelease to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareCPUFirmwareRelease(hardwareCPUFirmwareRelease *string) {
	o.HardwareCPUFirmwareRelease = hardwareCPUFirmwareRelease
}

// WithHardwareCPUMemorySize adds the hardwareCPUMemorySize to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareCPUMemorySize(hardwareCPUMemorySize *int64) *DcnNodeDeleteCollectionParams {
	o.SetHardwareCPUMemorySize(hardwareCPUMemorySize)
	return o
}

// SetHardwareCPUMemorySize adds the hardwareCpuMemorySize to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareCPUMemorySize(hardwareCPUMemorySize *int64) {
	o.HardwareCPUMemorySize = hardwareCPUMemorySize
}

// WithHardwareCPUProcessor adds the hardwareCPUProcessor to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareCPUProcessor(hardwareCPUProcessor *string) *DcnNodeDeleteCollectionParams {
	o.SetHardwareCPUProcessor(hardwareCPUProcessor)
	return o
}

// SetHardwareCPUProcessor adds the hardwareCpuProcessor to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareCPUProcessor(hardwareCPUProcessor *string) {
	o.HardwareCPUProcessor = hardwareCPUProcessor
}

// WithHardwareFrusCount adds the hardwareFrusCount to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareFrusCount(hardwareFrusCount *int64) *DcnNodeDeleteCollectionParams {
	o.SetHardwareFrusCount(hardwareFrusCount)
	return o
}

// SetHardwareFrusCount adds the hardwareFrusCount to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareFrusCount(hardwareFrusCount *int64) {
	o.HardwareFrusCount = hardwareFrusCount
}

// WithHardwareFrusFruType adds the hardwareFrusFruType to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareFrusFruType(hardwareFrusFruType *string) *DcnNodeDeleteCollectionParams {
	o.SetHardwareFrusFruType(hardwareFrusFruType)
	return o
}

// SetHardwareFrusFruType adds the hardwareFrusFruType to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareFrusFruType(hardwareFrusFruType *string) {
	o.HardwareFrusFruType = hardwareFrusFruType
}

// WithHardwareFrusID adds the hardwareFrusID to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareFrusID(hardwareFrusID *string) *DcnNodeDeleteCollectionParams {
	o.SetHardwareFrusID(hardwareFrusID)
	return o
}

// SetHardwareFrusID adds the hardwareFrusId to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareFrusID(hardwareFrusID *string) {
	o.HardwareFrusID = hardwareFrusID
}

// WithHardwareGpuCount adds the hardwareGpuCount to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareGpuCount(hardwareGpuCount *int64) *DcnNodeDeleteCollectionParams {
	o.SetHardwareGpuCount(hardwareGpuCount)
	return o
}

// SetHardwareGpuCount adds the hardwareGpuCount to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareGpuCount(hardwareGpuCount *int64) {
	o.HardwareGpuCount = hardwareGpuCount
}

// WithHardwareGpuFirmwareRelease adds the hardwareGpuFirmwareRelease to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareGpuFirmwareRelease(hardwareGpuFirmwareRelease *string) *DcnNodeDeleteCollectionParams {
	o.SetHardwareGpuFirmwareRelease(hardwareGpuFirmwareRelease)
	return o
}

// SetHardwareGpuFirmwareRelease adds the hardwareGpuFirmwareRelease to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareGpuFirmwareRelease(hardwareGpuFirmwareRelease *string) {
	o.HardwareGpuFirmwareRelease = hardwareGpuFirmwareRelease
}

// WithHardwareGpuMemorySize adds the hardwareGpuMemorySize to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareGpuMemorySize(hardwareGpuMemorySize *int64) *DcnNodeDeleteCollectionParams {
	o.SetHardwareGpuMemorySize(hardwareGpuMemorySize)
	return o
}

// SetHardwareGpuMemorySize adds the hardwareGpuMemorySize to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareGpuMemorySize(hardwareGpuMemorySize *int64) {
	o.HardwareGpuMemorySize = hardwareGpuMemorySize
}

// WithHardwareGpuProcessor adds the hardwareGpuProcessor to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithHardwareGpuProcessor(hardwareGpuProcessor *string) *DcnNodeDeleteCollectionParams {
	o.SetHardwareGpuProcessor(hardwareGpuProcessor)
	return o
}

// SetHardwareGpuProcessor adds the hardwareGpuProcessor to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetHardwareGpuProcessor(hardwareGpuProcessor *string) {
	o.HardwareGpuProcessor = hardwareGpuProcessor
}

// WithInfo adds the info to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithInfo(info DcnNodeDeleteCollectionBody) *DcnNodeDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetInfo(info DcnNodeDeleteCollectionBody) {
	o.Info = info
}

// WithLocation adds the location to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithLocation(location *string) *DcnNodeDeleteCollectionParams {
	o.SetLocation(location)
	return o
}

// SetLocation adds the location to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetLocation(location *string) {
	o.Location = location
}

// WithMembership adds the membership to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMembership(membership *string) *DcnNodeDeleteCollectionParams {
	o.SetMembership(membership)
	return o
}

// SetMembership adds the membership to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMembership(membership *string) {
	o.Membership = membership
}

// WithMetricCPUMemoryUsed adds the metricCPUMemoryUsed to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMetricCPUMemoryUsed(metricCPUMemoryUsed *int64) *DcnNodeDeleteCollectionParams {
	o.SetMetricCPUMemoryUsed(metricCPUMemoryUsed)
	return o
}

// SetMetricCPUMemoryUsed adds the metricCpuMemoryUsed to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMetricCPUMemoryUsed(metricCPUMemoryUsed *int64) {
	o.MetricCPUMemoryUsed = metricCPUMemoryUsed
}

// WithMetricCPUProcessorUtilization adds the metricCPUProcessorUtilization to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMetricCPUProcessorUtilization(metricCPUProcessorUtilization *int64) *DcnNodeDeleteCollectionParams {
	o.SetMetricCPUProcessorUtilization(metricCPUProcessorUtilization)
	return o
}

// SetMetricCPUProcessorUtilization adds the metricCpuProcessorUtilization to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMetricCPUProcessorUtilization(metricCPUProcessorUtilization *int64) {
	o.MetricCPUProcessorUtilization = metricCPUProcessorUtilization
}

// WithMetricDuration adds the metricDuration to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMetricDuration(metricDuration *string) *DcnNodeDeleteCollectionParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricGpuMemoryUsed adds the metricGpuMemoryUsed to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMetricGpuMemoryUsed(metricGpuMemoryUsed *int64) *DcnNodeDeleteCollectionParams {
	o.SetMetricGpuMemoryUsed(metricGpuMemoryUsed)
	return o
}

// SetMetricGpuMemoryUsed adds the metricGpuMemoryUsed to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMetricGpuMemoryUsed(metricGpuMemoryUsed *int64) {
	o.MetricGpuMemoryUsed = metricGpuMemoryUsed
}

// WithMetricGpuProcessorUtilization adds the metricGpuProcessorUtilization to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMetricGpuProcessorUtilization(metricGpuProcessorUtilization *int64) *DcnNodeDeleteCollectionParams {
	o.SetMetricGpuProcessorUtilization(metricGpuProcessorUtilization)
	return o
}

// SetMetricGpuProcessorUtilization adds the metricGpuProcessorUtilization to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMetricGpuProcessorUtilization(metricGpuProcessorUtilization *int64) {
	o.MetricGpuProcessorUtilization = metricGpuProcessorUtilization
}

// WithMetricStatus adds the metricStatus to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMetricStatus(metricStatus *string) *DcnNodeDeleteCollectionParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricTimestamp adds the metricTimestamp to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMetricTimestamp(metricTimestamp *string) *DcnNodeDeleteCollectionParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithMetricUUID adds the metricUUID to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithMetricUUID(metricUUID *string) *DcnNodeDeleteCollectionParams {
	o.SetMetricUUID(metricUUID)
	return o
}

// SetMetricUUID adds the metricUuid to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetMetricUUID(metricUUID *string) {
	o.MetricUUID = metricUUID
}

// WithModel adds the model to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithModel(model *string) *DcnNodeDeleteCollectionParams {
	o.SetModel(model)
	return o
}

// SetModel adds the model to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetModel(model *string) {
	o.Model = model
}

// WithName adds the name to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithName(name *string) *DcnNodeDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNetworkExternalInterfaceMacAddress adds the networkExternalInterfaceMacAddress to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithNetworkExternalInterfaceMacAddress(networkExternalInterfaceMacAddress *string) *DcnNodeDeleteCollectionParams {
	o.SetNetworkExternalInterfaceMacAddress(networkExternalInterfaceMacAddress)
	return o
}

// SetNetworkExternalInterfaceMacAddress adds the networkExternalInterfaceMacAddress to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetNetworkExternalInterfaceMacAddress(networkExternalInterfaceMacAddress *string) {
	o.NetworkExternalInterfaceMacAddress = networkExternalInterfaceMacAddress
}

// WithNetworkExternalInterfaceMtu adds the networkExternalInterfaceMtu to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithNetworkExternalInterfaceMtu(networkExternalInterfaceMtu *int64) *DcnNodeDeleteCollectionParams {
	o.SetNetworkExternalInterfaceMtu(networkExternalInterfaceMtu)
	return o
}

// SetNetworkExternalInterfaceMtu adds the networkExternalInterfaceMtu to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetNetworkExternalInterfaceMtu(networkExternalInterfaceMtu *int64) {
	o.NetworkExternalInterfaceMtu = networkExternalInterfaceMtu
}

// WithNetworkExternalInterfaceName adds the networkExternalInterfaceName to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithNetworkExternalInterfaceName(networkExternalInterfaceName *string) *DcnNodeDeleteCollectionParams {
	o.SetNetworkExternalInterfaceName(networkExternalInterfaceName)
	return o
}

// SetNetworkExternalInterfaceName adds the networkExternalInterfaceName to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetNetworkExternalInterfaceName(networkExternalInterfaceName *string) {
	o.NetworkExternalInterfaceName = networkExternalInterfaceName
}

// WithOwner adds the owner to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithOwner(owner *string) *DcnNodeDeleteCollectionParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithReturnRecords adds the returnRecords to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *DcnNodeDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *DcnNodeDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialNumber adds the serialNumber to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSerialNumber(serialNumber *string) *DcnNodeDeleteCollectionParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithSerialRecords adds the serialRecords to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *DcnNodeDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSoftwareCompatibility adds the softwareCompatibility to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSoftwareCompatibility(softwareCompatibility *string) *DcnNodeDeleteCollectionParams {
	o.SetSoftwareCompatibility(softwareCompatibility)
	return o
}

// SetSoftwareCompatibility adds the softwareCompatibility to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSoftwareCompatibility(softwareCompatibility *string) {
	o.SoftwareCompatibility = softwareCompatibility
}

// WithSoftwareVersionFull adds the softwareVersionFull to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSoftwareVersionFull(softwareVersionFull *string) *DcnNodeDeleteCollectionParams {
	o.SetSoftwareVersionFull(softwareVersionFull)
	return o
}

// SetSoftwareVersionFull adds the softwareVersionFull to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSoftwareVersionFull(softwareVersionFull *string) {
	o.SoftwareVersionFull = softwareVersionFull
}

// WithSoftwareVersionGeneration adds the softwareVersionGeneration to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSoftwareVersionGeneration(softwareVersionGeneration *int64) *DcnNodeDeleteCollectionParams {
	o.SetSoftwareVersionGeneration(softwareVersionGeneration)
	return o
}

// SetSoftwareVersionGeneration adds the softwareVersionGeneration to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSoftwareVersionGeneration(softwareVersionGeneration *int64) {
	o.SoftwareVersionGeneration = softwareVersionGeneration
}

// WithSoftwareVersionMajor adds the softwareVersionMajor to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSoftwareVersionMajor(softwareVersionMajor *int64) *DcnNodeDeleteCollectionParams {
	o.SetSoftwareVersionMajor(softwareVersionMajor)
	return o
}

// SetSoftwareVersionMajor adds the softwareVersionMajor to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSoftwareVersionMajor(softwareVersionMajor *int64) {
	o.SoftwareVersionMajor = softwareVersionMajor
}

// WithSoftwareVersionMinor adds the softwareVersionMinor to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSoftwareVersionMinor(softwareVersionMinor *int64) *DcnNodeDeleteCollectionParams {
	o.SetSoftwareVersionMinor(softwareVersionMinor)
	return o
}

// SetSoftwareVersionMinor adds the softwareVersionMinor to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSoftwareVersionMinor(softwareVersionMinor *int64) {
	o.SoftwareVersionMinor = softwareVersionMinor
}

// WithSoftwareVersionPatch adds the softwareVersionPatch to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSoftwareVersionPatch(softwareVersionPatch *string) *DcnNodeDeleteCollectionParams {
	o.SetSoftwareVersionPatch(softwareVersionPatch)
	return o
}

// SetSoftwareVersionPatch adds the softwareVersionPatch to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSoftwareVersionPatch(softwareVersionPatch *string) {
	o.SoftwareVersionPatch = softwareVersionPatch
}

// WithState adds the state to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithState(state *string) *DcnNodeDeleteCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsCPUMemoryUsed adds the statisticsCPUMemoryUsed to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithStatisticsCPUMemoryUsed(statisticsCPUMemoryUsed *int64) *DcnNodeDeleteCollectionParams {
	o.SetStatisticsCPUMemoryUsed(statisticsCPUMemoryUsed)
	return o
}

// SetStatisticsCPUMemoryUsed adds the statisticsCpuMemoryUsed to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetStatisticsCPUMemoryUsed(statisticsCPUMemoryUsed *int64) {
	o.StatisticsCPUMemoryUsed = statisticsCPUMemoryUsed
}

// WithStatisticsCPUProcessorUtilizationBase adds the statisticsCPUProcessorUtilizationBase to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithStatisticsCPUProcessorUtilizationBase(statisticsCPUProcessorUtilizationBase *int64) *DcnNodeDeleteCollectionParams {
	o.SetStatisticsCPUProcessorUtilizationBase(statisticsCPUProcessorUtilizationBase)
	return o
}

// SetStatisticsCPUProcessorUtilizationBase adds the statisticsCpuProcessorUtilizationBase to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetStatisticsCPUProcessorUtilizationBase(statisticsCPUProcessorUtilizationBase *int64) {
	o.StatisticsCPUProcessorUtilizationBase = statisticsCPUProcessorUtilizationBase
}

// WithStatisticsCPUProcessorUtilizationRaw adds the statisticsCPUProcessorUtilizationRaw to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithStatisticsCPUProcessorUtilizationRaw(statisticsCPUProcessorUtilizationRaw *int64) *DcnNodeDeleteCollectionParams {
	o.SetStatisticsCPUProcessorUtilizationRaw(statisticsCPUProcessorUtilizationRaw)
	return o
}

// SetStatisticsCPUProcessorUtilizationRaw adds the statisticsCpuProcessorUtilizationRaw to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetStatisticsCPUProcessorUtilizationRaw(statisticsCPUProcessorUtilizationRaw *int64) {
	o.StatisticsCPUProcessorUtilizationRaw = statisticsCPUProcessorUtilizationRaw
}

// WithStatisticsGpuMemoryUsed adds the statisticsGpuMemoryUsed to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithStatisticsGpuMemoryUsed(statisticsGpuMemoryUsed *int64) *DcnNodeDeleteCollectionParams {
	o.SetStatisticsGpuMemoryUsed(statisticsGpuMemoryUsed)
	return o
}

// SetStatisticsGpuMemoryUsed adds the statisticsGpuMemoryUsed to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetStatisticsGpuMemoryUsed(statisticsGpuMemoryUsed *int64) {
	o.StatisticsGpuMemoryUsed = statisticsGpuMemoryUsed
}

// WithStatisticsGpuProcessorUtilizationBase adds the statisticsGpuProcessorUtilizationBase to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithStatisticsGpuProcessorUtilizationBase(statisticsGpuProcessorUtilizationBase *int64) *DcnNodeDeleteCollectionParams {
	o.SetStatisticsGpuProcessorUtilizationBase(statisticsGpuProcessorUtilizationBase)
	return o
}

// SetStatisticsGpuProcessorUtilizationBase adds the statisticsGpuProcessorUtilizationBase to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetStatisticsGpuProcessorUtilizationBase(statisticsGpuProcessorUtilizationBase *int64) {
	o.StatisticsGpuProcessorUtilizationBase = statisticsGpuProcessorUtilizationBase
}

// WithStatisticsGpuProcessorUtilizationRaw adds the statisticsGpuProcessorUtilizationRaw to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithStatisticsGpuProcessorUtilizationRaw(statisticsGpuProcessorUtilizationRaw *int64) *DcnNodeDeleteCollectionParams {
	o.SetStatisticsGpuProcessorUtilizationRaw(statisticsGpuProcessorUtilizationRaw)
	return o
}

// SetStatisticsGpuProcessorUtilizationRaw adds the statisticsGpuProcessorUtilizationRaw to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetStatisticsGpuProcessorUtilizationRaw(statisticsGpuProcessorUtilizationRaw *int64) {
	o.StatisticsGpuProcessorUtilizationRaw = statisticsGpuProcessorUtilizationRaw
}

// WithStatisticsStatus adds the statisticsStatus to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithStatisticsStatus(statisticsStatus *string) *DcnNodeDeleteCollectionParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithStatisticsTimestamp(statisticsTimestamp *string) *DcnNodeDeleteCollectionParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSystemID adds the systemID to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithSystemID(systemID *string) *DcnNodeDeleteCollectionParams {
	o.SetSystemID(systemID)
	return o
}

// SetSystemID adds the systemId to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetSystemID(systemID *string) {
	o.SystemID = systemID
}

// WithUptime adds the uptime to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithUptime(uptime *int64) *DcnNodeDeleteCollectionParams {
	o.SetUptime(uptime)
	return o
}

// SetUptime adds the uptime to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetUptime(uptime *int64) {
	o.Uptime = uptime
}

// WithUUID adds the uuid to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithUUID(uuid *string) *DcnNodeDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVendorSerialNumber adds the vendorSerialNumber to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) WithVendorSerialNumber(vendorSerialNumber *string) *DcnNodeDeleteCollectionParams {
	o.SetVendorSerialNumber(vendorSerialNumber)
	return o
}

// SetVendorSerialNumber adds the vendorSerialNumber to the dcn node delete collection params
func (o *DcnNodeDeleteCollectionParams) SetVendorSerialNumber(vendorSerialNumber *string) {
	o.VendorSerialNumber = vendorSerialNumber
}

// WriteToRequest writes these params to a swagger request
func (o *DcnNodeDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Date != nil {

		// query param date
		var qrDate string

		if o.Date != nil {
			qrDate = *o.Date
		}
		qDate := qrDate
		if qDate != "" {

			if err := r.SetQueryParam("date", qDate); err != nil {
				return err
			}
		}
	}

	if o.ErrorCount != nil {

		// query param error.count
		var qrErrorCount int64

		if o.ErrorCount != nil {
			qrErrorCount = *o.ErrorCount
		}
		qErrorCount := swag.FormatInt64(qrErrorCount)
		if qErrorCount != "" {

			if err := r.SetQueryParam("error.count", qErrorCount); err != nil {
				return err
			}
		}
	}

	if o.ErrorMessage != nil {

		// query param error.message
		var qrErrorMessage string

		if o.ErrorMessage != nil {
			qrErrorMessage = *o.ErrorMessage
		}
		qErrorMessage := qrErrorMessage
		if qErrorMessage != "" {

			if err := r.SetQueryParam("error.message", qErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorUnitType != nil {

		// query param error.unit_type
		var qrErrorUnitType string

		if o.ErrorUnitType != nil {
			qrErrorUnitType = *o.ErrorUnitType
		}
		qErrorUnitType := qrErrorUnitType
		if qErrorUnitType != "" {

			if err := r.SetQueryParam("error.unit_type", qErrorUnitType); err != nil {
				return err
			}
		}
	}

	if o.HardwareBoard != nil {

		// query param hardware.board
		var qrHardwareBoard string

		if o.HardwareBoard != nil {
			qrHardwareBoard = *o.HardwareBoard
		}
		qHardwareBoard := qrHardwareBoard
		if qHardwareBoard != "" {

			if err := r.SetQueryParam("hardware.board", qHardwareBoard); err != nil {
				return err
			}
		}
	}

	if o.HardwareCPUCount != nil {

		// query param hardware.cpu.count
		var qrHardwareCPUCount int64

		if o.HardwareCPUCount != nil {
			qrHardwareCPUCount = *o.HardwareCPUCount
		}
		qHardwareCPUCount := swag.FormatInt64(qrHardwareCPUCount)
		if qHardwareCPUCount != "" {

			if err := r.SetQueryParam("hardware.cpu.count", qHardwareCPUCount); err != nil {
				return err
			}
		}
	}

	if o.HardwareCPUFirmwareRelease != nil {

		// query param hardware.cpu.firmware_release
		var qrHardwareCPUFirmwareRelease string

		if o.HardwareCPUFirmwareRelease != nil {
			qrHardwareCPUFirmwareRelease = *o.HardwareCPUFirmwareRelease
		}
		qHardwareCPUFirmwareRelease := qrHardwareCPUFirmwareRelease
		if qHardwareCPUFirmwareRelease != "" {

			if err := r.SetQueryParam("hardware.cpu.firmware_release", qHardwareCPUFirmwareRelease); err != nil {
				return err
			}
		}
	}

	if o.HardwareCPUMemorySize != nil {

		// query param hardware.cpu.memory_size
		var qrHardwareCPUMemorySize int64

		if o.HardwareCPUMemorySize != nil {
			qrHardwareCPUMemorySize = *o.HardwareCPUMemorySize
		}
		qHardwareCPUMemorySize := swag.FormatInt64(qrHardwareCPUMemorySize)
		if qHardwareCPUMemorySize != "" {

			if err := r.SetQueryParam("hardware.cpu.memory_size", qHardwareCPUMemorySize); err != nil {
				return err
			}
		}
	}

	if o.HardwareCPUProcessor != nil {

		// query param hardware.cpu.processor
		var qrHardwareCPUProcessor string

		if o.HardwareCPUProcessor != nil {
			qrHardwareCPUProcessor = *o.HardwareCPUProcessor
		}
		qHardwareCPUProcessor := qrHardwareCPUProcessor
		if qHardwareCPUProcessor != "" {

			if err := r.SetQueryParam("hardware.cpu.processor", qHardwareCPUProcessor); err != nil {
				return err
			}
		}
	}

	if o.HardwareFrusCount != nil {

		// query param hardware.frus.count
		var qrHardwareFrusCount int64

		if o.HardwareFrusCount != nil {
			qrHardwareFrusCount = *o.HardwareFrusCount
		}
		qHardwareFrusCount := swag.FormatInt64(qrHardwareFrusCount)
		if qHardwareFrusCount != "" {

			if err := r.SetQueryParam("hardware.frus.count", qHardwareFrusCount); err != nil {
				return err
			}
		}
	}

	if o.HardwareFrusFruType != nil {

		// query param hardware.frus.fru_type
		var qrHardwareFrusFruType string

		if o.HardwareFrusFruType != nil {
			qrHardwareFrusFruType = *o.HardwareFrusFruType
		}
		qHardwareFrusFruType := qrHardwareFrusFruType
		if qHardwareFrusFruType != "" {

			if err := r.SetQueryParam("hardware.frus.fru_type", qHardwareFrusFruType); err != nil {
				return err
			}
		}
	}

	if o.HardwareFrusID != nil {

		// query param hardware.frus.id
		var qrHardwareFrusID string

		if o.HardwareFrusID != nil {
			qrHardwareFrusID = *o.HardwareFrusID
		}
		qHardwareFrusID := qrHardwareFrusID
		if qHardwareFrusID != "" {

			if err := r.SetQueryParam("hardware.frus.id", qHardwareFrusID); err != nil {
				return err
			}
		}
	}

	if o.HardwareGpuCount != nil {

		// query param hardware.gpu.count
		var qrHardwareGpuCount int64

		if o.HardwareGpuCount != nil {
			qrHardwareGpuCount = *o.HardwareGpuCount
		}
		qHardwareGpuCount := swag.FormatInt64(qrHardwareGpuCount)
		if qHardwareGpuCount != "" {

			if err := r.SetQueryParam("hardware.gpu.count", qHardwareGpuCount); err != nil {
				return err
			}
		}
	}

	if o.HardwareGpuFirmwareRelease != nil {

		// query param hardware.gpu.firmware_release
		var qrHardwareGpuFirmwareRelease string

		if o.HardwareGpuFirmwareRelease != nil {
			qrHardwareGpuFirmwareRelease = *o.HardwareGpuFirmwareRelease
		}
		qHardwareGpuFirmwareRelease := qrHardwareGpuFirmwareRelease
		if qHardwareGpuFirmwareRelease != "" {

			if err := r.SetQueryParam("hardware.gpu.firmware_release", qHardwareGpuFirmwareRelease); err != nil {
				return err
			}
		}
	}

	if o.HardwareGpuMemorySize != nil {

		// query param hardware.gpu.memory_size
		var qrHardwareGpuMemorySize int64

		if o.HardwareGpuMemorySize != nil {
			qrHardwareGpuMemorySize = *o.HardwareGpuMemorySize
		}
		qHardwareGpuMemorySize := swag.FormatInt64(qrHardwareGpuMemorySize)
		if qHardwareGpuMemorySize != "" {

			if err := r.SetQueryParam("hardware.gpu.memory_size", qHardwareGpuMemorySize); err != nil {
				return err
			}
		}
	}

	if o.HardwareGpuProcessor != nil {

		// query param hardware.gpu.processor
		var qrHardwareGpuProcessor string

		if o.HardwareGpuProcessor != nil {
			qrHardwareGpuProcessor = *o.HardwareGpuProcessor
		}
		qHardwareGpuProcessor := qrHardwareGpuProcessor
		if qHardwareGpuProcessor != "" {

			if err := r.SetQueryParam("hardware.gpu.processor", qHardwareGpuProcessor); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Location != nil {

		// query param location
		var qrLocation string

		if o.Location != nil {
			qrLocation = *o.Location
		}
		qLocation := qrLocation
		if qLocation != "" {

			if err := r.SetQueryParam("location", qLocation); err != nil {
				return err
			}
		}
	}

	if o.Membership != nil {

		// query param membership
		var qrMembership string

		if o.Membership != nil {
			qrMembership = *o.Membership
		}
		qMembership := qrMembership
		if qMembership != "" {

			if err := r.SetQueryParam("membership", qMembership); err != nil {
				return err
			}
		}
	}

	if o.MetricCPUMemoryUsed != nil {

		// query param metric.cpu.memory_used
		var qrMetricCPUMemoryUsed int64

		if o.MetricCPUMemoryUsed != nil {
			qrMetricCPUMemoryUsed = *o.MetricCPUMemoryUsed
		}
		qMetricCPUMemoryUsed := swag.FormatInt64(qrMetricCPUMemoryUsed)
		if qMetricCPUMemoryUsed != "" {

			if err := r.SetQueryParam("metric.cpu.memory_used", qMetricCPUMemoryUsed); err != nil {
				return err
			}
		}
	}

	if o.MetricCPUProcessorUtilization != nil {

		// query param metric.cpu.processor_utilization
		var qrMetricCPUProcessorUtilization int64

		if o.MetricCPUProcessorUtilization != nil {
			qrMetricCPUProcessorUtilization = *o.MetricCPUProcessorUtilization
		}
		qMetricCPUProcessorUtilization := swag.FormatInt64(qrMetricCPUProcessorUtilization)
		if qMetricCPUProcessorUtilization != "" {

			if err := r.SetQueryParam("metric.cpu.processor_utilization", qMetricCPUProcessorUtilization); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricGpuMemoryUsed != nil {

		// query param metric.gpu.memory_used
		var qrMetricGpuMemoryUsed int64

		if o.MetricGpuMemoryUsed != nil {
			qrMetricGpuMemoryUsed = *o.MetricGpuMemoryUsed
		}
		qMetricGpuMemoryUsed := swag.FormatInt64(qrMetricGpuMemoryUsed)
		if qMetricGpuMemoryUsed != "" {

			if err := r.SetQueryParam("metric.gpu.memory_used", qMetricGpuMemoryUsed); err != nil {
				return err
			}
		}
	}

	if o.MetricGpuProcessorUtilization != nil {

		// query param metric.gpu.processor_utilization
		var qrMetricGpuProcessorUtilization int64

		if o.MetricGpuProcessorUtilization != nil {
			qrMetricGpuProcessorUtilization = *o.MetricGpuProcessorUtilization
		}
		qMetricGpuProcessorUtilization := swag.FormatInt64(qrMetricGpuProcessorUtilization)
		if qMetricGpuProcessorUtilization != "" {

			if err := r.SetQueryParam("metric.gpu.processor_utilization", qMetricGpuProcessorUtilization); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.MetricUUID != nil {

		// query param metric.uuid
		var qrMetricUUID string

		if o.MetricUUID != nil {
			qrMetricUUID = *o.MetricUUID
		}
		qMetricUUID := qrMetricUUID
		if qMetricUUID != "" {

			if err := r.SetQueryParam("metric.uuid", qMetricUUID); err != nil {
				return err
			}
		}
	}

	if o.Model != nil {

		// query param model
		var qrModel string

		if o.Model != nil {
			qrModel = *o.Model
		}
		qModel := qrModel
		if qModel != "" {

			if err := r.SetQueryParam("model", qModel); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NetworkExternalInterfaceMacAddress != nil {

		// query param network.external_interface.mac_address
		var qrNetworkExternalInterfaceMacAddress string

		if o.NetworkExternalInterfaceMacAddress != nil {
			qrNetworkExternalInterfaceMacAddress = *o.NetworkExternalInterfaceMacAddress
		}
		qNetworkExternalInterfaceMacAddress := qrNetworkExternalInterfaceMacAddress
		if qNetworkExternalInterfaceMacAddress != "" {

			if err := r.SetQueryParam("network.external_interface.mac_address", qNetworkExternalInterfaceMacAddress); err != nil {
				return err
			}
		}
	}

	if o.NetworkExternalInterfaceMtu != nil {

		// query param network.external_interface.mtu
		var qrNetworkExternalInterfaceMtu int64

		if o.NetworkExternalInterfaceMtu != nil {
			qrNetworkExternalInterfaceMtu = *o.NetworkExternalInterfaceMtu
		}
		qNetworkExternalInterfaceMtu := swag.FormatInt64(qrNetworkExternalInterfaceMtu)
		if qNetworkExternalInterfaceMtu != "" {

			if err := r.SetQueryParam("network.external_interface.mtu", qNetworkExternalInterfaceMtu); err != nil {
				return err
			}
		}
	}

	if o.NetworkExternalInterfaceName != nil {

		// query param network.external_interface.name
		var qrNetworkExternalInterfaceName string

		if o.NetworkExternalInterfaceName != nil {
			qrNetworkExternalInterfaceName = *o.NetworkExternalInterfaceName
		}
		qNetworkExternalInterfaceName := qrNetworkExternalInterfaceName
		if qNetworkExternalInterfaceName != "" {

			if err := r.SetQueryParam("network.external_interface.name", qNetworkExternalInterfaceName); err != nil {
				return err
			}
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SoftwareCompatibility != nil {

		// query param software.compatibility
		var qrSoftwareCompatibility string

		if o.SoftwareCompatibility != nil {
			qrSoftwareCompatibility = *o.SoftwareCompatibility
		}
		qSoftwareCompatibility := qrSoftwareCompatibility
		if qSoftwareCompatibility != "" {

			if err := r.SetQueryParam("software.compatibility", qSoftwareCompatibility); err != nil {
				return err
			}
		}
	}

	if o.SoftwareVersionFull != nil {

		// query param software.version.full
		var qrSoftwareVersionFull string

		if o.SoftwareVersionFull != nil {
			qrSoftwareVersionFull = *o.SoftwareVersionFull
		}
		qSoftwareVersionFull := qrSoftwareVersionFull
		if qSoftwareVersionFull != "" {

			if err := r.SetQueryParam("software.version.full", qSoftwareVersionFull); err != nil {
				return err
			}
		}
	}

	if o.SoftwareVersionGeneration != nil {

		// query param software.version.generation
		var qrSoftwareVersionGeneration int64

		if o.SoftwareVersionGeneration != nil {
			qrSoftwareVersionGeneration = *o.SoftwareVersionGeneration
		}
		qSoftwareVersionGeneration := swag.FormatInt64(qrSoftwareVersionGeneration)
		if qSoftwareVersionGeneration != "" {

			if err := r.SetQueryParam("software.version.generation", qSoftwareVersionGeneration); err != nil {
				return err
			}
		}
	}

	if o.SoftwareVersionMajor != nil {

		// query param software.version.major
		var qrSoftwareVersionMajor int64

		if o.SoftwareVersionMajor != nil {
			qrSoftwareVersionMajor = *o.SoftwareVersionMajor
		}
		qSoftwareVersionMajor := swag.FormatInt64(qrSoftwareVersionMajor)
		if qSoftwareVersionMajor != "" {

			if err := r.SetQueryParam("software.version.major", qSoftwareVersionMajor); err != nil {
				return err
			}
		}
	}

	if o.SoftwareVersionMinor != nil {

		// query param software.version.minor
		var qrSoftwareVersionMinor int64

		if o.SoftwareVersionMinor != nil {
			qrSoftwareVersionMinor = *o.SoftwareVersionMinor
		}
		qSoftwareVersionMinor := swag.FormatInt64(qrSoftwareVersionMinor)
		if qSoftwareVersionMinor != "" {

			if err := r.SetQueryParam("software.version.minor", qSoftwareVersionMinor); err != nil {
				return err
			}
		}
	}

	if o.SoftwareVersionPatch != nil {

		// query param software.version.patch
		var qrSoftwareVersionPatch string

		if o.SoftwareVersionPatch != nil {
			qrSoftwareVersionPatch = *o.SoftwareVersionPatch
		}
		qSoftwareVersionPatch := qrSoftwareVersionPatch
		if qSoftwareVersionPatch != "" {

			if err := r.SetQueryParam("software.version.patch", qSoftwareVersionPatch); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCPUMemoryUsed != nil {

		// query param statistics.cpu.memory_used
		var qrStatisticsCPUMemoryUsed int64

		if o.StatisticsCPUMemoryUsed != nil {
			qrStatisticsCPUMemoryUsed = *o.StatisticsCPUMemoryUsed
		}
		qStatisticsCPUMemoryUsed := swag.FormatInt64(qrStatisticsCPUMemoryUsed)
		if qStatisticsCPUMemoryUsed != "" {

			if err := r.SetQueryParam("statistics.cpu.memory_used", qStatisticsCPUMemoryUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCPUProcessorUtilizationBase != nil {

		// query param statistics.cpu.processor_utilization_base
		var qrStatisticsCPUProcessorUtilizationBase int64

		if o.StatisticsCPUProcessorUtilizationBase != nil {
			qrStatisticsCPUProcessorUtilizationBase = *o.StatisticsCPUProcessorUtilizationBase
		}
		qStatisticsCPUProcessorUtilizationBase := swag.FormatInt64(qrStatisticsCPUProcessorUtilizationBase)
		if qStatisticsCPUProcessorUtilizationBase != "" {

			if err := r.SetQueryParam("statistics.cpu.processor_utilization_base", qStatisticsCPUProcessorUtilizationBase); err != nil {
				return err
			}
		}
	}

	if o.StatisticsCPUProcessorUtilizationRaw != nil {

		// query param statistics.cpu.processor_utilization_raw
		var qrStatisticsCPUProcessorUtilizationRaw int64

		if o.StatisticsCPUProcessorUtilizationRaw != nil {
			qrStatisticsCPUProcessorUtilizationRaw = *o.StatisticsCPUProcessorUtilizationRaw
		}
		qStatisticsCPUProcessorUtilizationRaw := swag.FormatInt64(qrStatisticsCPUProcessorUtilizationRaw)
		if qStatisticsCPUProcessorUtilizationRaw != "" {

			if err := r.SetQueryParam("statistics.cpu.processor_utilization_raw", qStatisticsCPUProcessorUtilizationRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsGpuMemoryUsed != nil {

		// query param statistics.gpu.memory_used
		var qrStatisticsGpuMemoryUsed int64

		if o.StatisticsGpuMemoryUsed != nil {
			qrStatisticsGpuMemoryUsed = *o.StatisticsGpuMemoryUsed
		}
		qStatisticsGpuMemoryUsed := swag.FormatInt64(qrStatisticsGpuMemoryUsed)
		if qStatisticsGpuMemoryUsed != "" {

			if err := r.SetQueryParam("statistics.gpu.memory_used", qStatisticsGpuMemoryUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsGpuProcessorUtilizationBase != nil {

		// query param statistics.gpu.processor_utilization_base
		var qrStatisticsGpuProcessorUtilizationBase int64

		if o.StatisticsGpuProcessorUtilizationBase != nil {
			qrStatisticsGpuProcessorUtilizationBase = *o.StatisticsGpuProcessorUtilizationBase
		}
		qStatisticsGpuProcessorUtilizationBase := swag.FormatInt64(qrStatisticsGpuProcessorUtilizationBase)
		if qStatisticsGpuProcessorUtilizationBase != "" {

			if err := r.SetQueryParam("statistics.gpu.processor_utilization_base", qStatisticsGpuProcessorUtilizationBase); err != nil {
				return err
			}
		}
	}

	if o.StatisticsGpuProcessorUtilizationRaw != nil {

		// query param statistics.gpu.processor_utilization_raw
		var qrStatisticsGpuProcessorUtilizationRaw int64

		if o.StatisticsGpuProcessorUtilizationRaw != nil {
			qrStatisticsGpuProcessorUtilizationRaw = *o.StatisticsGpuProcessorUtilizationRaw
		}
		qStatisticsGpuProcessorUtilizationRaw := swag.FormatInt64(qrStatisticsGpuProcessorUtilizationRaw)
		if qStatisticsGpuProcessorUtilizationRaw != "" {

			if err := r.SetQueryParam("statistics.gpu.processor_utilization_raw", qStatisticsGpuProcessorUtilizationRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SystemID != nil {

		// query param system_id
		var qrSystemID string

		if o.SystemID != nil {
			qrSystemID = *o.SystemID
		}
		qSystemID := qrSystemID
		if qSystemID != "" {

			if err := r.SetQueryParam("system_id", qSystemID); err != nil {
				return err
			}
		}
	}

	if o.Uptime != nil {

		// query param uptime
		var qrUptime int64

		if o.Uptime != nil {
			qrUptime = *o.Uptime
		}
		qUptime := swag.FormatInt64(qrUptime)
		if qUptime != "" {

			if err := r.SetQueryParam("uptime", qUptime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VendorSerialNumber != nil {

		// query param vendor_serial_number
		var qrVendorSerialNumber string

		if o.VendorSerialNumber != nil {
			qrVendorSerialNumber = *o.VendorSerialNumber
		}
		qVendorSerialNumber := qrVendorSerialNumber
		if qVendorSerialNumber != "" {

			if err := r.SetQueryParam("vendor_serial_number", qVendorSerialNumber); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
