// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeDeleteCollectionReader is a Reader for the DcnNodeDeleteCollection structure.
type DcnNodeDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDcnNodeDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeDeleteCollectionOK creates a DcnNodeDeleteCollectionOK with default headers values
func NewDcnNodeDeleteCollectionOK() *DcnNodeDeleteCollectionOK {
	return &DcnNodeDeleteCollectionOK{}
}

/*
DcnNodeDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeDeleteCollectionOK struct {
	Payload *models.DcnNodeJobLinkResponse
}

// IsSuccess returns true when this dcn node delete collection o k response has a 2xx status code
func (o *DcnNodeDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node delete collection o k response has a 3xx status code
func (o *DcnNodeDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node delete collection o k response has a 4xx status code
func (o *DcnNodeDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node delete collection o k response has a 5xx status code
func (o *DcnNodeDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node delete collection o k response a status code equal to that given
func (o *DcnNodeDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node delete collection o k response
func (o *DcnNodeDeleteCollectionOK) Code() int {
	return 200
}

func (o *DcnNodeDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes][%d] dcnNodeDeleteCollectionOK %s", 200, payload)
}

func (o *DcnNodeDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes][%d] dcnNodeDeleteCollectionOK %s", 200, payload)
}

func (o *DcnNodeDeleteCollectionOK) GetPayload() *models.DcnNodeJobLinkResponse {
	return o.Payload
}

func (o *DcnNodeDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeDeleteCollectionAccepted creates a DcnNodeDeleteCollectionAccepted with default headers values
func NewDcnNodeDeleteCollectionAccepted() *DcnNodeDeleteCollectionAccepted {
	return &DcnNodeDeleteCollectionAccepted{}
}

/*
DcnNodeDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DcnNodeDeleteCollectionAccepted struct {
	Payload *models.DcnNodeJobLinkResponse
}

// IsSuccess returns true when this dcn node delete collection accepted response has a 2xx status code
func (o *DcnNodeDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node delete collection accepted response has a 3xx status code
func (o *DcnNodeDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node delete collection accepted response has a 4xx status code
func (o *DcnNodeDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node delete collection accepted response has a 5xx status code
func (o *DcnNodeDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node delete collection accepted response a status code equal to that given
func (o *DcnNodeDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the dcn node delete collection accepted response
func (o *DcnNodeDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *DcnNodeDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes][%d] dcnNodeDeleteCollectionAccepted %s", 202, payload)
}

func (o *DcnNodeDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes][%d] dcnNodeDeleteCollectionAccepted %s", 202, payload)
}

func (o *DcnNodeDeleteCollectionAccepted) GetPayload() *models.DcnNodeJobLinkResponse {
	return o.Payload
}

func (o *DcnNodeDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeDeleteCollectionDefault creates a DcnNodeDeleteCollectionDefault with default headers values
func NewDcnNodeDeleteCollectionDefault(code int) *DcnNodeDeleteCollectionDefault {
	return &DcnNodeDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
DcnNodeDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type DcnNodeDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node delete collection default response has a 2xx status code
func (o *DcnNodeDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node delete collection default response has a 3xx status code
func (o *DcnNodeDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node delete collection default response has a 4xx status code
func (o *DcnNodeDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node delete collection default response has a 5xx status code
func (o *DcnNodeDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node delete collection default response a status code equal to that given
func (o *DcnNodeDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node delete collection default response
func (o *DcnNodeDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes][%d] dcn_node_delete_collection default %s", o._statusCode, payload)
}

func (o *DcnNodeDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes][%d] dcn_node_delete_collection default %s", o._statusCode, payload)
}

func (o *DcnNodeDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DcnNodeDeleteCollectionBody dcn node delete collection body
swagger:model DcnNodeDeleteCollectionBody
*/
type DcnNodeDeleteCollectionBody struct {

	// dcn node response inline records
	DcnNodeResponseInlineRecords []*models.DcnNode `json:"records,omitempty"`
}

// Validate validates this dcn node delete collection body
func (o *DcnNodeDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDcnNodeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeDeleteCollectionBody) validateDcnNodeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DcnNodeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DcnNodeResponseInlineRecords); i++ {
		if swag.IsZero(o.DcnNodeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DcnNodeResponseInlineRecords[i] != nil {
			if err := o.DcnNodeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this dcn node delete collection body based on the context it is used
func (o *DcnNodeDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDcnNodeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeDeleteCollectionBody) contextValidateDcnNodeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DcnNodeResponseInlineRecords); i++ {

		if o.DcnNodeResponseInlineRecords[i] != nil {
			if err := o.DcnNodeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res DcnNodeDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
