// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeDeleteReader is a Reader for the DcnNodeDelete structure.
type DcnNodeDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDcnNodeDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeDeleteOK creates a DcnNodeDeleteOK with default headers values
func NewDcnNodeDeleteOK() *DcnNodeDeleteOK {
	return &DcnNodeDeleteOK{}
}

/*
DcnNodeDeleteOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeDeleteOK struct {
	Payload *models.DcnNodeJobLinkResponse
}

// IsSuccess returns true when this dcn node delete o k response has a 2xx status code
func (o *DcnNodeDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node delete o k response has a 3xx status code
func (o *DcnNodeDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node delete o k response has a 4xx status code
func (o *DcnNodeDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node delete o k response has a 5xx status code
func (o *DcnNodeDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node delete o k response a status code equal to that given
func (o *DcnNodeDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node delete o k response
func (o *DcnNodeDeleteOK) Code() int {
	return 200
}

func (o *DcnNodeDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes/{uuid}][%d] dcnNodeDeleteOK %s", 200, payload)
}

func (o *DcnNodeDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes/{uuid}][%d] dcnNodeDeleteOK %s", 200, payload)
}

func (o *DcnNodeDeleteOK) GetPayload() *models.DcnNodeJobLinkResponse {
	return o.Payload
}

func (o *DcnNodeDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeDeleteAccepted creates a DcnNodeDeleteAccepted with default headers values
func NewDcnNodeDeleteAccepted() *DcnNodeDeleteAccepted {
	return &DcnNodeDeleteAccepted{}
}

/*
DcnNodeDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DcnNodeDeleteAccepted struct {
	Payload *models.DcnNodeJobLinkResponse
}

// IsSuccess returns true when this dcn node delete accepted response has a 2xx status code
func (o *DcnNodeDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node delete accepted response has a 3xx status code
func (o *DcnNodeDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node delete accepted response has a 4xx status code
func (o *DcnNodeDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node delete accepted response has a 5xx status code
func (o *DcnNodeDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node delete accepted response a status code equal to that given
func (o *DcnNodeDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the dcn node delete accepted response
func (o *DcnNodeDeleteAccepted) Code() int {
	return 202
}

func (o *DcnNodeDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes/{uuid}][%d] dcnNodeDeleteAccepted %s", 202, payload)
}

func (o *DcnNodeDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes/{uuid}][%d] dcnNodeDeleteAccepted %s", 202, payload)
}

func (o *DcnNodeDeleteAccepted) GetPayload() *models.DcnNodeJobLinkResponse {
	return o.Payload
}

func (o *DcnNodeDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeDeleteDefault creates a DcnNodeDeleteDefault with default headers values
func NewDcnNodeDeleteDefault(code int) *DcnNodeDeleteDefault {
	return &DcnNodeDeleteDefault{
		_statusCode: code,
	}
}

/*
DcnNodeDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type DcnNodeDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node delete default response has a 2xx status code
func (o *DcnNodeDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node delete default response has a 3xx status code
func (o *DcnNodeDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node delete default response has a 4xx status code
func (o *DcnNodeDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node delete default response has a 5xx status code
func (o *DcnNodeDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node delete default response a status code equal to that given
func (o *DcnNodeDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node delete default response
func (o *DcnNodeDeleteDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes/{uuid}][%d] dcn_node_delete default %s", o._statusCode, payload)
}

func (o *DcnNodeDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster/nodes/{uuid}][%d] dcn_node_delete default %s", o._statusCode, payload)
}

func (o *DcnNodeDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
