// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeGetReader is a Reader for the DcnNodeGet structure.
type DcnNodeGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeGetOK creates a DcnNodeGetOK with default headers values
func NewDcnNodeGetOK() *DcnNodeGetOK {
	return &DcnNodeGetOK{}
}

/*
DcnNodeGetOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeGetOK struct {
	Payload *models.DcnNode
}

// IsSuccess returns true when this dcn node get o k response has a 2xx status code
func (o *DcnNodeGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node get o k response has a 3xx status code
func (o *DcnNodeGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node get o k response has a 4xx status code
func (o *DcnNodeGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node get o k response has a 5xx status code
func (o *DcnNodeGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node get o k response a status code equal to that given
func (o *DcnNodeGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node get o k response
func (o *DcnNodeGetOK) Code() int {
	return 200
}

func (o *DcnNodeGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes/{uuid}][%d] dcnNodeGetOK %s", 200, payload)
}

func (o *DcnNodeGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes/{uuid}][%d] dcnNodeGetOK %s", 200, payload)
}

func (o *DcnNodeGetOK) GetPayload() *models.DcnNode {
	return o.Payload
}

func (o *DcnNodeGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNode)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeGetDefault creates a DcnNodeGetDefault with default headers values
func NewDcnNodeGetDefault(code int) *DcnNodeGetDefault {
	return &DcnNodeGetDefault{
		_statusCode: code,
	}
}

/*
DcnNodeGetDefault describes a response with status code -1, with default header values.

Error
*/
type DcnNodeGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node get default response has a 2xx status code
func (o *DcnNodeGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node get default response has a 3xx status code
func (o *DcnNodeGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node get default response has a 4xx status code
func (o *DcnNodeGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node get default response has a 5xx status code
func (o *DcnNodeGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node get default response a status code equal to that given
func (o *DcnNodeGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node get default response
func (o *DcnNodeGetDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes/{uuid}][%d] dcn_node_get default %s", o._statusCode, payload)
}

func (o *DcnNodeGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes/{uuid}][%d] dcn_node_get default %s", o._statusCode, payload)
}

func (o *DcnNodeGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
