// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDcnNodeMetricsCollectionGetParams creates a new DcnNodeMetricsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDcnNodeMetricsCollectionGetParams() *DcnNodeMetricsCollectionGetParams {
	return &DcnNodeMetricsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDcnNodeMetricsCollectionGetParamsWithTimeout creates a new DcnNodeMetricsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDcnNodeMetricsCollectionGetParamsWithTimeout(timeout time.Duration) *DcnNodeMetricsCollectionGetParams {
	return &DcnNodeMetricsCollectionGetParams{
		timeout: timeout,
	}
}

// NewDcnNodeMetricsCollectionGetParamsWithContext creates a new DcnNodeMetricsCollectionGetParams object
// with the ability to set a context for a request.
func NewDcnNodeMetricsCollectionGetParamsWithContext(ctx context.Context) *DcnNodeMetricsCollectionGetParams {
	return &DcnNodeMetricsCollectionGetParams{
		Context: ctx,
	}
}

// NewDcnNodeMetricsCollectionGetParamsWithHTTPClient creates a new DcnNodeMetricsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDcnNodeMetricsCollectionGetParamsWithHTTPClient(client *http.Client) *DcnNodeMetricsCollectionGetParams {
	return &DcnNodeMetricsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DcnNodeMetricsCollectionGetParams contains all the parameters to send to the API endpoint

	for the dcn node metrics collection get operation.

	Typically these are written to a http.Request.
*/
type DcnNodeMetricsCollectionGetParams struct {

	/* CPUMemoryUsed.

	   Filter by cpu.memory_used
	*/
	CPUMemoryUsed *int64

	/* CPUProcessorUtilization.

	   Filter by cpu.processor_utilization
	*/
	CPUProcessorUtilization *int64

	/* Duration.

	   Filter by duration
	*/
	Duration *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* GpuMemoryUsed.

	   Filter by gpu.memory_used
	*/
	GpuMemoryUsed *int64

	/* GpuProcessorUtilization.

	   Filter by gpu.processor_utilization
	*/
	GpuProcessorUtilization *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeUUID.

	   Unique identifier of the node.
	*/
	NodeUUID string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Status.

	   Filter by status
	*/
	Status *string

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the dcn node metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnNodeMetricsCollectionGetParams) WithDefaults() *DcnNodeMetricsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dcn node metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnNodeMetricsCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DcnNodeMetricsCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithTimeout(timeout time.Duration) *DcnNodeMetricsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithContext(ctx context.Context) *DcnNodeMetricsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithHTTPClient(client *http.Client) *DcnNodeMetricsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCPUMemoryUsed adds the cPUMemoryUsed to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithCPUMemoryUsed(cPUMemoryUsed *int64) *DcnNodeMetricsCollectionGetParams {
	o.SetCPUMemoryUsed(cPUMemoryUsed)
	return o
}

// SetCPUMemoryUsed adds the cpuMemoryUsed to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetCPUMemoryUsed(cPUMemoryUsed *int64) {
	o.CPUMemoryUsed = cPUMemoryUsed
}

// WithCPUProcessorUtilization adds the cPUProcessorUtilization to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithCPUProcessorUtilization(cPUProcessorUtilization *int64) *DcnNodeMetricsCollectionGetParams {
	o.SetCPUProcessorUtilization(cPUProcessorUtilization)
	return o
}

// SetCPUProcessorUtilization adds the cpuProcessorUtilization to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetCPUProcessorUtilization(cPUProcessorUtilization *int64) {
	o.CPUProcessorUtilization = cPUProcessorUtilization
}

// WithDuration adds the duration to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithDuration(duration *string) *DcnNodeMetricsCollectionGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithFields adds the fields to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithFields(fields []string) *DcnNodeMetricsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithGpuMemoryUsed adds the gpuMemoryUsed to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithGpuMemoryUsed(gpuMemoryUsed *int64) *DcnNodeMetricsCollectionGetParams {
	o.SetGpuMemoryUsed(gpuMemoryUsed)
	return o
}

// SetGpuMemoryUsed adds the gpuMemoryUsed to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetGpuMemoryUsed(gpuMemoryUsed *int64) {
	o.GpuMemoryUsed = gpuMemoryUsed
}

// WithGpuProcessorUtilization adds the gpuProcessorUtilization to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithGpuProcessorUtilization(gpuProcessorUtilization *int64) *DcnNodeMetricsCollectionGetParams {
	o.SetGpuProcessorUtilization(gpuProcessorUtilization)
	return o
}

// SetGpuProcessorUtilization adds the gpuProcessorUtilization to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetGpuProcessorUtilization(gpuProcessorUtilization *int64) {
	o.GpuProcessorUtilization = gpuProcessorUtilization
}

// WithMaxRecords adds the maxRecords to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithMaxRecords(maxRecords *int64) *DcnNodeMetricsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeUUID adds the nodeUUID to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithNodeUUID(nodeUUID string) *DcnNodeMetricsCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithOrderBy(orderBy []string) *DcnNodeMetricsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithReturnRecords(returnRecords *bool) *DcnNodeMetricsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DcnNodeMetricsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStatus adds the status to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithStatus(status *string) *DcnNodeMetricsCollectionGetParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetStatus(status *string) {
	o.Status = status
}

// WithTimestamp adds the timestamp to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithTimestamp(timestamp *string) *DcnNodeMetricsCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithUUID adds the uuid to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) WithUUID(uuid *string) *DcnNodeMetricsCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the dcn node metrics collection get params
func (o *DcnNodeMetricsCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *DcnNodeMetricsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CPUMemoryUsed != nil {

		// query param cpu.memory_used
		var qrCPUMemoryUsed int64

		if o.CPUMemoryUsed != nil {
			qrCPUMemoryUsed = *o.CPUMemoryUsed
		}
		qCPUMemoryUsed := swag.FormatInt64(qrCPUMemoryUsed)
		if qCPUMemoryUsed != "" {

			if err := r.SetQueryParam("cpu.memory_used", qCPUMemoryUsed); err != nil {
				return err
			}
		}
	}

	if o.CPUProcessorUtilization != nil {

		// query param cpu.processor_utilization
		var qrCPUProcessorUtilization int64

		if o.CPUProcessorUtilization != nil {
			qrCPUProcessorUtilization = *o.CPUProcessorUtilization
		}
		qCPUProcessorUtilization := swag.FormatInt64(qrCPUProcessorUtilization)
		if qCPUProcessorUtilization != "" {

			if err := r.SetQueryParam("cpu.processor_utilization", qCPUProcessorUtilization); err != nil {
				return err
			}
		}
	}

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.GpuMemoryUsed != nil {

		// query param gpu.memory_used
		var qrGpuMemoryUsed int64

		if o.GpuMemoryUsed != nil {
			qrGpuMemoryUsed = *o.GpuMemoryUsed
		}
		qGpuMemoryUsed := swag.FormatInt64(qrGpuMemoryUsed)
		if qGpuMemoryUsed != "" {

			if err := r.SetQueryParam("gpu.memory_used", qGpuMemoryUsed); err != nil {
				return err
			}
		}
	}

	if o.GpuProcessorUtilization != nil {

		// query param gpu.processor_utilization
		var qrGpuProcessorUtilization int64

		if o.GpuProcessorUtilization != nil {
			qrGpuProcessorUtilization = *o.GpuProcessorUtilization
		}
		qGpuProcessorUtilization := swag.FormatInt64(qrGpuProcessorUtilization)
		if qGpuProcessorUtilization != "" {

			if err := r.SetQueryParam("gpu.processor_utilization", qGpuProcessorUtilization); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDcnNodeMetricsCollectionGet binds the parameter fields
func (o *DcnNodeMetricsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDcnNodeMetricsCollectionGet binds the parameter order_by
func (o *DcnNodeMetricsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
