// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeMetricsCollectionGetReader is a Reader for the DcnNodeMetricsCollectionGet structure.
type DcnNodeMetricsCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeMetricsCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeMetricsCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeMetricsCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeMetricsCollectionGetOK creates a DcnNodeMetricsCollectionGetOK with default headers values
func NewDcnNodeMetricsCollectionGetOK() *DcnNodeMetricsCollectionGetOK {
	return &DcnNodeMetricsCollectionGetOK{}
}

/*
DcnNodeMetricsCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeMetricsCollectionGetOK struct {
	Payload *models.DcnNodeMetricsResponse
}

// IsSuccess returns true when this dcn node metrics collection get o k response has a 2xx status code
func (o *DcnNodeMetricsCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node metrics collection get o k response has a 3xx status code
func (o *DcnNodeMetricsCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node metrics collection get o k response has a 4xx status code
func (o *DcnNodeMetricsCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node metrics collection get o k response has a 5xx status code
func (o *DcnNodeMetricsCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node metrics collection get o k response a status code equal to that given
func (o *DcnNodeMetricsCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node metrics collection get o k response
func (o *DcnNodeMetricsCollectionGetOK) Code() int {
	return 200
}

func (o *DcnNodeMetricsCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes/{node.uuid}/metrics][%d] dcnNodeMetricsCollectionGetOK %s", 200, payload)
}

func (o *DcnNodeMetricsCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes/{node.uuid}/metrics][%d] dcnNodeMetricsCollectionGetOK %s", 200, payload)
}

func (o *DcnNodeMetricsCollectionGetOK) GetPayload() *models.DcnNodeMetricsResponse {
	return o.Payload
}

func (o *DcnNodeMetricsCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeMetricsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeMetricsCollectionGetDefault creates a DcnNodeMetricsCollectionGetDefault with default headers values
func NewDcnNodeMetricsCollectionGetDefault(code int) *DcnNodeMetricsCollectionGetDefault {
	return &DcnNodeMetricsCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DcnNodeMetricsCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DcnNodeMetricsCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node metrics collection get default response has a 2xx status code
func (o *DcnNodeMetricsCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node metrics collection get default response has a 3xx status code
func (o *DcnNodeMetricsCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node metrics collection get default response has a 4xx status code
func (o *DcnNodeMetricsCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node metrics collection get default response has a 5xx status code
func (o *DcnNodeMetricsCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node metrics collection get default response a status code equal to that given
func (o *DcnNodeMetricsCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node metrics collection get default response
func (o *DcnNodeMetricsCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeMetricsCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes/{node.uuid}/metrics][%d] dcn_node_metrics_collection_get default %s", o._statusCode, payload)
}

func (o *DcnNodeMetricsCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster/nodes/{node.uuid}/metrics][%d] dcn_node_metrics_collection_get default %s", o._statusCode, payload)
}

func (o *DcnNodeMetricsCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeMetricsCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
