// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeModifyCollectionReader is a Reader for the DcnNodeModifyCollection structure.
type DcnNodeModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDcnNodeModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeModifyCollectionOK creates a DcnNodeModifyCollectionOK with default headers values
func NewDcnNodeModifyCollectionOK() *DcnNodeModifyCollectionOK {
	return &DcnNodeModifyCollectionOK{}
}

/*
DcnNodeModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeModifyCollectionOK struct {
}

// IsSuccess returns true when this dcn node modify collection o k response has a 2xx status code
func (o *DcnNodeModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node modify collection o k response has a 3xx status code
func (o *DcnNodeModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node modify collection o k response has a 4xx status code
func (o *DcnNodeModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node modify collection o k response has a 5xx status code
func (o *DcnNodeModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node modify collection o k response a status code equal to that given
func (o *DcnNodeModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node modify collection o k response
func (o *DcnNodeModifyCollectionOK) Code() int {
	return 200
}

func (o *DcnNodeModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes][%d] dcnNodeModifyCollectionOK", 200)
}

func (o *DcnNodeModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes][%d] dcnNodeModifyCollectionOK", 200)
}

func (o *DcnNodeModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDcnNodeModifyCollectionAccepted creates a DcnNodeModifyCollectionAccepted with default headers values
func NewDcnNodeModifyCollectionAccepted() *DcnNodeModifyCollectionAccepted {
	return &DcnNodeModifyCollectionAccepted{}
}

/*
DcnNodeModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DcnNodeModifyCollectionAccepted struct {
	Payload *models.DcnNodeJobLinkResponse
}

// IsSuccess returns true when this dcn node modify collection accepted response has a 2xx status code
func (o *DcnNodeModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node modify collection accepted response has a 3xx status code
func (o *DcnNodeModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node modify collection accepted response has a 4xx status code
func (o *DcnNodeModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node modify collection accepted response has a 5xx status code
func (o *DcnNodeModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node modify collection accepted response a status code equal to that given
func (o *DcnNodeModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the dcn node modify collection accepted response
func (o *DcnNodeModifyCollectionAccepted) Code() int {
	return 202
}

func (o *DcnNodeModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes][%d] dcnNodeModifyCollectionAccepted %s", 202, payload)
}

func (o *DcnNodeModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes][%d] dcnNodeModifyCollectionAccepted %s", 202, payload)
}

func (o *DcnNodeModifyCollectionAccepted) GetPayload() *models.DcnNodeJobLinkResponse {
	return o.Payload
}

func (o *DcnNodeModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeModifyCollectionDefault creates a DcnNodeModifyCollectionDefault with default headers values
func NewDcnNodeModifyCollectionDefault(code int) *DcnNodeModifyCollectionDefault {
	return &DcnNodeModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	DcnNodeModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 852114 | The node is not found. |
| 852269 | This operation is not supported on this platform. |
| 3604514 | A reboot or shutdown request is already in progress. |
| 3604515 | Reboot or shutdown of all nodes results in data service failure and client disruption for the entire cluster. Use "allow-data-outage=true" to bypass this check. |
| 9240591 | The name is not valid. The name is already in use by a cluster node, SVM, or it is the name of the local cluster. |
| 9240606 | The reboot or shutdown is prevented due to quorum warnings. |
| 288358401 | Failed to offload the node because it is not in the cluster. |
| 288358402 | Failed to resume the node because it is not in the offload state. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DcnNodeModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node modify collection default response has a 2xx status code
func (o *DcnNodeModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node modify collection default response has a 3xx status code
func (o *DcnNodeModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node modify collection default response has a 4xx status code
func (o *DcnNodeModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node modify collection default response has a 5xx status code
func (o *DcnNodeModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node modify collection default response a status code equal to that given
func (o *DcnNodeModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node modify collection default response
func (o *DcnNodeModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes][%d] dcn_node_modify_collection default %s", o._statusCode, payload)
}

func (o *DcnNodeModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes][%d] dcn_node_modify_collection default %s", o._statusCode, payload)
}

func (o *DcnNodeModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DcnNodeModifyCollectionBody dcn node modify collection body
swagger:model DcnNodeModifyCollectionBody
*/
type DcnNodeModifyCollectionBody struct {

	// links
	Links *models.DcnNodeInlineLinks `json:"_links,omitempty"`

	// The current or "wall clock" time of the node in ISO-8601 date, time, and time zone format.
	// The ISO-8601 date and time are localized based on the ONTAP cluster's timezone setting.
	//
	// Example: 2019-04-17 11:49:26-04:00
	// Read Only: true
	// Format: date-time
	Date *strfmt.DateTime `json:"date,omitempty"`

	// dcn node inline error
	// Read Only: true
	DcnNodeInlineError []*models.DcnNodeError `json:"error,omitempty"`

	// dcn node response inline records
	DcnNodeResponseInlineRecords []*models.DcnNode `json:"records,omitempty"`

	// hardware
	Hardware *models.DcnHardware `json:"hardware,omitempty"`

	// location
	// Example: rack 2 row 5
	Location *string `json:"location,omitempty"`

	// Possible values:
	// * <i>available</i> - A node is detected on the network and can be added to the compute cluster. Nodes that have a membership of "available" are not returned when a GET request is called when the cluster exists. Provide a query on the "membership" property for <i>available</i> to scan for nodes on the network. Nodes that have a membership of "available" are returned automatically before a cluster is created.
	// * <i>joining</i> - Joining nodes are in the process of being added to the cluster. The node might be progressing through the steps to become a member or might have failed. The job to add the node or create the cluster provides details on the current progress of the node.
	// * <i>member</i> - Nodes that are members have successfully joined the cluster.
	//
	// Read Only: true
	// Enum: ["available","joining","member"]
	Membership *string `json:"membership,omitempty"`

	// metric
	Metric *models.DcnNodeMetrics `json:"metric,omitempty"`

	// model
	// Example: FAS3070
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// The node's hostname.
	// Example: node1
	Name *string `json:"name,omitempty"`

	// network
	Network *models.DcnNodeInlineNetwork `json:"network,omitempty"`

	// Owner of the node.
	// Example: Example Corp
	Owner *string `json:"owner,omitempty"`

	// serial number
	// Example: 4048820-60-9
	SerialNumber *string `json:"serial_number,omitempty"`

	// software
	Software *models.DcnNodeInlineSoftware `json:"software,omitempty"`

	// State of the node:
	// * <i>up</i> - Node is up and operational.
	// * <i>down</i> - Node has stopped or is dumping core.
	// * <i>degraded</i> - Node has one or more critical services offline.
	//
	// Read Only: true
	// Enum: ["up","down","degraded"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.DcnNodeStatistics `json:"statistics,omitempty"`

	// system id
	// Example: 0537035403
	// Read Only: true
	SystemID *string `json:"system_id,omitempty"`

	// The total time that the node has been up, in seconds.
	// Example: 300536
	// Read Only: true
	Uptime *int64 `json:"uptime,omitempty"`

	// uuid
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// OEM vendor serial number.
	// Example: 791603000068
	// Read Only: true
	VendorSerialNumber *string `json:"vendor_serial_number,omitempty"`
}

// Validate validates this dcn node modify collection body
func (o *DcnNodeModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDcnNodeInlineError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDcnNodeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHardware(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMembership(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetwork(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSoftware(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateDate(formats strfmt.Registry) error {
	if swag.IsZero(o.Date) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"date", "body", "date-time", o.Date.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateDcnNodeInlineError(formats strfmt.Registry) error {
	if swag.IsZero(o.DcnNodeInlineError) { // not required
		return nil
	}

	for i := 0; i < len(o.DcnNodeInlineError); i++ {
		if swag.IsZero(o.DcnNodeInlineError[i]) { // not required
			continue
		}

		if o.DcnNodeInlineError[i] != nil {
			if err := o.DcnNodeInlineError[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "error" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateDcnNodeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DcnNodeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DcnNodeResponseInlineRecords); i++ {
		if swag.IsZero(o.DcnNodeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DcnNodeResponseInlineRecords[i] != nil {
			if err := o.DcnNodeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateHardware(formats strfmt.Registry) error {
	if swag.IsZero(o.Hardware) { // not required
		return nil
	}

	if o.Hardware != nil {
		if err := o.Hardware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "hardware")
			}
			return err
		}
	}

	return nil
}

var dcnNodeModifyCollectionBodyTypeMembershipPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","joining","member"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeModifyCollectionBodyTypeMembershipPropEnum = append(dcnNodeModifyCollectionBodyTypeMembershipPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DcnNodeModifyCollectionBody
	// DcnNodeModifyCollectionBody
	// membership
	// Membership
	// available
	// END DEBUGGING
	// DcnNodeModifyCollectionBodyMembershipAvailable captures enum value "available"
	DcnNodeModifyCollectionBodyMembershipAvailable string = "available"

	// BEGIN DEBUGGING
	// DcnNodeModifyCollectionBody
	// DcnNodeModifyCollectionBody
	// membership
	// Membership
	// joining
	// END DEBUGGING
	// DcnNodeModifyCollectionBodyMembershipJoining captures enum value "joining"
	DcnNodeModifyCollectionBodyMembershipJoining string = "joining"

	// BEGIN DEBUGGING
	// DcnNodeModifyCollectionBody
	// DcnNodeModifyCollectionBody
	// membership
	// Membership
	// member
	// END DEBUGGING
	// DcnNodeModifyCollectionBodyMembershipMember captures enum value "member"
	DcnNodeModifyCollectionBodyMembershipMember string = "member"
)

// prop value enum
func (o *DcnNodeModifyCollectionBody) validateMembershipEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeModifyCollectionBodyTypeMembershipPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DcnNodeModifyCollectionBody) validateMembership(formats strfmt.Registry) error {
	if swag.IsZero(o.Membership) { // not required
		return nil
	}

	// value enum
	if err := o.validateMembershipEnum("info"+"."+"membership", "body", *o.Membership); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateNetwork(formats strfmt.Registry) error {
	if swag.IsZero(o.Network) { // not required
		return nil
	}

	if o.Network != nil {
		if err := o.Network.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "network")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateSoftware(formats strfmt.Registry) error {
	if swag.IsZero(o.Software) { // not required
		return nil
	}

	if o.Software != nil {
		if err := o.Software.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "software")
			}
			return err
		}
	}

	return nil
}

var dcnNodeModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","degraded"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeModifyCollectionBodyTypeStatePropEnum = append(dcnNodeModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DcnNodeModifyCollectionBody
	// DcnNodeModifyCollectionBody
	// state
	// State
	// up
	// END DEBUGGING
	// DcnNodeModifyCollectionBodyStateUp captures enum value "up"
	DcnNodeModifyCollectionBodyStateUp string = "up"

	// BEGIN DEBUGGING
	// DcnNodeModifyCollectionBody
	// DcnNodeModifyCollectionBody
	// state
	// State
	// down
	// END DEBUGGING
	// DcnNodeModifyCollectionBodyStateDown captures enum value "down"
	DcnNodeModifyCollectionBodyStateDown string = "down"

	// BEGIN DEBUGGING
	// DcnNodeModifyCollectionBody
	// DcnNodeModifyCollectionBody
	// state
	// State
	// degraded
	// END DEBUGGING
	// DcnNodeModifyCollectionBodyStateDegraded captures enum value "degraded"
	DcnNodeModifyCollectionBodyStateDegraded string = "degraded"
)

// prop value enum
func (o *DcnNodeModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DcnNodeModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn node modify collection body based on the context it is used
func (o *DcnNodeModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDcnNodeInlineError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDcnNodeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHardware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMembership(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetwork(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSoftware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUptime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVendorSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateDate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"date", "body", o.Date); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateDcnNodeInlineError(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error", "body", []*models.DcnNodeError(o.DcnNodeInlineError)); err != nil {
		return err
	}

	for i := 0; i < len(o.DcnNodeInlineError); i++ {

		if o.DcnNodeInlineError[i] != nil {
			if err := o.DcnNodeInlineError[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "error" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateDcnNodeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DcnNodeResponseInlineRecords); i++ {

		if o.DcnNodeResponseInlineRecords[i] != nil {
			if err := o.DcnNodeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateHardware(ctx context.Context, formats strfmt.Registry) error {

	if o.Hardware != nil {
		if err := o.Hardware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "hardware")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateMembership(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"membership", "body", o.Membership); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"model", "body", o.Model); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateNetwork(ctx context.Context, formats strfmt.Registry) error {

	if o.Network != nil {
		if err := o.Network.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "network")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateSoftware(ctx context.Context, formats strfmt.Registry) error {

	if o.Software != nil {
		if err := o.Software.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "software")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateSystemID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"system_id", "body", o.SystemID); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateUptime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uptime", "body", o.Uptime); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeModifyCollectionBody) contextValidateVendorSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"vendor_serial_number", "body", o.VendorSerialNumber); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DcnNodeModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DcnNodeInlineLinks dcn node inline links
swagger:model dcn_node_inline__links
*/
type DcnNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this dcn node inline links
func (o *DcnNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node inline links based on the context it is used
func (o *DcnNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DcnNodeInlineNetwork dcn node inline network
swagger:model dcn_node_inline_network
*/
type DcnNodeInlineNetwork struct {

	// Information about the configuration and state of the node's internal (cluster) network interface.
	DcnNodeInlineNetworkInlineInternalInterface interface{} `json:"internal_interface,omitempty"`

	// external interface
	ExternalInterface *models.DcnNodeInlineNetworkInlineExternalInterface `json:"external_interface,omitempty"`
}

// Validate validates this dcn node inline network
func (o *DcnNodeInlineNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExternalInterface(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeInlineNetwork) validateExternalInterface(formats strfmt.Registry) error {
	if swag.IsZero(o.ExternalInterface) { // not required
		return nil
	}

	if o.ExternalInterface != nil {
		if err := o.ExternalInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "network" + "." + "external_interface")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node inline network based on the context it is used
func (o *DcnNodeInlineNetwork) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExternalInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeInlineNetwork) contextValidateExternalInterface(ctx context.Context, formats strfmt.Registry) error {

	if o.ExternalInterface != nil {
		if err := o.ExternalInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "network" + "." + "external_interface")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeInlineNetwork) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeInlineNetwork) UnmarshalBinary(b []byte) error {
	var res DcnNodeInlineNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DcnNodeInlineNetworkInlineExternalInterface Information about the configuration and state of the node's external network interface.
swagger:model dcn_node_inline_network_inline_external_interface
*/
type DcnNodeInlineNetworkInlineExternalInterface struct {

	// The MAC address of the node's external interface.
	// Example: 00:B0:D0:63:C2:26
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// The MTU of the external interface.
	// Example: 1500
	Mtu *int64 `json:"mtu,omitempty"`

	// The OS-level name of the external network interface.
	// Example: ext
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this dcn node inline network inline external interface
func (o *DcnNodeInlineNetworkInlineExternalInterface) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this dcn node inline network inline external interface based on the context it is used
func (o *DcnNodeInlineNetworkInlineExternalInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeInlineNetworkInlineExternalInterface) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"network"+"."+"external_interface"+"."+"mac_address", "body", o.MacAddress); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeInlineNetworkInlineExternalInterface) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"network"+"."+"external_interface"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeInlineNetworkInlineExternalInterface) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeInlineNetworkInlineExternalInterface) UnmarshalBinary(b []byte) error {
	var res DcnNodeInlineNetworkInlineExternalInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DcnNodeInlineSoftware The software information of the node.
swagger:model dcn_node_inline_software
*/
type DcnNodeInlineSoftware struct {

	// Indicates whether the node's software version is compatible with the ONTAP cluster. A node is considered compatible if its software release is not newer than the ONTAP cluster's release, and not more than four major versions older. This field helps determine if the node can join or be used to form the DCN cluster.
	//
	// Enum: ["full","incompatible"]
	Compatibility *string `json:"compatibility,omitempty"`

	// version
	Version *models.DcnVersion `json:"version,omitempty"`
}

// Validate validates this dcn node inline software
func (o *DcnNodeInlineSoftware) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCompatibility(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dcnNodeInlineSoftwareTypeCompatibilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","incompatible"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeInlineSoftwareTypeCompatibilityPropEnum = append(dcnNodeInlineSoftwareTypeCompatibilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node_inline_software
	// DcnNodeInlineSoftware
	// compatibility
	// Compatibility
	// full
	// END DEBUGGING
	// DcnNodeInlineSoftwareCompatibilityFull captures enum value "full"
	DcnNodeInlineSoftwareCompatibilityFull string = "full"

	// BEGIN DEBUGGING
	// dcn_node_inline_software
	// DcnNodeInlineSoftware
	// compatibility
	// Compatibility
	// incompatible
	// END DEBUGGING
	// DcnNodeInlineSoftwareCompatibilityIncompatible captures enum value "incompatible"
	DcnNodeInlineSoftwareCompatibilityIncompatible string = "incompatible"
)

// prop value enum
func (o *DcnNodeInlineSoftware) validateCompatibilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeInlineSoftwareTypeCompatibilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DcnNodeInlineSoftware) validateCompatibility(formats strfmt.Registry) error {
	if swag.IsZero(o.Compatibility) { // not required
		return nil
	}

	// value enum
	if err := o.validateCompatibilityEnum("info"+"."+"software"+"."+"compatibility", "body", *o.Compatibility); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeInlineSoftware) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(o.Version) { // not required
		return nil
	}

	if o.Version != nil {
		if err := o.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "software" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node inline software based on the context it is used
func (o *DcnNodeInlineSoftware) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeInlineSoftware) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if o.Version != nil {
		if err := o.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "software" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeInlineSoftware) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeInlineSoftware) UnmarshalBinary(b []byte) error {
	var res DcnNodeInlineSoftware
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
