// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeModifyReader is a Reader for the DcnNodeModify structure.
type DcnNodeModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDcnNodeModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeModifyOK creates a DcnNodeModifyOK with default headers values
func NewDcnNodeModifyOK() *DcnNodeModifyOK {
	return &DcnNodeModifyOK{}
}

/*
DcnNodeModifyOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeModifyOK struct {
}

// IsSuccess returns true when this dcn node modify o k response has a 2xx status code
func (o *DcnNodeModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node modify o k response has a 3xx status code
func (o *DcnNodeModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node modify o k response has a 4xx status code
func (o *DcnNodeModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node modify o k response has a 5xx status code
func (o *DcnNodeModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node modify o k response a status code equal to that given
func (o *DcnNodeModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node modify o k response
func (o *DcnNodeModifyOK) Code() int {
	return 200
}

func (o *DcnNodeModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes/{uuid}][%d] dcnNodeModifyOK", 200)
}

func (o *DcnNodeModifyOK) String() string {
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes/{uuid}][%d] dcnNodeModifyOK", 200)
}

func (o *DcnNodeModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDcnNodeModifyAccepted creates a DcnNodeModifyAccepted with default headers values
func NewDcnNodeModifyAccepted() *DcnNodeModifyAccepted {
	return &DcnNodeModifyAccepted{}
}

/*
DcnNodeModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DcnNodeModifyAccepted struct {
	Payload *models.DcnNodeJobLinkResponse
}

// IsSuccess returns true when this dcn node modify accepted response has a 2xx status code
func (o *DcnNodeModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node modify accepted response has a 3xx status code
func (o *DcnNodeModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node modify accepted response has a 4xx status code
func (o *DcnNodeModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node modify accepted response has a 5xx status code
func (o *DcnNodeModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node modify accepted response a status code equal to that given
func (o *DcnNodeModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the dcn node modify accepted response
func (o *DcnNodeModifyAccepted) Code() int {
	return 202
}

func (o *DcnNodeModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes/{uuid}][%d] dcnNodeModifyAccepted %s", 202, payload)
}

func (o *DcnNodeModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes/{uuid}][%d] dcnNodeModifyAccepted %s", 202, payload)
}

func (o *DcnNodeModifyAccepted) GetPayload() *models.DcnNodeJobLinkResponse {
	return o.Payload
}

func (o *DcnNodeModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeModifyDefault creates a DcnNodeModifyDefault with default headers values
func NewDcnNodeModifyDefault(code int) *DcnNodeModifyDefault {
	return &DcnNodeModifyDefault{
		_statusCode: code,
	}
}

/*
	DcnNodeModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 852114 | The node is not found. |
| 852269 | This operation is not supported on this platform. |
| 3604514 | A reboot or shutdown request is already in progress. |
| 3604515 | Reboot or shutdown of all nodes results in data service failure and client disruption for the entire cluster. Use "allow-data-outage=true" to bypass this check. |
| 9240591 | The name is not valid. The name is already in use by a cluster node, SVM, or it is the name of the local cluster. |
| 9240606 | The reboot or shutdown is prevented due to quorum warnings. |
| 288358401 | Failed to offload the node because it is not in the cluster. |
| 288358402 | Failed to resume the node because it is not in the offload state. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DcnNodeModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node modify default response has a 2xx status code
func (o *DcnNodeModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node modify default response has a 3xx status code
func (o *DcnNodeModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node modify default response has a 4xx status code
func (o *DcnNodeModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node modify default response has a 5xx status code
func (o *DcnNodeModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node modify default response a status code equal to that given
func (o *DcnNodeModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node modify default response
func (o *DcnNodeModifyDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes/{uuid}][%d] dcn_node_modify default %s", o._statusCode, payload)
}

func (o *DcnNodeModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster/nodes/{uuid}][%d] dcn_node_modify default %s", o._statusCode, payload)
}

func (o *DcnNodeModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
