// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewActiveDirectoryCollectionGetParams creates a new ActiveDirectoryCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewActiveDirectoryCollectionGetParams() *ActiveDirectoryCollectionGetParams {
	return &ActiveDirectoryCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewActiveDirectoryCollectionGetParamsWithTimeout creates a new ActiveDirectoryCollectionGetParams object
// with the ability to set a timeout on a request.
func NewActiveDirectoryCollectionGetParamsWithTimeout(timeout time.Duration) *ActiveDirectoryCollectionGetParams {
	return &ActiveDirectoryCollectionGetParams{
		timeout: timeout,
	}
}

// NewActiveDirectoryCollectionGetParamsWithContext creates a new ActiveDirectoryCollectionGetParams object
// with the ability to set a context for a request.
func NewActiveDirectoryCollectionGetParamsWithContext(ctx context.Context) *ActiveDirectoryCollectionGetParams {
	return &ActiveDirectoryCollectionGetParams{
		Context: ctx,
	}
}

// NewActiveDirectoryCollectionGetParamsWithHTTPClient creates a new ActiveDirectoryCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewActiveDirectoryCollectionGetParamsWithHTTPClient(client *http.Client) *ActiveDirectoryCollectionGetParams {
	return &ActiveDirectoryCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ActiveDirectoryCollectionGetParams contains all the parameters to send to the API endpoint

	for the active directory collection get operation.

	Typically these are written to a http.Request.
*/
type ActiveDirectoryCollectionGetParams struct {

	/* DiscoveredServersDomain.

	   Filter by discovered_servers.domain
	*/
	DiscoveredServersDomain *string

	/* DiscoveredServersNodeName.

	   Filter by discovered_servers.node.name
	*/
	DiscoveredServersNodeName *string

	/* DiscoveredServersNodeUUID.

	   Filter by discovered_servers.node.uuid
	*/
	DiscoveredServersNodeUUID *string

	/* DiscoveredServersPreference.

	   Filter by discovered_servers.preference
	*/
	DiscoveredServersPreference *string

	/* DiscoveredServersServerIP.

	   Filter by discovered_servers.server.ip
	*/
	DiscoveredServersServerIP *string

	/* DiscoveredServersServerName.

	   Filter by discovered_servers.server.name
	*/
	DiscoveredServersServerName *string

	/* DiscoveredServersServerType.

	   Filter by discovered_servers.server.type
	*/
	DiscoveredServersServerType *string

	/* DiscoveredServersState.

	   Filter by discovered_servers.state
	*/
	DiscoveredServersState *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Fqdn.

	   Filter by fqdn
	*/
	Fqdn *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OrganizationalUnit.

	   Filter by organizational_unit
	*/
	OrganizationalUnit *string

	/* PreferredDcsFqdn.

	   Filter by preferred_dcs.fqdn
	*/
	PreferredDcsFqdn *string

	/* PreferredDcsServerIP.

	   Filter by preferred_dcs.server_ip
	*/
	PreferredDcsServerIP *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecurityAdvertisedKdcEncryptions.

	   Filter by security.advertised_kdc_encryptions
	*/
	SecurityAdvertisedKdcEncryptions *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the active directory collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryCollectionGetParams) WithDefaults() *ActiveDirectoryCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the active directory collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ActiveDirectoryCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithTimeout(timeout time.Duration) *ActiveDirectoryCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithContext(ctx context.Context) *ActiveDirectoryCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithHTTPClient(client *http.Client) *ActiveDirectoryCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDiscoveredServersDomain adds the discoveredServersDomain to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithDiscoveredServersDomain(discoveredServersDomain *string) *ActiveDirectoryCollectionGetParams {
	o.SetDiscoveredServersDomain(discoveredServersDomain)
	return o
}

// SetDiscoveredServersDomain adds the discoveredServersDomain to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetDiscoveredServersDomain(discoveredServersDomain *string) {
	o.DiscoveredServersDomain = discoveredServersDomain
}

// WithDiscoveredServersNodeName adds the discoveredServersNodeName to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithDiscoveredServersNodeName(discoveredServersNodeName *string) *ActiveDirectoryCollectionGetParams {
	o.SetDiscoveredServersNodeName(discoveredServersNodeName)
	return o
}

// SetDiscoveredServersNodeName adds the discoveredServersNodeName to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetDiscoveredServersNodeName(discoveredServersNodeName *string) {
	o.DiscoveredServersNodeName = discoveredServersNodeName
}

// WithDiscoveredServersNodeUUID adds the discoveredServersNodeUUID to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithDiscoveredServersNodeUUID(discoveredServersNodeUUID *string) *ActiveDirectoryCollectionGetParams {
	o.SetDiscoveredServersNodeUUID(discoveredServersNodeUUID)
	return o
}

// SetDiscoveredServersNodeUUID adds the discoveredServersNodeUuid to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetDiscoveredServersNodeUUID(discoveredServersNodeUUID *string) {
	o.DiscoveredServersNodeUUID = discoveredServersNodeUUID
}

// WithDiscoveredServersPreference adds the discoveredServersPreference to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithDiscoveredServersPreference(discoveredServersPreference *string) *ActiveDirectoryCollectionGetParams {
	o.SetDiscoveredServersPreference(discoveredServersPreference)
	return o
}

// SetDiscoveredServersPreference adds the discoveredServersPreference to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetDiscoveredServersPreference(discoveredServersPreference *string) {
	o.DiscoveredServersPreference = discoveredServersPreference
}

// WithDiscoveredServersServerIP adds the discoveredServersServerIP to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithDiscoveredServersServerIP(discoveredServersServerIP *string) *ActiveDirectoryCollectionGetParams {
	o.SetDiscoveredServersServerIP(discoveredServersServerIP)
	return o
}

// SetDiscoveredServersServerIP adds the discoveredServersServerIp to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetDiscoveredServersServerIP(discoveredServersServerIP *string) {
	o.DiscoveredServersServerIP = discoveredServersServerIP
}

// WithDiscoveredServersServerName adds the discoveredServersServerName to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithDiscoveredServersServerName(discoveredServersServerName *string) *ActiveDirectoryCollectionGetParams {
	o.SetDiscoveredServersServerName(discoveredServersServerName)
	return o
}

// SetDiscoveredServersServerName adds the discoveredServersServerName to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetDiscoveredServersServerName(discoveredServersServerName *string) {
	o.DiscoveredServersServerName = discoveredServersServerName
}

// WithDiscoveredServersServerType adds the discoveredServersServerType to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithDiscoveredServersServerType(discoveredServersServerType *string) *ActiveDirectoryCollectionGetParams {
	o.SetDiscoveredServersServerType(discoveredServersServerType)
	return o
}

// SetDiscoveredServersServerType adds the discoveredServersServerType to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetDiscoveredServersServerType(discoveredServersServerType *string) {
	o.DiscoveredServersServerType = discoveredServersServerType
}

// WithDiscoveredServersState adds the discoveredServersState to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithDiscoveredServersState(discoveredServersState *string) *ActiveDirectoryCollectionGetParams {
	o.SetDiscoveredServersState(discoveredServersState)
	return o
}

// SetDiscoveredServersState adds the discoveredServersState to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetDiscoveredServersState(discoveredServersState *string) {
	o.DiscoveredServersState = discoveredServersState
}

// WithFields adds the fields to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithFields(fields []string) *ActiveDirectoryCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFqdn adds the fqdn to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithFqdn(fqdn *string) *ActiveDirectoryCollectionGetParams {
	o.SetFqdn(fqdn)
	return o
}

// SetFqdn adds the fqdn to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetFqdn(fqdn *string) {
	o.Fqdn = fqdn
}

// WithMaxRecords adds the maxRecords to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithMaxRecords(maxRecords *int64) *ActiveDirectoryCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithName(name *string) *ActiveDirectoryCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithOrderBy(orderBy []string) *ActiveDirectoryCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOrganizationalUnit adds the organizationalUnit to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithOrganizationalUnit(organizationalUnit *string) *ActiveDirectoryCollectionGetParams {
	o.SetOrganizationalUnit(organizationalUnit)
	return o
}

// SetOrganizationalUnit adds the organizationalUnit to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetOrganizationalUnit(organizationalUnit *string) {
	o.OrganizationalUnit = organizationalUnit
}

// WithPreferredDcsFqdn adds the preferredDcsFqdn to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithPreferredDcsFqdn(preferredDcsFqdn *string) *ActiveDirectoryCollectionGetParams {
	o.SetPreferredDcsFqdn(preferredDcsFqdn)
	return o
}

// SetPreferredDcsFqdn adds the preferredDcsFqdn to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetPreferredDcsFqdn(preferredDcsFqdn *string) {
	o.PreferredDcsFqdn = preferredDcsFqdn
}

// WithPreferredDcsServerIP adds the preferredDcsServerIP to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithPreferredDcsServerIP(preferredDcsServerIP *string) *ActiveDirectoryCollectionGetParams {
	o.SetPreferredDcsServerIP(preferredDcsServerIP)
	return o
}

// SetPreferredDcsServerIP adds the preferredDcsServerIp to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetPreferredDcsServerIP(preferredDcsServerIP *string) {
	o.PreferredDcsServerIP = preferredDcsServerIP
}

// WithReturnRecords adds the returnRecords to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithReturnRecords(returnRecords *bool) *ActiveDirectoryCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ActiveDirectoryCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecurityAdvertisedKdcEncryptions adds the securityAdvertisedKdcEncryptions to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions *string) *ActiveDirectoryCollectionGetParams {
	o.SetSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions)
	return o
}

// SetSecurityAdvertisedKdcEncryptions adds the securityAdvertisedKdcEncryptions to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions *string) {
	o.SecurityAdvertisedKdcEncryptions = securityAdvertisedKdcEncryptions
}

// WithSvmName adds the svmName to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithSvmName(svmName *string) *ActiveDirectoryCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) WithSvmUUID(svmUUID *string) *ActiveDirectoryCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the active directory collection get params
func (o *ActiveDirectoryCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *ActiveDirectoryCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DiscoveredServersDomain != nil {

		// query param discovered_servers.domain
		var qrDiscoveredServersDomain string

		if o.DiscoveredServersDomain != nil {
			qrDiscoveredServersDomain = *o.DiscoveredServersDomain
		}
		qDiscoveredServersDomain := qrDiscoveredServersDomain
		if qDiscoveredServersDomain != "" {

			if err := r.SetQueryParam("discovered_servers.domain", qDiscoveredServersDomain); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersNodeName != nil {

		// query param discovered_servers.node.name
		var qrDiscoveredServersNodeName string

		if o.DiscoveredServersNodeName != nil {
			qrDiscoveredServersNodeName = *o.DiscoveredServersNodeName
		}
		qDiscoveredServersNodeName := qrDiscoveredServersNodeName
		if qDiscoveredServersNodeName != "" {

			if err := r.SetQueryParam("discovered_servers.node.name", qDiscoveredServersNodeName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersNodeUUID != nil {

		// query param discovered_servers.node.uuid
		var qrDiscoveredServersNodeUUID string

		if o.DiscoveredServersNodeUUID != nil {
			qrDiscoveredServersNodeUUID = *o.DiscoveredServersNodeUUID
		}
		qDiscoveredServersNodeUUID := qrDiscoveredServersNodeUUID
		if qDiscoveredServersNodeUUID != "" {

			if err := r.SetQueryParam("discovered_servers.node.uuid", qDiscoveredServersNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersPreference != nil {

		// query param discovered_servers.preference
		var qrDiscoveredServersPreference string

		if o.DiscoveredServersPreference != nil {
			qrDiscoveredServersPreference = *o.DiscoveredServersPreference
		}
		qDiscoveredServersPreference := qrDiscoveredServersPreference
		if qDiscoveredServersPreference != "" {

			if err := r.SetQueryParam("discovered_servers.preference", qDiscoveredServersPreference); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerIP != nil {

		// query param discovered_servers.server.ip
		var qrDiscoveredServersServerIP string

		if o.DiscoveredServersServerIP != nil {
			qrDiscoveredServersServerIP = *o.DiscoveredServersServerIP
		}
		qDiscoveredServersServerIP := qrDiscoveredServersServerIP
		if qDiscoveredServersServerIP != "" {

			if err := r.SetQueryParam("discovered_servers.server.ip", qDiscoveredServersServerIP); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerName != nil {

		// query param discovered_servers.server.name
		var qrDiscoveredServersServerName string

		if o.DiscoveredServersServerName != nil {
			qrDiscoveredServersServerName = *o.DiscoveredServersServerName
		}
		qDiscoveredServersServerName := qrDiscoveredServersServerName
		if qDiscoveredServersServerName != "" {

			if err := r.SetQueryParam("discovered_servers.server.name", qDiscoveredServersServerName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerType != nil {

		// query param discovered_servers.server.type
		var qrDiscoveredServersServerType string

		if o.DiscoveredServersServerType != nil {
			qrDiscoveredServersServerType = *o.DiscoveredServersServerType
		}
		qDiscoveredServersServerType := qrDiscoveredServersServerType
		if qDiscoveredServersServerType != "" {

			if err := r.SetQueryParam("discovered_servers.server.type", qDiscoveredServersServerType); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersState != nil {

		// query param discovered_servers.state
		var qrDiscoveredServersState string

		if o.DiscoveredServersState != nil {
			qrDiscoveredServersState = *o.DiscoveredServersState
		}
		qDiscoveredServersState := qrDiscoveredServersState
		if qDiscoveredServersState != "" {

			if err := r.SetQueryParam("discovered_servers.state", qDiscoveredServersState); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Fqdn != nil {

		// query param fqdn
		var qrFqdn string

		if o.Fqdn != nil {
			qrFqdn = *o.Fqdn
		}
		qFqdn := qrFqdn
		if qFqdn != "" {

			if err := r.SetQueryParam("fqdn", qFqdn); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OrganizationalUnit != nil {

		// query param organizational_unit
		var qrOrganizationalUnit string

		if o.OrganizationalUnit != nil {
			qrOrganizationalUnit = *o.OrganizationalUnit
		}
		qOrganizationalUnit := qrOrganizationalUnit
		if qOrganizationalUnit != "" {

			if err := r.SetQueryParam("organizational_unit", qOrganizationalUnit); err != nil {
				return err
			}
		}
	}

	if o.PreferredDcsFqdn != nil {

		// query param preferred_dcs.fqdn
		var qrPreferredDcsFqdn string

		if o.PreferredDcsFqdn != nil {
			qrPreferredDcsFqdn = *o.PreferredDcsFqdn
		}
		qPreferredDcsFqdn := qrPreferredDcsFqdn
		if qPreferredDcsFqdn != "" {

			if err := r.SetQueryParam("preferred_dcs.fqdn", qPreferredDcsFqdn); err != nil {
				return err
			}
		}
	}

	if o.PreferredDcsServerIP != nil {

		// query param preferred_dcs.server_ip
		var qrPreferredDcsServerIP string

		if o.PreferredDcsServerIP != nil {
			qrPreferredDcsServerIP = *o.PreferredDcsServerIP
		}
		qPreferredDcsServerIP := qrPreferredDcsServerIP
		if qPreferredDcsServerIP != "" {

			if err := r.SetQueryParam("preferred_dcs.server_ip", qPreferredDcsServerIP); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecurityAdvertisedKdcEncryptions != nil {

		// query param security.advertised_kdc_encryptions
		var qrSecurityAdvertisedKdcEncryptions string

		if o.SecurityAdvertisedKdcEncryptions != nil {
			qrSecurityAdvertisedKdcEncryptions = *o.SecurityAdvertisedKdcEncryptions
		}
		qSecurityAdvertisedKdcEncryptions := qrSecurityAdvertisedKdcEncryptions
		if qSecurityAdvertisedKdcEncryptions != "" {

			if err := r.SetQueryParam("security.advertised_kdc_encryptions", qSecurityAdvertisedKdcEncryptions); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamActiveDirectoryCollectionGet binds the parameter fields
func (o *ActiveDirectoryCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamActiveDirectoryCollectionGet binds the parameter order_by
func (o *ActiveDirectoryCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
