// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewActiveDirectoryCreateParams creates a new ActiveDirectoryCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewActiveDirectoryCreateParams() *ActiveDirectoryCreateParams {
	return &ActiveDirectoryCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewActiveDirectoryCreateParamsWithTimeout creates a new ActiveDirectoryCreateParams object
// with the ability to set a timeout on a request.
func NewActiveDirectoryCreateParamsWithTimeout(timeout time.Duration) *ActiveDirectoryCreateParams {
	return &ActiveDirectoryCreateParams{
		timeout: timeout,
	}
}

// NewActiveDirectoryCreateParamsWithContext creates a new ActiveDirectoryCreateParams object
// with the ability to set a context for a request.
func NewActiveDirectoryCreateParamsWithContext(ctx context.Context) *ActiveDirectoryCreateParams {
	return &ActiveDirectoryCreateParams{
		Context: ctx,
	}
}

// NewActiveDirectoryCreateParamsWithHTTPClient creates a new ActiveDirectoryCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewActiveDirectoryCreateParamsWithHTTPClient(client *http.Client) *ActiveDirectoryCreateParams {
	return &ActiveDirectoryCreateParams{
		HTTPClient: client,
	}
}

/*
ActiveDirectoryCreateParams contains all the parameters to send to the API endpoint

	for the active directory create operation.

	Typically these are written to a http.Request.
*/
type ActiveDirectoryCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.ActiveDirectory

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the active directory create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryCreateParams) WithDefaults() *ActiveDirectoryCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the active directory create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := ActiveDirectoryCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the active directory create params
func (o *ActiveDirectoryCreateParams) WithTimeout(timeout time.Duration) *ActiveDirectoryCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the active directory create params
func (o *ActiveDirectoryCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the active directory create params
func (o *ActiveDirectoryCreateParams) WithContext(ctx context.Context) *ActiveDirectoryCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the active directory create params
func (o *ActiveDirectoryCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the active directory create params
func (o *ActiveDirectoryCreateParams) WithHTTPClient(client *http.Client) *ActiveDirectoryCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the active directory create params
func (o *ActiveDirectoryCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the active directory create params
func (o *ActiveDirectoryCreateParams) WithInfo(info *models.ActiveDirectory) *ActiveDirectoryCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the active directory create params
func (o *ActiveDirectoryCreateParams) SetInfo(info *models.ActiveDirectory) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the active directory create params
func (o *ActiveDirectoryCreateParams) WithReturnRecords(returnRecords *bool) *ActiveDirectoryCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the active directory create params
func (o *ActiveDirectoryCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *ActiveDirectoryCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
