// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewActiveDirectoryDeleteCollectionParams creates a new ActiveDirectoryDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewActiveDirectoryDeleteCollectionParams() *ActiveDirectoryDeleteCollectionParams {
	return &ActiveDirectoryDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewActiveDirectoryDeleteCollectionParamsWithTimeout creates a new ActiveDirectoryDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewActiveDirectoryDeleteCollectionParamsWithTimeout(timeout time.Duration) *ActiveDirectoryDeleteCollectionParams {
	return &ActiveDirectoryDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewActiveDirectoryDeleteCollectionParamsWithContext creates a new ActiveDirectoryDeleteCollectionParams object
// with the ability to set a context for a request.
func NewActiveDirectoryDeleteCollectionParamsWithContext(ctx context.Context) *ActiveDirectoryDeleteCollectionParams {
	return &ActiveDirectoryDeleteCollectionParams{
		Context: ctx,
	}
}

// NewActiveDirectoryDeleteCollectionParamsWithHTTPClient creates a new ActiveDirectoryDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewActiveDirectoryDeleteCollectionParamsWithHTTPClient(client *http.Client) *ActiveDirectoryDeleteCollectionParams {
	return &ActiveDirectoryDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
ActiveDirectoryDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the active directory delete collection operation.

	Typically these are written to a http.Request.
*/
type ActiveDirectoryDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DiscoveredServersDomain.

	   Filter by discovered_servers.domain
	*/
	DiscoveredServersDomain *string

	/* DiscoveredServersNodeName.

	   Filter by discovered_servers.node.name
	*/
	DiscoveredServersNodeName *string

	/* DiscoveredServersNodeUUID.

	   Filter by discovered_servers.node.uuid
	*/
	DiscoveredServersNodeUUID *string

	/* DiscoveredServersPreference.

	   Filter by discovered_servers.preference
	*/
	DiscoveredServersPreference *string

	/* DiscoveredServersServerIP.

	   Filter by discovered_servers.server.ip
	*/
	DiscoveredServersServerIP *string

	/* DiscoveredServersServerName.

	   Filter by discovered_servers.server.name
	*/
	DiscoveredServersServerName *string

	/* DiscoveredServersServerType.

	   Filter by discovered_servers.server.type
	*/
	DiscoveredServersServerType *string

	/* DiscoveredServersState.

	   Filter by discovered_servers.state
	*/
	DiscoveredServersState *string

	/* Fqdn.

	   Filter by fqdn
	*/
	Fqdn *string

	/* Info.

	   Info specification
	*/
	Info ActiveDirectoryDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrganizationalUnit.

	   Filter by organizational_unit
	*/
	OrganizationalUnit *string

	/* PreferredDcsFqdn.

	   Filter by preferred_dcs.fqdn
	*/
	PreferredDcsFqdn *string

	/* PreferredDcsServerIP.

	   Filter by preferred_dcs.server_ip
	*/
	PreferredDcsServerIP *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecurityAdvertisedKdcEncryptions.

	   Filter by security.advertised_kdc_encryptions
	*/
	SecurityAdvertisedKdcEncryptions *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the active directory delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryDeleteCollectionParams) WithDefaults() *ActiveDirectoryDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the active directory delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ActiveDirectoryDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithTimeout(timeout time.Duration) *ActiveDirectoryDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithContext(ctx context.Context) *ActiveDirectoryDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithHTTPClient(client *http.Client) *ActiveDirectoryDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ActiveDirectoryDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDiscoveredServersDomain adds the discoveredServersDomain to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithDiscoveredServersDomain(discoveredServersDomain *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetDiscoveredServersDomain(discoveredServersDomain)
	return o
}

// SetDiscoveredServersDomain adds the discoveredServersDomain to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetDiscoveredServersDomain(discoveredServersDomain *string) {
	o.DiscoveredServersDomain = discoveredServersDomain
}

// WithDiscoveredServersNodeName adds the discoveredServersNodeName to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithDiscoveredServersNodeName(discoveredServersNodeName *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetDiscoveredServersNodeName(discoveredServersNodeName)
	return o
}

// SetDiscoveredServersNodeName adds the discoveredServersNodeName to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetDiscoveredServersNodeName(discoveredServersNodeName *string) {
	o.DiscoveredServersNodeName = discoveredServersNodeName
}

// WithDiscoveredServersNodeUUID adds the discoveredServersNodeUUID to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithDiscoveredServersNodeUUID(discoveredServersNodeUUID *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetDiscoveredServersNodeUUID(discoveredServersNodeUUID)
	return o
}

// SetDiscoveredServersNodeUUID adds the discoveredServersNodeUuid to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetDiscoveredServersNodeUUID(discoveredServersNodeUUID *string) {
	o.DiscoveredServersNodeUUID = discoveredServersNodeUUID
}

// WithDiscoveredServersPreference adds the discoveredServersPreference to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithDiscoveredServersPreference(discoveredServersPreference *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetDiscoveredServersPreference(discoveredServersPreference)
	return o
}

// SetDiscoveredServersPreference adds the discoveredServersPreference to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetDiscoveredServersPreference(discoveredServersPreference *string) {
	o.DiscoveredServersPreference = discoveredServersPreference
}

// WithDiscoveredServersServerIP adds the discoveredServersServerIP to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithDiscoveredServersServerIP(discoveredServersServerIP *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetDiscoveredServersServerIP(discoveredServersServerIP)
	return o
}

// SetDiscoveredServersServerIP adds the discoveredServersServerIp to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetDiscoveredServersServerIP(discoveredServersServerIP *string) {
	o.DiscoveredServersServerIP = discoveredServersServerIP
}

// WithDiscoveredServersServerName adds the discoveredServersServerName to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithDiscoveredServersServerName(discoveredServersServerName *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetDiscoveredServersServerName(discoveredServersServerName)
	return o
}

// SetDiscoveredServersServerName adds the discoveredServersServerName to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetDiscoveredServersServerName(discoveredServersServerName *string) {
	o.DiscoveredServersServerName = discoveredServersServerName
}

// WithDiscoveredServersServerType adds the discoveredServersServerType to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithDiscoveredServersServerType(discoveredServersServerType *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetDiscoveredServersServerType(discoveredServersServerType)
	return o
}

// SetDiscoveredServersServerType adds the discoveredServersServerType to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetDiscoveredServersServerType(discoveredServersServerType *string) {
	o.DiscoveredServersServerType = discoveredServersServerType
}

// WithDiscoveredServersState adds the discoveredServersState to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithDiscoveredServersState(discoveredServersState *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetDiscoveredServersState(discoveredServersState)
	return o
}

// SetDiscoveredServersState adds the discoveredServersState to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetDiscoveredServersState(discoveredServersState *string) {
	o.DiscoveredServersState = discoveredServersState
}

// WithFqdn adds the fqdn to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithFqdn(fqdn *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetFqdn(fqdn)
	return o
}

// SetFqdn adds the fqdn to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetFqdn(fqdn *string) {
	o.Fqdn = fqdn
}

// WithInfo adds the info to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithInfo(info ActiveDirectoryDeleteCollectionBody) *ActiveDirectoryDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetInfo(info ActiveDirectoryDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithName(name *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOrganizationalUnit adds the organizationalUnit to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithOrganizationalUnit(organizationalUnit *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetOrganizationalUnit(organizationalUnit)
	return o
}

// SetOrganizationalUnit adds the organizationalUnit to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetOrganizationalUnit(organizationalUnit *string) {
	o.OrganizationalUnit = organizationalUnit
}

// WithPreferredDcsFqdn adds the preferredDcsFqdn to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithPreferredDcsFqdn(preferredDcsFqdn *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetPreferredDcsFqdn(preferredDcsFqdn)
	return o
}

// SetPreferredDcsFqdn adds the preferredDcsFqdn to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetPreferredDcsFqdn(preferredDcsFqdn *string) {
	o.PreferredDcsFqdn = preferredDcsFqdn
}

// WithPreferredDcsServerIP adds the preferredDcsServerIP to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithPreferredDcsServerIP(preferredDcsServerIP *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetPreferredDcsServerIP(preferredDcsServerIP)
	return o
}

// SetPreferredDcsServerIP adds the preferredDcsServerIp to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetPreferredDcsServerIP(preferredDcsServerIP *string) {
	o.PreferredDcsServerIP = preferredDcsServerIP
}

// WithReturnRecords adds the returnRecords to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *ActiveDirectoryDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *ActiveDirectoryDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecurityAdvertisedKdcEncryptions adds the securityAdvertisedKdcEncryptions to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions)
	return o
}

// SetSecurityAdvertisedKdcEncryptions adds the securityAdvertisedKdcEncryptions to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetSecurityAdvertisedKdcEncryptions(securityAdvertisedKdcEncryptions *string) {
	o.SecurityAdvertisedKdcEncryptions = securityAdvertisedKdcEncryptions
}

// WithSerialRecords adds the serialRecords to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *ActiveDirectoryDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithSvmName(svmName *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) WithSvmUUID(svmUUID *string) *ActiveDirectoryDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the active directory delete collection params
func (o *ActiveDirectoryDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *ActiveDirectoryDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersDomain != nil {

		// query param discovered_servers.domain
		var qrDiscoveredServersDomain string

		if o.DiscoveredServersDomain != nil {
			qrDiscoveredServersDomain = *o.DiscoveredServersDomain
		}
		qDiscoveredServersDomain := qrDiscoveredServersDomain
		if qDiscoveredServersDomain != "" {

			if err := r.SetQueryParam("discovered_servers.domain", qDiscoveredServersDomain); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersNodeName != nil {

		// query param discovered_servers.node.name
		var qrDiscoveredServersNodeName string

		if o.DiscoveredServersNodeName != nil {
			qrDiscoveredServersNodeName = *o.DiscoveredServersNodeName
		}
		qDiscoveredServersNodeName := qrDiscoveredServersNodeName
		if qDiscoveredServersNodeName != "" {

			if err := r.SetQueryParam("discovered_servers.node.name", qDiscoveredServersNodeName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersNodeUUID != nil {

		// query param discovered_servers.node.uuid
		var qrDiscoveredServersNodeUUID string

		if o.DiscoveredServersNodeUUID != nil {
			qrDiscoveredServersNodeUUID = *o.DiscoveredServersNodeUUID
		}
		qDiscoveredServersNodeUUID := qrDiscoveredServersNodeUUID
		if qDiscoveredServersNodeUUID != "" {

			if err := r.SetQueryParam("discovered_servers.node.uuid", qDiscoveredServersNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersPreference != nil {

		// query param discovered_servers.preference
		var qrDiscoveredServersPreference string

		if o.DiscoveredServersPreference != nil {
			qrDiscoveredServersPreference = *o.DiscoveredServersPreference
		}
		qDiscoveredServersPreference := qrDiscoveredServersPreference
		if qDiscoveredServersPreference != "" {

			if err := r.SetQueryParam("discovered_servers.preference", qDiscoveredServersPreference); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerIP != nil {

		// query param discovered_servers.server.ip
		var qrDiscoveredServersServerIP string

		if o.DiscoveredServersServerIP != nil {
			qrDiscoveredServersServerIP = *o.DiscoveredServersServerIP
		}
		qDiscoveredServersServerIP := qrDiscoveredServersServerIP
		if qDiscoveredServersServerIP != "" {

			if err := r.SetQueryParam("discovered_servers.server.ip", qDiscoveredServersServerIP); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerName != nil {

		// query param discovered_servers.server.name
		var qrDiscoveredServersServerName string

		if o.DiscoveredServersServerName != nil {
			qrDiscoveredServersServerName = *o.DiscoveredServersServerName
		}
		qDiscoveredServersServerName := qrDiscoveredServersServerName
		if qDiscoveredServersServerName != "" {

			if err := r.SetQueryParam("discovered_servers.server.name", qDiscoveredServersServerName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerType != nil {

		// query param discovered_servers.server.type
		var qrDiscoveredServersServerType string

		if o.DiscoveredServersServerType != nil {
			qrDiscoveredServersServerType = *o.DiscoveredServersServerType
		}
		qDiscoveredServersServerType := qrDiscoveredServersServerType
		if qDiscoveredServersServerType != "" {

			if err := r.SetQueryParam("discovered_servers.server.type", qDiscoveredServersServerType); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersState != nil {

		// query param discovered_servers.state
		var qrDiscoveredServersState string

		if o.DiscoveredServersState != nil {
			qrDiscoveredServersState = *o.DiscoveredServersState
		}
		qDiscoveredServersState := qrDiscoveredServersState
		if qDiscoveredServersState != "" {

			if err := r.SetQueryParam("discovered_servers.state", qDiscoveredServersState); err != nil {
				return err
			}
		}
	}

	if o.Fqdn != nil {

		// query param fqdn
		var qrFqdn string

		if o.Fqdn != nil {
			qrFqdn = *o.Fqdn
		}
		qFqdn := qrFqdn
		if qFqdn != "" {

			if err := r.SetQueryParam("fqdn", qFqdn); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrganizationalUnit != nil {

		// query param organizational_unit
		var qrOrganizationalUnit string

		if o.OrganizationalUnit != nil {
			qrOrganizationalUnit = *o.OrganizationalUnit
		}
		qOrganizationalUnit := qrOrganizationalUnit
		if qOrganizationalUnit != "" {

			if err := r.SetQueryParam("organizational_unit", qOrganizationalUnit); err != nil {
				return err
			}
		}
	}

	if o.PreferredDcsFqdn != nil {

		// query param preferred_dcs.fqdn
		var qrPreferredDcsFqdn string

		if o.PreferredDcsFqdn != nil {
			qrPreferredDcsFqdn = *o.PreferredDcsFqdn
		}
		qPreferredDcsFqdn := qrPreferredDcsFqdn
		if qPreferredDcsFqdn != "" {

			if err := r.SetQueryParam("preferred_dcs.fqdn", qPreferredDcsFqdn); err != nil {
				return err
			}
		}
	}

	if o.PreferredDcsServerIP != nil {

		// query param preferred_dcs.server_ip
		var qrPreferredDcsServerIP string

		if o.PreferredDcsServerIP != nil {
			qrPreferredDcsServerIP = *o.PreferredDcsServerIP
		}
		qPreferredDcsServerIP := qrPreferredDcsServerIP
		if qPreferredDcsServerIP != "" {

			if err := r.SetQueryParam("preferred_dcs.server_ip", qPreferredDcsServerIP); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecurityAdvertisedKdcEncryptions != nil {

		// query param security.advertised_kdc_encryptions
		var qrSecurityAdvertisedKdcEncryptions string

		if o.SecurityAdvertisedKdcEncryptions != nil {
			qrSecurityAdvertisedKdcEncryptions = *o.SecurityAdvertisedKdcEncryptions
		}
		qSecurityAdvertisedKdcEncryptions := qrSecurityAdvertisedKdcEncryptions
		if qSecurityAdvertisedKdcEncryptions != "" {

			if err := r.SetQueryParam("security.advertised_kdc_encryptions", qSecurityAdvertisedKdcEncryptions); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
