// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ActiveDirectoryDeleteCollectionReader is a Reader for the ActiveDirectoryDeleteCollection structure.
type ActiveDirectoryDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ActiveDirectoryDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewActiveDirectoryDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewActiveDirectoryDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewActiveDirectoryDeleteCollectionOK creates a ActiveDirectoryDeleteCollectionOK with default headers values
func NewActiveDirectoryDeleteCollectionOK() *ActiveDirectoryDeleteCollectionOK {
	return &ActiveDirectoryDeleteCollectionOK{}
}

/*
ActiveDirectoryDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ActiveDirectoryDeleteCollectionOK struct {
}

// IsSuccess returns true when this active directory delete collection o k response has a 2xx status code
func (o *ActiveDirectoryDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this active directory delete collection o k response has a 3xx status code
func (o *ActiveDirectoryDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this active directory delete collection o k response has a 4xx status code
func (o *ActiveDirectoryDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this active directory delete collection o k response has a 5xx status code
func (o *ActiveDirectoryDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this active directory delete collection o k response a status code equal to that given
func (o *ActiveDirectoryDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the active directory delete collection o k response
func (o *ActiveDirectoryDeleteCollectionOK) Code() int {
	return 200
}

func (o *ActiveDirectoryDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/active-directory][%d] activeDirectoryDeleteCollectionOK", 200)
}

func (o *ActiveDirectoryDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/active-directory][%d] activeDirectoryDeleteCollectionOK", 200)
}

func (o *ActiveDirectoryDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewActiveDirectoryDeleteCollectionDefault creates a ActiveDirectoryDeleteCollectionDefault with default headers values
func NewActiveDirectoryDeleteCollectionDefault(code int) *ActiveDirectoryDeleteCollectionDefault {
	return &ActiveDirectoryDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ActiveDirectoryDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655414 | Failed to remove Active Directory machine. |
| 655431 | Username cannot be empty. |
| 655432 | Password cannot be empty. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ActiveDirectoryDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this active directory delete collection default response has a 2xx status code
func (o *ActiveDirectoryDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this active directory delete collection default response has a 3xx status code
func (o *ActiveDirectoryDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this active directory delete collection default response has a 4xx status code
func (o *ActiveDirectoryDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this active directory delete collection default response has a 5xx status code
func (o *ActiveDirectoryDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this active directory delete collection default response a status code equal to that given
func (o *ActiveDirectoryDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the active directory delete collection default response
func (o *ActiveDirectoryDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ActiveDirectoryDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/active-directory][%d] active_directory_delete_collection default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/active-directory][%d] active_directory_delete_collection default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ActiveDirectoryDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ActiveDirectoryDeleteCollectionBody active directory delete collection body
swagger:model ActiveDirectoryDeleteCollectionBody
*/
type ActiveDirectoryDeleteCollectionBody struct {

	// active directory response inline records
	ActiveDirectoryResponseInlineRecords []*models.ActiveDirectory `json:"records,omitempty"`
}

// Validate validates this active directory delete collection body
func (o *ActiveDirectoryDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateActiveDirectoryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryDeleteCollectionBody) validateActiveDirectoryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ActiveDirectoryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ActiveDirectoryResponseInlineRecords); i++ {
		if swag.IsZero(o.ActiveDirectoryResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ActiveDirectoryResponseInlineRecords[i] != nil {
			if err := o.ActiveDirectoryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this active directory delete collection body based on the context it is used
func (o *ActiveDirectoryDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateActiveDirectoryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryDeleteCollectionBody) contextValidateActiveDirectoryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ActiveDirectoryResponseInlineRecords); i++ {

		if o.ActiveDirectoryResponseInlineRecords[i] != nil {
			if err := o.ActiveDirectoryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ActiveDirectoryDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ActiveDirectoryDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
