// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ActiveDirectoryDeleteReader is a Reader for the ActiveDirectoryDelete structure.
type ActiveDirectoryDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ActiveDirectoryDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewActiveDirectoryDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewActiveDirectoryDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewActiveDirectoryDeleteOK creates a ActiveDirectoryDeleteOK with default headers values
func NewActiveDirectoryDeleteOK() *ActiveDirectoryDeleteOK {
	return &ActiveDirectoryDeleteOK{}
}

/*
ActiveDirectoryDeleteOK describes a response with status code 200, with default header values.

OK
*/
type ActiveDirectoryDeleteOK struct {
}

// IsSuccess returns true when this active directory delete o k response has a 2xx status code
func (o *ActiveDirectoryDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this active directory delete o k response has a 3xx status code
func (o *ActiveDirectoryDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this active directory delete o k response has a 4xx status code
func (o *ActiveDirectoryDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this active directory delete o k response has a 5xx status code
func (o *ActiveDirectoryDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this active directory delete o k response a status code equal to that given
func (o *ActiveDirectoryDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the active directory delete o k response
func (o *ActiveDirectoryDeleteOK) Code() int {
	return 200
}

func (o *ActiveDirectoryDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/active-directory/{svm.uuid}][%d] activeDirectoryDeleteOK", 200)
}

func (o *ActiveDirectoryDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/active-directory/{svm.uuid}][%d] activeDirectoryDeleteOK", 200)
}

func (o *ActiveDirectoryDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewActiveDirectoryDeleteDefault creates a ActiveDirectoryDeleteDefault with default headers values
func NewActiveDirectoryDeleteDefault(code int) *ActiveDirectoryDeleteDefault {
	return &ActiveDirectoryDeleteDefault{
		_statusCode: code,
	}
}

/*
	ActiveDirectoryDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655414 | Failed to remove Active Directory machine. |
| 655431 | Username cannot be empty. |
| 655432 | Password cannot be empty. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ActiveDirectoryDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this active directory delete default response has a 2xx status code
func (o *ActiveDirectoryDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this active directory delete default response has a 3xx status code
func (o *ActiveDirectoryDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this active directory delete default response has a 4xx status code
func (o *ActiveDirectoryDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this active directory delete default response has a 5xx status code
func (o *ActiveDirectoryDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this active directory delete default response a status code equal to that given
func (o *ActiveDirectoryDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the active directory delete default response
func (o *ActiveDirectoryDeleteDefault) Code() int {
	return o._statusCode
}

func (o *ActiveDirectoryDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/active-directory/{svm.uuid}][%d] active_directory_delete default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/active-directory/{svm.uuid}][%d] active_directory_delete default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ActiveDirectoryDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
