// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewActiveDirectoryGetParams creates a new ActiveDirectoryGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewActiveDirectoryGetParams() *ActiveDirectoryGetParams {
	return &ActiveDirectoryGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewActiveDirectoryGetParamsWithTimeout creates a new ActiveDirectoryGetParams object
// with the ability to set a timeout on a request.
func NewActiveDirectoryGetParamsWithTimeout(timeout time.Duration) *ActiveDirectoryGetParams {
	return &ActiveDirectoryGetParams{
		timeout: timeout,
	}
}

// NewActiveDirectoryGetParamsWithContext creates a new ActiveDirectoryGetParams object
// with the ability to set a context for a request.
func NewActiveDirectoryGetParamsWithContext(ctx context.Context) *ActiveDirectoryGetParams {
	return &ActiveDirectoryGetParams{
		Context: ctx,
	}
}

// NewActiveDirectoryGetParamsWithHTTPClient creates a new ActiveDirectoryGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewActiveDirectoryGetParamsWithHTTPClient(client *http.Client) *ActiveDirectoryGetParams {
	return &ActiveDirectoryGetParams{
		HTTPClient: client,
	}
}

/*
ActiveDirectoryGetParams contains all the parameters to send to the API endpoint

	for the active directory get operation.

	Typically these are written to a http.Request.
*/
type ActiveDirectoryGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ResetDiscoveredServers.

	   Force a rediscovery.
	*/
	ResetDiscoveredServers *bool

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the active directory get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryGetParams) WithDefaults() *ActiveDirectoryGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the active directory get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryGetParams) SetDefaults() {
	var (
		resetDiscoveredServersDefault = bool(false)
	)

	val := ActiveDirectoryGetParams{
		ResetDiscoveredServers: &resetDiscoveredServersDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the active directory get params
func (o *ActiveDirectoryGetParams) WithTimeout(timeout time.Duration) *ActiveDirectoryGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the active directory get params
func (o *ActiveDirectoryGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the active directory get params
func (o *ActiveDirectoryGetParams) WithContext(ctx context.Context) *ActiveDirectoryGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the active directory get params
func (o *ActiveDirectoryGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the active directory get params
func (o *ActiveDirectoryGetParams) WithHTTPClient(client *http.Client) *ActiveDirectoryGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the active directory get params
func (o *ActiveDirectoryGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the active directory get params
func (o *ActiveDirectoryGetParams) WithFields(fields []string) *ActiveDirectoryGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the active directory get params
func (o *ActiveDirectoryGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithResetDiscoveredServers adds the resetDiscoveredServers to the active directory get params
func (o *ActiveDirectoryGetParams) WithResetDiscoveredServers(resetDiscoveredServers *bool) *ActiveDirectoryGetParams {
	o.SetResetDiscoveredServers(resetDiscoveredServers)
	return o
}

// SetResetDiscoveredServers adds the resetDiscoveredServers to the active directory get params
func (o *ActiveDirectoryGetParams) SetResetDiscoveredServers(resetDiscoveredServers *bool) {
	o.ResetDiscoveredServers = resetDiscoveredServers
}

// WithSvmUUID adds the svmUUID to the active directory get params
func (o *ActiveDirectoryGetParams) WithSvmUUID(svmUUID string) *ActiveDirectoryGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the active directory get params
func (o *ActiveDirectoryGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *ActiveDirectoryGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ResetDiscoveredServers != nil {

		// query param reset_discovered_servers
		var qrResetDiscoveredServers bool

		if o.ResetDiscoveredServers != nil {
			qrResetDiscoveredServers = *o.ResetDiscoveredServers
		}
		qResetDiscoveredServers := swag.FormatBool(qrResetDiscoveredServers)
		if qResetDiscoveredServers != "" {

			if err := r.SetQueryParam("reset_discovered_servers", qResetDiscoveredServers); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamActiveDirectoryGet binds the parameter fields
func (o *ActiveDirectoryGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
