// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ActiveDirectoryModifyCollectionReader is a Reader for the ActiveDirectoryModifyCollection structure.
type ActiveDirectoryModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ActiveDirectoryModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewActiveDirectoryModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewActiveDirectoryModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewActiveDirectoryModifyCollectionOK creates a ActiveDirectoryModifyCollectionOK with default headers values
func NewActiveDirectoryModifyCollectionOK() *ActiveDirectoryModifyCollectionOK {
	return &ActiveDirectoryModifyCollectionOK{}
}

/*
ActiveDirectoryModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ActiveDirectoryModifyCollectionOK struct {
	Payload *models.ActiveDirectory
}

// IsSuccess returns true when this active directory modify collection o k response has a 2xx status code
func (o *ActiveDirectoryModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this active directory modify collection o k response has a 3xx status code
func (o *ActiveDirectoryModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this active directory modify collection o k response has a 4xx status code
func (o *ActiveDirectoryModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this active directory modify collection o k response has a 5xx status code
func (o *ActiveDirectoryModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this active directory modify collection o k response a status code equal to that given
func (o *ActiveDirectoryModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the active directory modify collection o k response
func (o *ActiveDirectoryModifyCollectionOK) Code() int {
	return 200
}

func (o *ActiveDirectoryModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/active-directory][%d] activeDirectoryModifyCollectionOK %s", 200, payload)
}

func (o *ActiveDirectoryModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/active-directory][%d] activeDirectoryModifyCollectionOK %s", 200, payload)
}

func (o *ActiveDirectoryModifyCollectionOK) GetPayload() *models.ActiveDirectory {
	return o.Payload
}

func (o *ActiveDirectoryModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ActiveDirectory)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewActiveDirectoryModifyCollectionDefault creates a ActiveDirectoryModifyCollectionDefault with default headers values
func NewActiveDirectoryModifyCollectionDefault(code int) *ActiveDirectoryModifyCollectionDefault {
	return &ActiveDirectoryModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ActiveDirectoryModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 656464 | Failed to modify the Active Directory machine account. Reason: Invalid Credentials. |
| 656465 | Failed to create the Active Directory machine account. Reason: An account with this name already exists. |
| 656466 | Failed to create the Active Directory machine account. Reason: Unable to connect to any domain controllers. |
| 656467 | Failed to modify the Active Directory machine account. Reason: Organizational-Unit not found. |
| 656478 | Failed to create the Active Directory machine account. Reason: KDC has no support for encryption type. |
| 656490 | Unable to modify the Active Directory account. The Active Directory account name is already used by another SVM. |
| 656495 | Failed to update Active Directory security settings for SVM. |
| 656496 | Failed to update Active Directory security settings for SVM. Reason: KDC has no support for encryption type. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ActiveDirectoryModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this active directory modify collection default response has a 2xx status code
func (o *ActiveDirectoryModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this active directory modify collection default response has a 3xx status code
func (o *ActiveDirectoryModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this active directory modify collection default response has a 4xx status code
func (o *ActiveDirectoryModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this active directory modify collection default response has a 5xx status code
func (o *ActiveDirectoryModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this active directory modify collection default response a status code equal to that given
func (o *ActiveDirectoryModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the active directory modify collection default response
func (o *ActiveDirectoryModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ActiveDirectoryModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/active-directory][%d] active_directory_modify_collection default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/active-directory][%d] active_directory_modify_collection default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ActiveDirectoryModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ActiveDirectoryModifyCollectionBody active directory modify collection body
swagger:model ActiveDirectoryModifyCollectionBody
*/
type ActiveDirectoryModifyCollectionBody struct {

	// Specifies the discovered servers records.
	// Read Only: true
	ActiveDirectoryInlineDiscoveredServers []*models.ActiveDirectoryInlineDiscoveredServersInlineArrayItem `json:"discovered_servers,omitempty"`

	// Specifies the preferred domain controller (DC) records.
	// Read Only: true
	ActiveDirectoryInlinePreferredDcs []*models.ActiveDirectoryInlinePreferredDcsInlineArrayItem `json:"preferred_dcs,omitempty"`

	// active directory response inline records
	ActiveDirectoryResponseInlineRecords []*models.ActiveDirectory `json:"records,omitempty"`

	// If set to true and a machine account exists with the same name as specified in "name" in Active Directory, it will be overwritten and reused.
	// Example: false
	ForceAccountOverwrite *bool `json:"force_account_overwrite,omitempty"`

	// Fully qualified domain name.
	// Example: server1.com
	// Max Length: 254
	Fqdn *string `json:"fqdn,omitempty"`

	// Active Directory (AD) account NetBIOS name.
	// Example: account1
	// Max Length: 15
	Name *string `json:"name,omitempty"`

	// Organizational unit under which the Active Directory account will be created.
	// Example: CN=Test
	OrganizationalUnit *string `json:"organizational_unit,omitempty"`

	// Administrator password required for Active Directory account creation, modification and deletion.
	// Example: testpwd
	// Min Length: 1
	Password *string `json:"password,omitempty"`

	// security
	Security *models.ActiveDirectorySecurity `json:"security,omitempty"`

	// svm
	Svm *models.ActiveDirectoryInlineSvm `json:"svm,omitempty"`

	// Administrator username required for Active Directory account creation, modification and deletion.
	// Example: admin
	// Min Length: 1
	Username *string `json:"username,omitempty"`
}

// Validate validates this active directory modify collection body
func (o *ActiveDirectoryModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateActiveDirectoryInlineDiscoveredServers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateActiveDirectoryInlinePreferredDcs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateActiveDirectoryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFqdn(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUsername(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validateActiveDirectoryInlineDiscoveredServers(formats strfmt.Registry) error {
	if swag.IsZero(o.ActiveDirectoryInlineDiscoveredServers) { // not required
		return nil
	}

	for i := 0; i < len(o.ActiveDirectoryInlineDiscoveredServers); i++ {
		if swag.IsZero(o.ActiveDirectoryInlineDiscoveredServers[i]) { // not required
			continue
		}

		if o.ActiveDirectoryInlineDiscoveredServers[i] != nil {
			if err := o.ActiveDirectoryInlineDiscoveredServers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "discovered_servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validateActiveDirectoryInlinePreferredDcs(formats strfmt.Registry) error {
	if swag.IsZero(o.ActiveDirectoryInlinePreferredDcs) { // not required
		return nil
	}

	for i := 0; i < len(o.ActiveDirectoryInlinePreferredDcs); i++ {
		if swag.IsZero(o.ActiveDirectoryInlinePreferredDcs[i]) { // not required
			continue
		}

		if o.ActiveDirectoryInlinePreferredDcs[i] != nil {
			if err := o.ActiveDirectoryInlinePreferredDcs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "preferred_dcs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validateActiveDirectoryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ActiveDirectoryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ActiveDirectoryResponseInlineRecords); i++ {
		if swag.IsZero(o.ActiveDirectoryResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ActiveDirectoryResponseInlineRecords[i] != nil {
			if err := o.ActiveDirectoryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validateFqdn(formats strfmt.Registry) error {
	if swag.IsZero(o.Fqdn) { // not required
		return nil
	}

	if err := validate.MaxLength("info"+"."+"fqdn", "body", *o.Fqdn, 254); err != nil {
		return err
	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 15); err != nil {
		return err
	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(o.Password) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"password", "body", *o.Password, 1); err != nil {
		return err
	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validateSecurity(formats strfmt.Registry) error {
	if swag.IsZero(o.Security) { // not required
		return nil
	}

	if o.Security != nil {
		if err := o.Security.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "security")
			}
			return err
		}
	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) validateUsername(formats strfmt.Registry) error {
	if swag.IsZero(o.Username) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"username", "body", *o.Username, 1); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this active directory modify collection body based on the context it is used
func (o *ActiveDirectoryModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateActiveDirectoryInlineDiscoveredServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateActiveDirectoryInlinePreferredDcs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateActiveDirectoryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) contextValidateActiveDirectoryInlineDiscoveredServers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"discovered_servers", "body", []*models.ActiveDirectoryInlineDiscoveredServersInlineArrayItem(o.ActiveDirectoryInlineDiscoveredServers)); err != nil {
		return err
	}

	for i := 0; i < len(o.ActiveDirectoryInlineDiscoveredServers); i++ {

		if o.ActiveDirectoryInlineDiscoveredServers[i] != nil {
			if err := o.ActiveDirectoryInlineDiscoveredServers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "discovered_servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) contextValidateActiveDirectoryInlinePreferredDcs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"preferred_dcs", "body", []*models.ActiveDirectoryInlinePreferredDcsInlineArrayItem(o.ActiveDirectoryInlinePreferredDcs)); err != nil {
		return err
	}

	for i := 0; i < len(o.ActiveDirectoryInlinePreferredDcs); i++ {

		if o.ActiveDirectoryInlinePreferredDcs[i] != nil {
			if err := o.ActiveDirectoryInlinePreferredDcs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "preferred_dcs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) contextValidateActiveDirectoryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ActiveDirectoryResponseInlineRecords); i++ {

		if o.ActiveDirectoryResponseInlineRecords[i] != nil {
			if err := o.ActiveDirectoryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) contextValidateSecurity(ctx context.Context, formats strfmt.Registry) error {

	if o.Security != nil {
		if err := o.Security.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "security")
			}
			return err
		}
	}

	return nil
}

func (o *ActiveDirectoryModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ActiveDirectoryModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ActiveDirectoryModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ActiveDirectoryInlineDiscoveredServersInlineArrayItem active directory inline discovered servers inline array item
swagger:model active_directory_inline_discovered_servers_inline_array_item
*/
type ActiveDirectoryInlineDiscoveredServersInlineArrayItem struct {

	// The Active Directory domain that the discovered server is a member of.
	// Example: server1.com
	Domain *string `json:"domain,omitempty"`

	// node
	Node *models.ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode `json:"node,omitempty"`

	// The preference level of the server that was discovered.
	// Example: preferred
	// Enum: ["unknown","preferred","favored","adequate"]
	Preference *string `json:"preference,omitempty"`

	// server
	Server *models.ActiveDirectoryDiscoveredServerReference `json:"server,omitempty"`

	// The status of the connection to the server that was discovered.
	// Example: ok
	// Enum: ["ok","unavailable","slow","expired","undetermined","unreachable"]
	State *string `json:"state,omitempty"`
}

// Validate validates this active directory inline discovered servers inline array item
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePreference(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var activeDirectoryInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","preferred","favored","adequate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		activeDirectoryInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum = append(activeDirectoryInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// unknown
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemPreferenceUnknown captures enum value "unknown"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemPreferenceUnknown string = "unknown"

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// preferred
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemPreferencePreferred captures enum value "preferred"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemPreferencePreferred string = "preferred"

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// favored
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemPreferenceFavored captures enum value "favored"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemPreferenceFavored string = "favored"

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// adequate
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemPreferenceAdequate captures enum value "adequate"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemPreferenceAdequate string = "adequate"
)

// prop value enum
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) validatePreferenceEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, activeDirectoryInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) validatePreference(formats strfmt.Registry) error {
	if swag.IsZero(o.Preference) { // not required
		return nil
	}

	// value enum
	if err := o.validatePreferenceEnum("preference", "body", *o.Preference); err != nil {
		return err
	}

	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) validateServer(formats strfmt.Registry) error {
	if swag.IsZero(o.Server) { // not required
		return nil
	}

	if o.Server != nil {
		if err := o.Server.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server")
			}
			return err
		}
	}

	return nil
}

var activeDirectoryInlineDiscoveredServersInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","unavailable","slow","expired","undetermined","unreachable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		activeDirectoryInlineDiscoveredServersInlineArrayItemTypeStatePropEnum = append(activeDirectoryInlineDiscoveredServersInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateOk captures enum value "ok"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// unavailable
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateUnavailable captures enum value "unavailable"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateUnavailable string = "unavailable"

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// slow
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateSlow captures enum value "slow"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateSlow string = "slow"

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// expired
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateExpired captures enum value "expired"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateExpired string = "expired"

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// undetermined
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateUndetermined captures enum value "undetermined"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateUndetermined string = "undetermined"

	// BEGIN DEBUGGING
	// active_directory_inline_discovered_servers_inline_array_item
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// unreachable
	// END DEBUGGING
	// ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateUnreachable captures enum value "unreachable"
	ActiveDirectoryInlineDiscoveredServersInlineArrayItemStateUnreachable string = "unreachable"
)

// prop value enum
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, activeDirectoryInlineDiscoveredServersInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this active directory inline discovered servers inline array item based on the context it is used
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) contextValidateServer(ctx context.Context, formats strfmt.Registry) error {

	if o.Server != nil {
		if err := o.Server.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryInlineDiscoveredServersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode active directory inline discovered servers inline array item inline node
swagger:model active_directory_inline_discovered_servers_inline_array_item_inline_node
*/
type ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode struct {

	// links
	Links *models.ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this active directory inline discovered servers inline array item inline node
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this active directory inline discovered servers inline array item inline node based on the context it is used
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks active directory inline discovered servers inline array item inline node inline links
swagger:model active_directory_inline_discovered_servers_inline_array_item_inline_node_inline__links
*/
type ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this active directory inline discovered servers inline array item inline node inline links
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this active directory inline discovered servers inline array item inline node inline links based on the context it is used
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ActiveDirectoryInlinePreferredDcsInlineArrayItem active directory inline preferred dcs inline array item
swagger:model active_directory_inline_preferred_dcs_inline_array_item
*/
type ActiveDirectoryInlinePreferredDcsInlineArrayItem struct {

	// Fully Qualified Domain Name.
	// Example: test.com
	// Max Length: 254
	Fqdn *string `json:"fqdn,omitempty"`

	// IP address of the preferred DC. The address can be either an IPv4 or an IPv6 address.
	// Example: 4.4.4.4
	ServerIP *string `json:"server_ip,omitempty"`
}

// Validate validates this active directory inline preferred dcs inline array item
func (o *ActiveDirectoryInlinePreferredDcsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFqdn(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlinePreferredDcsInlineArrayItem) validateFqdn(formats strfmt.Registry) error {
	if swag.IsZero(o.Fqdn) { // not required
		return nil
	}

	if err := validate.MaxLength("fqdn", "body", *o.Fqdn, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this active directory inline preferred dcs inline array item based on context it is used
func (o *ActiveDirectoryInlinePreferredDcsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ActiveDirectoryInlinePreferredDcsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ActiveDirectoryInlinePreferredDcsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryInlinePreferredDcsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ActiveDirectoryInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model active_directory_inline_svm
*/
type ActiveDirectoryInlineSvm struct {

	// links
	Links *models.ActiveDirectoryInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this active directory inline svm
func (o *ActiveDirectoryInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this active directory inline svm based on the context it is used
func (o *ActiveDirectoryInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ActiveDirectoryInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ActiveDirectoryInlineSvm) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ActiveDirectoryInlineSvmInlineLinks active directory inline svm inline links
swagger:model active_directory_inline_svm_inline__links
*/
type ActiveDirectoryInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this active directory inline svm inline links
func (o *ActiveDirectoryInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this active directory inline svm inline links based on the context it is used
func (o *ActiveDirectoryInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ActiveDirectoryInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ActiveDirectoryInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ActiveDirectoryInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
