// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ActiveDirectoryModifyReader is a Reader for the ActiveDirectoryModify structure.
type ActiveDirectoryModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ActiveDirectoryModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewActiveDirectoryModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewActiveDirectoryModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewActiveDirectoryModifyOK creates a ActiveDirectoryModifyOK with default headers values
func NewActiveDirectoryModifyOK() *ActiveDirectoryModifyOK {
	return &ActiveDirectoryModifyOK{}
}

/*
ActiveDirectoryModifyOK describes a response with status code 200, with default header values.

OK
*/
type ActiveDirectoryModifyOK struct {
	Payload *models.ActiveDirectory
}

// IsSuccess returns true when this active directory modify o k response has a 2xx status code
func (o *ActiveDirectoryModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this active directory modify o k response has a 3xx status code
func (o *ActiveDirectoryModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this active directory modify o k response has a 4xx status code
func (o *ActiveDirectoryModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this active directory modify o k response has a 5xx status code
func (o *ActiveDirectoryModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this active directory modify o k response a status code equal to that given
func (o *ActiveDirectoryModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the active directory modify o k response
func (o *ActiveDirectoryModifyOK) Code() int {
	return 200
}

func (o *ActiveDirectoryModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/active-directory/{svm.uuid}][%d] activeDirectoryModifyOK %s", 200, payload)
}

func (o *ActiveDirectoryModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/active-directory/{svm.uuid}][%d] activeDirectoryModifyOK %s", 200, payload)
}

func (o *ActiveDirectoryModifyOK) GetPayload() *models.ActiveDirectory {
	return o.Payload
}

func (o *ActiveDirectoryModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ActiveDirectory)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewActiveDirectoryModifyDefault creates a ActiveDirectoryModifyDefault with default headers values
func NewActiveDirectoryModifyDefault(code int) *ActiveDirectoryModifyDefault {
	return &ActiveDirectoryModifyDefault{
		_statusCode: code,
	}
}

/*
	ActiveDirectoryModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 656464 | Failed to modify the Active Directory machine account. Reason: Invalid Credentials. |
| 656465 | Failed to create the Active Directory machine account. Reason: An account with this name already exists. |
| 656466 | Failed to create the Active Directory machine account. Reason: Unable to connect to any domain controllers. |
| 656467 | Failed to modify the Active Directory machine account. Reason: Organizational-Unit not found. |
| 656478 | Failed to create the Active Directory machine account. Reason: KDC has no support for encryption type. |
| 656490 | Unable to modify the Active Directory account. The Active Directory account name is already used by another SVM. |
| 656495 | Failed to update Active Directory security settings for SVM. |
| 656496 | Failed to update Active Directory security settings for SVM. Reason: KDC has no support for encryption type. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ActiveDirectoryModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this active directory modify default response has a 2xx status code
func (o *ActiveDirectoryModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this active directory modify default response has a 3xx status code
func (o *ActiveDirectoryModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this active directory modify default response has a 4xx status code
func (o *ActiveDirectoryModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this active directory modify default response has a 5xx status code
func (o *ActiveDirectoryModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this active directory modify default response a status code equal to that given
func (o *ActiveDirectoryModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the active directory modify default response
func (o *ActiveDirectoryModifyDefault) Code() int {
	return o._statusCode
}

func (o *ActiveDirectoryModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/active-directory/{svm.uuid}][%d] active_directory_modify default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/active-directory/{svm.uuid}][%d] active_directory_modify default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ActiveDirectoryModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
