// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewActiveDirectoryPreferredDcCollectionGetParams creates a new ActiveDirectoryPreferredDcCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewActiveDirectoryPreferredDcCollectionGetParams() *ActiveDirectoryPreferredDcCollectionGetParams {
	return &ActiveDirectoryPreferredDcCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewActiveDirectoryPreferredDcCollectionGetParamsWithTimeout creates a new ActiveDirectoryPreferredDcCollectionGetParams object
// with the ability to set a timeout on a request.
func NewActiveDirectoryPreferredDcCollectionGetParamsWithTimeout(timeout time.Duration) *ActiveDirectoryPreferredDcCollectionGetParams {
	return &ActiveDirectoryPreferredDcCollectionGetParams{
		timeout: timeout,
	}
}

// NewActiveDirectoryPreferredDcCollectionGetParamsWithContext creates a new ActiveDirectoryPreferredDcCollectionGetParams object
// with the ability to set a context for a request.
func NewActiveDirectoryPreferredDcCollectionGetParamsWithContext(ctx context.Context) *ActiveDirectoryPreferredDcCollectionGetParams {
	return &ActiveDirectoryPreferredDcCollectionGetParams{
		Context: ctx,
	}
}

// NewActiveDirectoryPreferredDcCollectionGetParamsWithHTTPClient creates a new ActiveDirectoryPreferredDcCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewActiveDirectoryPreferredDcCollectionGetParamsWithHTTPClient(client *http.Client) *ActiveDirectoryPreferredDcCollectionGetParams {
	return &ActiveDirectoryPreferredDcCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ActiveDirectoryPreferredDcCollectionGetParams contains all the parameters to send to the API endpoint

	for the active directory preferred dc collection get operation.

	Typically these are written to a http.Request.
*/
type ActiveDirectoryPreferredDcCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Fqdn.

	   Filter by fqdn
	*/
	Fqdn *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ServerIP.

	   Filter by server_ip
	*/
	ServerIP *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the active directory preferred dc collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithDefaults() *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the active directory preferred dc collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ActiveDirectoryPreferredDcCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithTimeout(timeout time.Duration) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithContext(ctx context.Context) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithHTTPClient(client *http.Client) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithFields(fields []string) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFqdn adds the fqdn to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithFqdn(fqdn *string) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetFqdn(fqdn)
	return o
}

// SetFqdn adds the fqdn to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetFqdn(fqdn *string) {
	o.Fqdn = fqdn
}

// WithMaxRecords adds the maxRecords to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithMaxRecords(maxRecords *int64) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithOrderBy(orderBy []string) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithReturnRecords(returnRecords *bool) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithServerIP adds the serverIP to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithServerIP(serverIP *string) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetServerIP(serverIP)
	return o
}

// SetServerIP adds the serverIp to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetServerIP(serverIP *string) {
	o.ServerIP = serverIP
}

// WithSvmUUID adds the svmUUID to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WithSvmUUID(svmUUID string) *ActiveDirectoryPreferredDcCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the active directory preferred dc collection get params
func (o *ActiveDirectoryPreferredDcCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *ActiveDirectoryPreferredDcCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Fqdn != nil {

		// query param fqdn
		var qrFqdn string

		if o.Fqdn != nil {
			qrFqdn = *o.Fqdn
		}
		qFqdn := qrFqdn
		if qFqdn != "" {

			if err := r.SetQueryParam("fqdn", qFqdn); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ServerIP != nil {

		// query param server_ip
		var qrServerIP string

		if o.ServerIP != nil {
			qrServerIP = *o.ServerIP
		}
		qServerIP := qrServerIP
		if qServerIP != "" {

			if err := r.SetQueryParam("server_ip", qServerIP); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamActiveDirectoryPreferredDcCollectionGet binds the parameter fields
func (o *ActiveDirectoryPreferredDcCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamActiveDirectoryPreferredDcCollectionGet binds the parameter order_by
func (o *ActiveDirectoryPreferredDcCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
