// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ActiveDirectoryPreferredDcCreateReader is a Reader for the ActiveDirectoryPreferredDcCreate structure.
type ActiveDirectoryPreferredDcCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ActiveDirectoryPreferredDcCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewActiveDirectoryPreferredDcCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewActiveDirectoryPreferredDcCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewActiveDirectoryPreferredDcCreateCreated creates a ActiveDirectoryPreferredDcCreateCreated with default headers values
func NewActiveDirectoryPreferredDcCreateCreated() *ActiveDirectoryPreferredDcCreateCreated {
	return &ActiveDirectoryPreferredDcCreateCreated{}
}

/*
ActiveDirectoryPreferredDcCreateCreated describes a response with status code 201, with default header values.

Created
*/
type ActiveDirectoryPreferredDcCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.ActiveDirectoryPreferredDc
}

// IsSuccess returns true when this active directory preferred dc create created response has a 2xx status code
func (o *ActiveDirectoryPreferredDcCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this active directory preferred dc create created response has a 3xx status code
func (o *ActiveDirectoryPreferredDcCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this active directory preferred dc create created response has a 4xx status code
func (o *ActiveDirectoryPreferredDcCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this active directory preferred dc create created response has a 5xx status code
func (o *ActiveDirectoryPreferredDcCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this active directory preferred dc create created response a status code equal to that given
func (o *ActiveDirectoryPreferredDcCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the active directory preferred dc create created response
func (o *ActiveDirectoryPreferredDcCreateCreated) Code() int {
	return 201
}

func (o *ActiveDirectoryPreferredDcCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/active-directory/{svm.uuid}/preferred-domain-controllers][%d] activeDirectoryPreferredDcCreateCreated %s", 201, payload)
}

func (o *ActiveDirectoryPreferredDcCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/active-directory/{svm.uuid}/preferred-domain-controllers][%d] activeDirectoryPreferredDcCreateCreated %s", 201, payload)
}

func (o *ActiveDirectoryPreferredDcCreateCreated) GetPayload() *models.ActiveDirectoryPreferredDc {
	return o.Payload
}

func (o *ActiveDirectoryPreferredDcCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.ActiveDirectoryPreferredDc)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewActiveDirectoryPreferredDcCreateDefault creates a ActiveDirectoryPreferredDcCreateDefault with default headers values
func NewActiveDirectoryPreferredDcCreateDefault(code int) *ActiveDirectoryPreferredDcCreateDefault {
	return &ActiveDirectoryPreferredDcCreateDefault{
		_statusCode: code,
	}
}

/*
	ActiveDirectoryPreferredDcCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655366 | Invalid domain controller. |
| 655506 | Failed to add preferred-dc. |
| 655918 | The fully qualified domain name cannot be longer than 254 bytes. |
| 656407 | Failed to validate preferred-dc. |
| 656408 | RPC failure occurred during preferred-dc config validation. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ActiveDirectoryPreferredDcCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this active directory preferred dc create default response has a 2xx status code
func (o *ActiveDirectoryPreferredDcCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this active directory preferred dc create default response has a 3xx status code
func (o *ActiveDirectoryPreferredDcCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this active directory preferred dc create default response has a 4xx status code
func (o *ActiveDirectoryPreferredDcCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this active directory preferred dc create default response has a 5xx status code
func (o *ActiveDirectoryPreferredDcCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this active directory preferred dc create default response a status code equal to that given
func (o *ActiveDirectoryPreferredDcCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the active directory preferred dc create default response
func (o *ActiveDirectoryPreferredDcCreateDefault) Code() int {
	return o._statusCode
}

func (o *ActiveDirectoryPreferredDcCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/active-directory/{svm.uuid}/preferred-domain-controllers][%d] active_directory_preferred_dc_create default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryPreferredDcCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/active-directory/{svm.uuid}/preferred-domain-controllers][%d] active_directory_preferred_dc_create default %s", o._statusCode, payload)
}

func (o *ActiveDirectoryPreferredDcCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ActiveDirectoryPreferredDcCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
