// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AuditCollectionGetReader is a Reader for the AuditCollectionGet structure.
type AuditCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuditCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAuditCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAuditCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAuditCollectionGetOK creates a AuditCollectionGetOK with default headers values
func NewAuditCollectionGetOK() *AuditCollectionGetOK {
	return &AuditCollectionGetOK{}
}

/*
AuditCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type AuditCollectionGetOK struct {
	Payload *models.AuditResponse
}

// IsSuccess returns true when this audit collection get o k response has a 2xx status code
func (o *AuditCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit collection get o k response has a 3xx status code
func (o *AuditCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit collection get o k response has a 4xx status code
func (o *AuditCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit collection get o k response has a 5xx status code
func (o *AuditCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this audit collection get o k response a status code equal to that given
func (o *AuditCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the audit collection get o k response
func (o *AuditCollectionGetOK) Code() int {
	return 200
}

func (o *AuditCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/audit][%d] auditCollectionGetOK %s", 200, payload)
}

func (o *AuditCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/audit][%d] auditCollectionGetOK %s", 200, payload)
}

func (o *AuditCollectionGetOK) GetPayload() *models.AuditResponse {
	return o.Payload
}

func (o *AuditCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AuditResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditCollectionGetDefault creates a AuditCollectionGetDefault with default headers values
func NewAuditCollectionGetDefault(code int) *AuditCollectionGetDefault {
	return &AuditCollectionGetDefault{
		_statusCode: code,
	}
}

/*
AuditCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type AuditCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this audit collection get default response has a 2xx status code
func (o *AuditCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this audit collection get default response has a 3xx status code
func (o *AuditCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this audit collection get default response has a 4xx status code
func (o *AuditCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this audit collection get default response has a 5xx status code
func (o *AuditCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this audit collection get default response a status code equal to that given
func (o *AuditCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the audit collection get default response
func (o *AuditCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *AuditCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/audit][%d] audit_collection_get default %s", o._statusCode, payload)
}

func (o *AuditCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/audit][%d] audit_collection_get default %s", o._statusCode, payload)
}

func (o *AuditCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AuditCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
