// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AuditCreateReader is a Reader for the AuditCreate structure.
type AuditCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuditCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewAuditCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAuditCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAuditCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAuditCreateCreated creates a AuditCreateCreated with default headers values
func NewAuditCreateCreated() *AuditCreateCreated {
	return &AuditCreateCreated{}
}

/*
AuditCreateCreated describes a response with status code 201, with default header values.

Created
*/
type AuditCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.AuditJobLinkResponse
}

// IsSuccess returns true when this audit create created response has a 2xx status code
func (o *AuditCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit create created response has a 3xx status code
func (o *AuditCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit create created response has a 4xx status code
func (o *AuditCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit create created response has a 5xx status code
func (o *AuditCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this audit create created response a status code equal to that given
func (o *AuditCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the audit create created response
func (o *AuditCreateCreated) Code() int {
	return 201
}

func (o *AuditCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit][%d] auditCreateCreated %s", 201, payload)
}

func (o *AuditCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit][%d] auditCreateCreated %s", 201, payload)
}

func (o *AuditCreateCreated) GetPayload() *models.AuditJobLinkResponse {
	return o.Payload
}

func (o *AuditCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditCreateAccepted creates a AuditCreateAccepted with default headers values
func NewAuditCreateAccepted() *AuditCreateAccepted {
	return &AuditCreateAccepted{}
}

/*
AuditCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AuditCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.AuditJobLinkResponse
}

// IsSuccess returns true when this audit create accepted response has a 2xx status code
func (o *AuditCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit create accepted response has a 3xx status code
func (o *AuditCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit create accepted response has a 4xx status code
func (o *AuditCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit create accepted response has a 5xx status code
func (o *AuditCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this audit create accepted response a status code equal to that given
func (o *AuditCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the audit create accepted response
func (o *AuditCreateAccepted) Code() int {
	return 202
}

func (o *AuditCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit][%d] auditCreateAccepted %s", 202, payload)
}

func (o *AuditCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit][%d] auditCreateAccepted %s", 202, payload)
}

func (o *AuditCreateAccepted) GetPayload() *models.AuditJobLinkResponse {
	return o.Payload
}

func (o *AuditCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditCreateDefault creates a AuditCreateDefault with default headers values
func NewAuditCreateDefault(code int) *AuditCreateDefault {
	return &AuditCreateDefault{
		_statusCode: code,
	}
}

/*
	AuditCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262186     | Field "log.retention.duration" cannot be used with field "log.retention.count"         |
| 262196     | Log_rotation_now is not an allowed operation                                           |
| 2621462    | The specified SVM does not exist                                                       |
| 9699330    | An audit configuration already exists                                                  |
| 9699337    | Audit system internal update is in progress, audit configuration create failed         |
| 9699340    | SVM UUID lookup failed                                                                 |
| 9699358    | Audit configuration is absent for enabling                                             |
| 9699359    | Audit configuration is already enabled                                                 |
| 9699360    | Final consolidation is in progress, audit enable failed                                |
| 9699365    | Enabling of audit configuration failed                                                 |
| 9699370    | Auditing was successfully configured, however audit configuration could not be enabled |
| 9699384    | The specified log_path does not exist                                                  |
| 9699385    | The log_path must be a directory                                                       |
| 9699386    | The log_path must be a canonical path in the SVMs namespace                            |
| 9699387    | The log_path cannot be empty                                                           |
| 9699388    | Rotate size must be greater than or equal to 1024 KB                                   |
| 9699389    | The log_path must not contain a symbolic link                                          |
| 9699398    | The log_path exceeds a maximum supported length of characters                          |
| 9699399    | The log_path contains an unsupported read-only (DP/LS) volume                          |
| 9699400    | The specified log_path is not a valid destination for SVM                              |
| 9699402    | The log_path contains an unsupported snaplock volume                                   |
| 9699403    | The log_path cannot be accessed for validation                                         |
| 9699406    | The log_path validation failed                                                         |
| 9699409    | Failed to enable multiproto.audit.evtxlog.support support capability                   |
| 9699428    | All nodes need to run ONTAP 8.3.0 release to audit CIFS logon-logoff events            |
| 9699429    | Failed to enable multiproto.audit.cifslogonlogoff.support support capability           |
| 9699431    | All nodes need to run ONTAP 8.3.0 release to audit CAP staging events                  |
| 9699432    | Failed to enable multiproto.audit.capstaging.support support capability                |
*/
type AuditCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this audit create default response has a 2xx status code
func (o *AuditCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this audit create default response has a 3xx status code
func (o *AuditCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this audit create default response has a 4xx status code
func (o *AuditCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this audit create default response has a 5xx status code
func (o *AuditCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this audit create default response a status code equal to that given
func (o *AuditCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the audit create default response
func (o *AuditCreateDefault) Code() int {
	return o._statusCode
}

func (o *AuditCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit][%d] audit_create default %s", o._statusCode, payload)
}

func (o *AuditCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit][%d] audit_create default %s", o._statusCode, payload)
}

func (o *AuditCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AuditCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
