// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AuditDeleteCollectionReader is a Reader for the AuditDeleteCollection structure.
type AuditDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuditDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAuditDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAuditDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAuditDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAuditDeleteCollectionOK creates a AuditDeleteCollectionOK with default headers values
func NewAuditDeleteCollectionOK() *AuditDeleteCollectionOK {
	return &AuditDeleteCollectionOK{}
}

/*
AuditDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type AuditDeleteCollectionOK struct {
	Payload *models.AuditJobLinkResponse
}

// IsSuccess returns true when this audit delete collection o k response has a 2xx status code
func (o *AuditDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit delete collection o k response has a 3xx status code
func (o *AuditDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit delete collection o k response has a 4xx status code
func (o *AuditDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit delete collection o k response has a 5xx status code
func (o *AuditDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this audit delete collection o k response a status code equal to that given
func (o *AuditDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the audit delete collection o k response
func (o *AuditDeleteCollectionOK) Code() int {
	return 200
}

func (o *AuditDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit][%d] auditDeleteCollectionOK %s", 200, payload)
}

func (o *AuditDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit][%d] auditDeleteCollectionOK %s", 200, payload)
}

func (o *AuditDeleteCollectionOK) GetPayload() *models.AuditJobLinkResponse {
	return o.Payload
}

func (o *AuditDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditDeleteCollectionAccepted creates a AuditDeleteCollectionAccepted with default headers values
func NewAuditDeleteCollectionAccepted() *AuditDeleteCollectionAccepted {
	return &AuditDeleteCollectionAccepted{}
}

/*
AuditDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AuditDeleteCollectionAccepted struct {
	Payload *models.AuditJobLinkResponse
}

// IsSuccess returns true when this audit delete collection accepted response has a 2xx status code
func (o *AuditDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit delete collection accepted response has a 3xx status code
func (o *AuditDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit delete collection accepted response has a 4xx status code
func (o *AuditDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit delete collection accepted response has a 5xx status code
func (o *AuditDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this audit delete collection accepted response a status code equal to that given
func (o *AuditDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the audit delete collection accepted response
func (o *AuditDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *AuditDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit][%d] auditDeleteCollectionAccepted %s", 202, payload)
}

func (o *AuditDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit][%d] auditDeleteCollectionAccepted %s", 202, payload)
}

func (o *AuditDeleteCollectionAccepted) GetPayload() *models.AuditJobLinkResponse {
	return o.Payload
}

func (o *AuditDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditDeleteCollectionDefault creates a AuditDeleteCollectionDefault with default headers values
func NewAuditDeleteCollectionDefault(code int) *AuditDeleteCollectionDefault {
	return &AuditDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	AuditDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9699349    | Auditing should be disabled before deleting the audit configuration           |
| 9699350    | Audit configuration cannot be deleted, final consolidation is in progress     |
| 9699410    | Failed to disable multiproto.audit.evtxlog.support support capability         |
| 9699430    | Failed to disable multiproto.audit.cifslogonlogoff.support support capability |
| 9699433    | Failed to disable multiproto.audit.capstaging.support support capability      |
*/
type AuditDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this audit delete collection default response has a 2xx status code
func (o *AuditDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this audit delete collection default response has a 3xx status code
func (o *AuditDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this audit delete collection default response has a 4xx status code
func (o *AuditDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this audit delete collection default response has a 5xx status code
func (o *AuditDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this audit delete collection default response a status code equal to that given
func (o *AuditDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the audit delete collection default response
func (o *AuditDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *AuditDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit][%d] audit_delete_collection default %s", o._statusCode, payload)
}

func (o *AuditDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit][%d] audit_delete_collection default %s", o._statusCode, payload)
}

func (o *AuditDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AuditDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AuditDeleteCollectionBody audit delete collection body
swagger:model AuditDeleteCollectionBody
*/
type AuditDeleteCollectionBody struct {

	// audit response inline records
	AuditResponseInlineRecords []*models.Audit `json:"records,omitempty"`
}

// Validate validates this audit delete collection body
func (o *AuditDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAuditResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AuditDeleteCollectionBody) validateAuditResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.AuditResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.AuditResponseInlineRecords); i++ {
		if swag.IsZero(o.AuditResponseInlineRecords[i]) { // not required
			continue
		}

		if o.AuditResponseInlineRecords[i] != nil {
			if err := o.AuditResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this audit delete collection body based on the context it is used
func (o *AuditDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAuditResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AuditDeleteCollectionBody) contextValidateAuditResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AuditResponseInlineRecords); i++ {

		if o.AuditResponseInlineRecords[i] != nil {
			if err := o.AuditResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *AuditDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AuditDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res AuditDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
