// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AuditDeleteReader is a Reader for the AuditDelete structure.
type AuditDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuditDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAuditDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAuditDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAuditDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAuditDeleteOK creates a AuditDeleteOK with default headers values
func NewAuditDeleteOK() *AuditDeleteOK {
	return &AuditDeleteOK{}
}

/*
AuditDeleteOK describes a response with status code 200, with default header values.

OK
*/
type AuditDeleteOK struct {
	Payload *models.AuditJobLinkResponse
}

// IsSuccess returns true when this audit delete o k response has a 2xx status code
func (o *AuditDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit delete o k response has a 3xx status code
func (o *AuditDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit delete o k response has a 4xx status code
func (o *AuditDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit delete o k response has a 5xx status code
func (o *AuditDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this audit delete o k response a status code equal to that given
func (o *AuditDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the audit delete o k response
func (o *AuditDeleteOK) Code() int {
	return 200
}

func (o *AuditDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}][%d] auditDeleteOK %s", 200, payload)
}

func (o *AuditDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}][%d] auditDeleteOK %s", 200, payload)
}

func (o *AuditDeleteOK) GetPayload() *models.AuditJobLinkResponse {
	return o.Payload
}

func (o *AuditDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditDeleteAccepted creates a AuditDeleteAccepted with default headers values
func NewAuditDeleteAccepted() *AuditDeleteAccepted {
	return &AuditDeleteAccepted{}
}

/*
AuditDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AuditDeleteAccepted struct {
	Payload *models.AuditJobLinkResponse
}

// IsSuccess returns true when this audit delete accepted response has a 2xx status code
func (o *AuditDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit delete accepted response has a 3xx status code
func (o *AuditDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit delete accepted response has a 4xx status code
func (o *AuditDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit delete accepted response has a 5xx status code
func (o *AuditDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this audit delete accepted response a status code equal to that given
func (o *AuditDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the audit delete accepted response
func (o *AuditDeleteAccepted) Code() int {
	return 202
}

func (o *AuditDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}][%d] auditDeleteAccepted %s", 202, payload)
}

func (o *AuditDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}][%d] auditDeleteAccepted %s", 202, payload)
}

func (o *AuditDeleteAccepted) GetPayload() *models.AuditJobLinkResponse {
	return o.Payload
}

func (o *AuditDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditDeleteDefault creates a AuditDeleteDefault with default headers values
func NewAuditDeleteDefault(code int) *AuditDeleteDefault {
	return &AuditDeleteDefault{
		_statusCode: code,
	}
}

/*
	AuditDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9699349    | Auditing should be disabled before deleting the audit configuration           |
| 9699350    | Audit configuration cannot be deleted, final consolidation is in progress     |
| 9699410    | Failed to disable multiproto.audit.evtxlog.support support capability         |
| 9699430    | Failed to disable multiproto.audit.cifslogonlogoff.support support capability |
| 9699433    | Failed to disable multiproto.audit.capstaging.support support capability      |
*/
type AuditDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this audit delete default response has a 2xx status code
func (o *AuditDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this audit delete default response has a 3xx status code
func (o *AuditDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this audit delete default response has a 4xx status code
func (o *AuditDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this audit delete default response has a 5xx status code
func (o *AuditDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this audit delete default response a status code equal to that given
func (o *AuditDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the audit delete default response
func (o *AuditDeleteDefault) Code() int {
	return o._statusCode
}

func (o *AuditDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}][%d] audit_delete default %s", o._statusCode, payload)
}

func (o *AuditDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}][%d] audit_delete default %s", o._statusCode, payload)
}

func (o *AuditDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AuditDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
