// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsConnectionCollectionGetParams creates a new CifsConnectionCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsConnectionCollectionGetParams() *CifsConnectionCollectionGetParams {
	return &CifsConnectionCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsConnectionCollectionGetParamsWithTimeout creates a new CifsConnectionCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCifsConnectionCollectionGetParamsWithTimeout(timeout time.Duration) *CifsConnectionCollectionGetParams {
	return &CifsConnectionCollectionGetParams{
		timeout: timeout,
	}
}

// NewCifsConnectionCollectionGetParamsWithContext creates a new CifsConnectionCollectionGetParams object
// with the ability to set a context for a request.
func NewCifsConnectionCollectionGetParamsWithContext(ctx context.Context) *CifsConnectionCollectionGetParams {
	return &CifsConnectionCollectionGetParams{
		Context: ctx,
	}
}

// NewCifsConnectionCollectionGetParamsWithHTTPClient creates a new CifsConnectionCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsConnectionCollectionGetParamsWithHTTPClient(client *http.Client) *CifsConnectionCollectionGetParams {
	return &CifsConnectionCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CifsConnectionCollectionGetParams contains all the parameters to send to the API endpoint

	for the cifs connection collection get operation.

	Typically these are written to a http.Request.
*/
type CifsConnectionCollectionGetParams struct {

	/* ClientIP.

	   Filter by client_ip
	*/
	ClientIP *string

	/* ClientPort.

	   Filter by client_port
	*/
	ClientPort *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Identifier.

	   Filter by identifier
	*/
	Identifier *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NetworkContextID.

	   Filter by network_context_id
	*/
	NetworkContextID *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ServerIP.

	   Filter by server_ip
	*/
	ServerIP *string

	/* SessionsIdentifier.

	   Filter by sessions.identifier
	*/
	SessionsIdentifier *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs connection collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsConnectionCollectionGetParams) WithDefaults() *CifsConnectionCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs connection collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsConnectionCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CifsConnectionCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithTimeout(timeout time.Duration) *CifsConnectionCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithContext(ctx context.Context) *CifsConnectionCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithHTTPClient(client *http.Client) *CifsConnectionCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClientIP adds the clientIP to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithClientIP(clientIP *string) *CifsConnectionCollectionGetParams {
	o.SetClientIP(clientIP)
	return o
}

// SetClientIP adds the clientIp to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetClientIP(clientIP *string) {
	o.ClientIP = clientIP
}

// WithClientPort adds the clientPort to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithClientPort(clientPort *int64) *CifsConnectionCollectionGetParams {
	o.SetClientPort(clientPort)
	return o
}

// SetClientPort adds the clientPort to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetClientPort(clientPort *int64) {
	o.ClientPort = clientPort
}

// WithFields adds the fields to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithFields(fields []string) *CifsConnectionCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIdentifier adds the identifier to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithIdentifier(identifier *int64) *CifsConnectionCollectionGetParams {
	o.SetIdentifier(identifier)
	return o
}

// SetIdentifier adds the identifier to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetIdentifier(identifier *int64) {
	o.Identifier = identifier
}

// WithMaxRecords adds the maxRecords to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithMaxRecords(maxRecords *int64) *CifsConnectionCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNetworkContextID adds the networkContextID to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithNetworkContextID(networkContextID *int64) *CifsConnectionCollectionGetParams {
	o.SetNetworkContextID(networkContextID)
	return o
}

// SetNetworkContextID adds the networkContextId to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetNetworkContextID(networkContextID *int64) {
	o.NetworkContextID = networkContextID
}

// WithNodeName adds the nodeName to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithNodeName(nodeName *string) *CifsConnectionCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithNodeUUID(nodeUUID *string) *CifsConnectionCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithOrderBy(orderBy []string) *CifsConnectionCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithReturnRecords(returnRecords *bool) *CifsConnectionCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CifsConnectionCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithServerIP adds the serverIP to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithServerIP(serverIP *string) *CifsConnectionCollectionGetParams {
	o.SetServerIP(serverIP)
	return o
}

// SetServerIP adds the serverIp to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetServerIP(serverIP *string) {
	o.ServerIP = serverIP
}

// WithSessionsIdentifier adds the sessionsIdentifier to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithSessionsIdentifier(sessionsIdentifier *int64) *CifsConnectionCollectionGetParams {
	o.SetSessionsIdentifier(sessionsIdentifier)
	return o
}

// SetSessionsIdentifier adds the sessionsIdentifier to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetSessionsIdentifier(sessionsIdentifier *int64) {
	o.SessionsIdentifier = sessionsIdentifier
}

// WithSvmName adds the svmName to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithSvmName(svmName *string) *CifsConnectionCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) WithSvmUUID(svmUUID *string) *CifsConnectionCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs connection collection get params
func (o *CifsConnectionCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsConnectionCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClientIP != nil {

		// query param client_ip
		var qrClientIP string

		if o.ClientIP != nil {
			qrClientIP = *o.ClientIP
		}
		qClientIP := qrClientIP
		if qClientIP != "" {

			if err := r.SetQueryParam("client_ip", qClientIP); err != nil {
				return err
			}
		}
	}

	if o.ClientPort != nil {

		// query param client_port
		var qrClientPort int64

		if o.ClientPort != nil {
			qrClientPort = *o.ClientPort
		}
		qClientPort := swag.FormatInt64(qrClientPort)
		if qClientPort != "" {

			if err := r.SetQueryParam("client_port", qClientPort); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Identifier != nil {

		// query param identifier
		var qrIdentifier int64

		if o.Identifier != nil {
			qrIdentifier = *o.Identifier
		}
		qIdentifier := swag.FormatInt64(qrIdentifier)
		if qIdentifier != "" {

			if err := r.SetQueryParam("identifier", qIdentifier); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NetworkContextID != nil {

		// query param network_context_id
		var qrNetworkContextID int64

		if o.NetworkContextID != nil {
			qrNetworkContextID = *o.NetworkContextID
		}
		qNetworkContextID := swag.FormatInt64(qrNetworkContextID)
		if qNetworkContextID != "" {

			if err := r.SetQueryParam("network_context_id", qNetworkContextID); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ServerIP != nil {

		// query param server_ip
		var qrServerIP string

		if o.ServerIP != nil {
			qrServerIP = *o.ServerIP
		}
		qServerIP := qrServerIP
		if qServerIP != "" {

			if err := r.SetQueryParam("server_ip", qServerIP); err != nil {
				return err
			}
		}
	}

	if o.SessionsIdentifier != nil {

		// query param sessions.identifier
		var qrSessionsIdentifier int64

		if o.SessionsIdentifier != nil {
			qrSessionsIdentifier = *o.SessionsIdentifier
		}
		qSessionsIdentifier := swag.FormatInt64(qrSessionsIdentifier)
		if qSessionsIdentifier != "" {

			if err := r.SetQueryParam("sessions.identifier", qSessionsIdentifier); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCifsConnectionCollectionGet binds the parameter fields
func (o *CifsConnectionCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCifsConnectionCollectionGet binds the parameter order_by
func (o *CifsConnectionCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
