// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsConnectionCollectionGetReader is a Reader for the CifsConnectionCollectionGet structure.
type CifsConnectionCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsConnectionCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsConnectionCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsConnectionCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsConnectionCollectionGetOK creates a CifsConnectionCollectionGetOK with default headers values
func NewCifsConnectionCollectionGetOK() *CifsConnectionCollectionGetOK {
	return &CifsConnectionCollectionGetOK{}
}

/*
CifsConnectionCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type CifsConnectionCollectionGetOK struct {
	Payload *models.CifsConnectionResponse
}

// IsSuccess returns true when this cifs connection collection get o k response has a 2xx status code
func (o *CifsConnectionCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs connection collection get o k response has a 3xx status code
func (o *CifsConnectionCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs connection collection get o k response has a 4xx status code
func (o *CifsConnectionCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs connection collection get o k response has a 5xx status code
func (o *CifsConnectionCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs connection collection get o k response a status code equal to that given
func (o *CifsConnectionCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs connection collection get o k response
func (o *CifsConnectionCollectionGetOK) Code() int {
	return 200
}

func (o *CifsConnectionCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/connections][%d] cifsConnectionCollectionGetOK %s", 200, payload)
}

func (o *CifsConnectionCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/connections][%d] cifsConnectionCollectionGetOK %s", 200, payload)
}

func (o *CifsConnectionCollectionGetOK) GetPayload() *models.CifsConnectionResponse {
	return o.Payload
}

func (o *CifsConnectionCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CifsConnectionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCifsConnectionCollectionGetDefault creates a CifsConnectionCollectionGetDefault with default headers values
func NewCifsConnectionCollectionGetDefault(code int) *CifsConnectionCollectionGetDefault {
	return &CifsConnectionCollectionGetDefault{
		_statusCode: code,
	}
}

/*
CifsConnectionCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type CifsConnectionCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs connection collection get default response has a 2xx status code
func (o *CifsConnectionCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs connection collection get default response has a 3xx status code
func (o *CifsConnectionCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs connection collection get default response has a 4xx status code
func (o *CifsConnectionCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs connection collection get default response has a 5xx status code
func (o *CifsConnectionCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs connection collection get default response a status code equal to that given
func (o *CifsConnectionCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs connection collection get default response
func (o *CifsConnectionCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *CifsConnectionCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/connections][%d] cifs_connection_collection_get default %s", o._statusCode, payload)
}

func (o *CifsConnectionCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/connections][%d] cifs_connection_collection_get default %s", o._statusCode, payload)
}

func (o *CifsConnectionCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsConnectionCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
