// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsDomainCollectionGetParams creates a new CifsDomainCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsDomainCollectionGetParams() *CifsDomainCollectionGetParams {
	return &CifsDomainCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsDomainCollectionGetParamsWithTimeout creates a new CifsDomainCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCifsDomainCollectionGetParamsWithTimeout(timeout time.Duration) *CifsDomainCollectionGetParams {
	return &CifsDomainCollectionGetParams{
		timeout: timeout,
	}
}

// NewCifsDomainCollectionGetParamsWithContext creates a new CifsDomainCollectionGetParams object
// with the ability to set a context for a request.
func NewCifsDomainCollectionGetParamsWithContext(ctx context.Context) *CifsDomainCollectionGetParams {
	return &CifsDomainCollectionGetParams{
		Context: ctx,
	}
}

// NewCifsDomainCollectionGetParamsWithHTTPClient creates a new CifsDomainCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsDomainCollectionGetParamsWithHTTPClient(client *http.Client) *CifsDomainCollectionGetParams {
	return &CifsDomainCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CifsDomainCollectionGetParams contains all the parameters to send to the API endpoint

	for the cifs domain collection get operation.

	Typically these are written to a http.Request.
*/
type CifsDomainCollectionGetParams struct {

	/* ClientID.

	   Filter by client_id
	*/
	ClientID *string

	/* DiscoveredServersDomain.

	   Filter by discovered_servers.domain
	*/
	DiscoveredServersDomain *string

	/* DiscoveredServersNodeName.

	   Filter by discovered_servers.node.name
	*/
	DiscoveredServersNodeName *string

	/* DiscoveredServersNodeUUID.

	   Filter by discovered_servers.node.uuid
	*/
	DiscoveredServersNodeUUID *string

	/* DiscoveredServersPreference.

	   Filter by discovered_servers.preference
	*/
	DiscoveredServersPreference *string

	/* DiscoveredServersServerIP.

	   Filter by discovered_servers.server_ip
	*/
	DiscoveredServersServerIP *string

	/* DiscoveredServersServerName.

	   Filter by discovered_servers.server_name
	*/
	DiscoveredServersServerName *string

	/* DiscoveredServersServerType.

	   Filter by discovered_servers.server_type
	*/
	DiscoveredServersServerType *string

	/* DiscoveredServersState.

	   Filter by discovered_servers.state
	*/
	DiscoveredServersState *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NameMappingTrustedDomains.

	   Filter by name_mapping.trusted_domains
	*/
	NameMappingTrustedDomains *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PasswordScheduleScheduleDescription.

	   Filter by password_schedule.schedule_description
	*/
	PasswordScheduleScheduleDescription *string

	/* PasswordScheduleScheduleEnabled.

	   Filter by password_schedule.schedule_enabled
	*/
	PasswordScheduleScheduleEnabled *bool

	/* PasswordScheduleScheduleLastChangedTime.

	   Filter by password_schedule.schedule_last_changed_time
	*/
	PasswordScheduleScheduleLastChangedTime *string

	/* PasswordScheduleScheduleRandomizedMinute.

	   Filter by password_schedule.schedule_randomized_minute
	*/
	PasswordScheduleScheduleRandomizedMinute *int64

	/* PasswordScheduleScheduleWarnMessage.

	   Filter by password_schedule.schedule_warn_message
	*/
	PasswordScheduleScheduleWarnMessage *string

	/* PasswordScheduleScheduleWeeklyInterval.

	   Filter by password_schedule.schedule_weekly_interval
	*/
	PasswordScheduleScheduleWeeklyInterval *int64

	/* PreferredDcsFqdn.

	   Filter by preferred_dcs.fqdn
	*/
	PreferredDcsFqdn *string

	/* PreferredDcsServerIP.

	   Filter by preferred_dcs.server_ip
	*/
	PreferredDcsServerIP *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ServerDiscoveryMode.

	   Filter by server_discovery_mode
	*/
	ServerDiscoveryMode *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TenantID.

	   Filter by tenant_id
	*/
	TenantID *string

	/* TrustRelationshipsHomeDomain.

	   Filter by trust_relationships.home_domain
	*/
	TrustRelationshipsHomeDomain *string

	/* TrustRelationshipsNodeName.

	   Filter by trust_relationships.node.name
	*/
	TrustRelationshipsNodeName *string

	/* TrustRelationshipsNodeUUID.

	   Filter by trust_relationships.node.uuid
	*/
	TrustRelationshipsNodeUUID *string

	/* TrustRelationshipsTrustedDomains.

	   Filter by trust_relationships.trusted_domains
	*/
	TrustRelationshipsTrustedDomains *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs domain collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsDomainCollectionGetParams) WithDefaults() *CifsDomainCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs domain collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsDomainCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CifsDomainCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithTimeout(timeout time.Duration) *CifsDomainCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithContext(ctx context.Context) *CifsDomainCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithHTTPClient(client *http.Client) *CifsDomainCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClientID adds the clientID to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithClientID(clientID *string) *CifsDomainCollectionGetParams {
	o.SetClientID(clientID)
	return o
}

// SetClientID adds the clientId to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetClientID(clientID *string) {
	o.ClientID = clientID
}

// WithDiscoveredServersDomain adds the discoveredServersDomain to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithDiscoveredServersDomain(discoveredServersDomain *string) *CifsDomainCollectionGetParams {
	o.SetDiscoveredServersDomain(discoveredServersDomain)
	return o
}

// SetDiscoveredServersDomain adds the discoveredServersDomain to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetDiscoveredServersDomain(discoveredServersDomain *string) {
	o.DiscoveredServersDomain = discoveredServersDomain
}

// WithDiscoveredServersNodeName adds the discoveredServersNodeName to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithDiscoveredServersNodeName(discoveredServersNodeName *string) *CifsDomainCollectionGetParams {
	o.SetDiscoveredServersNodeName(discoveredServersNodeName)
	return o
}

// SetDiscoveredServersNodeName adds the discoveredServersNodeName to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetDiscoveredServersNodeName(discoveredServersNodeName *string) {
	o.DiscoveredServersNodeName = discoveredServersNodeName
}

// WithDiscoveredServersNodeUUID adds the discoveredServersNodeUUID to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithDiscoveredServersNodeUUID(discoveredServersNodeUUID *string) *CifsDomainCollectionGetParams {
	o.SetDiscoveredServersNodeUUID(discoveredServersNodeUUID)
	return o
}

// SetDiscoveredServersNodeUUID adds the discoveredServersNodeUuid to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetDiscoveredServersNodeUUID(discoveredServersNodeUUID *string) {
	o.DiscoveredServersNodeUUID = discoveredServersNodeUUID
}

// WithDiscoveredServersPreference adds the discoveredServersPreference to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithDiscoveredServersPreference(discoveredServersPreference *string) *CifsDomainCollectionGetParams {
	o.SetDiscoveredServersPreference(discoveredServersPreference)
	return o
}

// SetDiscoveredServersPreference adds the discoveredServersPreference to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetDiscoveredServersPreference(discoveredServersPreference *string) {
	o.DiscoveredServersPreference = discoveredServersPreference
}

// WithDiscoveredServersServerIP adds the discoveredServersServerIP to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithDiscoveredServersServerIP(discoveredServersServerIP *string) *CifsDomainCollectionGetParams {
	o.SetDiscoveredServersServerIP(discoveredServersServerIP)
	return o
}

// SetDiscoveredServersServerIP adds the discoveredServersServerIp to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetDiscoveredServersServerIP(discoveredServersServerIP *string) {
	o.DiscoveredServersServerIP = discoveredServersServerIP
}

// WithDiscoveredServersServerName adds the discoveredServersServerName to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithDiscoveredServersServerName(discoveredServersServerName *string) *CifsDomainCollectionGetParams {
	o.SetDiscoveredServersServerName(discoveredServersServerName)
	return o
}

// SetDiscoveredServersServerName adds the discoveredServersServerName to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetDiscoveredServersServerName(discoveredServersServerName *string) {
	o.DiscoveredServersServerName = discoveredServersServerName
}

// WithDiscoveredServersServerType adds the discoveredServersServerType to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithDiscoveredServersServerType(discoveredServersServerType *string) *CifsDomainCollectionGetParams {
	o.SetDiscoveredServersServerType(discoveredServersServerType)
	return o
}

// SetDiscoveredServersServerType adds the discoveredServersServerType to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetDiscoveredServersServerType(discoveredServersServerType *string) {
	o.DiscoveredServersServerType = discoveredServersServerType
}

// WithDiscoveredServersState adds the discoveredServersState to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithDiscoveredServersState(discoveredServersState *string) *CifsDomainCollectionGetParams {
	o.SetDiscoveredServersState(discoveredServersState)
	return o
}

// SetDiscoveredServersState adds the discoveredServersState to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetDiscoveredServersState(discoveredServersState *string) {
	o.DiscoveredServersState = discoveredServersState
}

// WithFields adds the fields to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithFields(fields []string) *CifsDomainCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithMaxRecords(maxRecords *int64) *CifsDomainCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNameMappingTrustedDomains adds the nameMappingTrustedDomains to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithNameMappingTrustedDomains(nameMappingTrustedDomains *string) *CifsDomainCollectionGetParams {
	o.SetNameMappingTrustedDomains(nameMappingTrustedDomains)
	return o
}

// SetNameMappingTrustedDomains adds the nameMappingTrustedDomains to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetNameMappingTrustedDomains(nameMappingTrustedDomains *string) {
	o.NameMappingTrustedDomains = nameMappingTrustedDomains
}

// WithOrderBy adds the orderBy to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithOrderBy(orderBy []string) *CifsDomainCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPasswordScheduleScheduleDescription adds the passwordScheduleScheduleDescription to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithPasswordScheduleScheduleDescription(passwordScheduleScheduleDescription *string) *CifsDomainCollectionGetParams {
	o.SetPasswordScheduleScheduleDescription(passwordScheduleScheduleDescription)
	return o
}

// SetPasswordScheduleScheduleDescription adds the passwordScheduleScheduleDescription to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetPasswordScheduleScheduleDescription(passwordScheduleScheduleDescription *string) {
	o.PasswordScheduleScheduleDescription = passwordScheduleScheduleDescription
}

// WithPasswordScheduleScheduleEnabled adds the passwordScheduleScheduleEnabled to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithPasswordScheduleScheduleEnabled(passwordScheduleScheduleEnabled *bool) *CifsDomainCollectionGetParams {
	o.SetPasswordScheduleScheduleEnabled(passwordScheduleScheduleEnabled)
	return o
}

// SetPasswordScheduleScheduleEnabled adds the passwordScheduleScheduleEnabled to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetPasswordScheduleScheduleEnabled(passwordScheduleScheduleEnabled *bool) {
	o.PasswordScheduleScheduleEnabled = passwordScheduleScheduleEnabled
}

// WithPasswordScheduleScheduleLastChangedTime adds the passwordScheduleScheduleLastChangedTime to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithPasswordScheduleScheduleLastChangedTime(passwordScheduleScheduleLastChangedTime *string) *CifsDomainCollectionGetParams {
	o.SetPasswordScheduleScheduleLastChangedTime(passwordScheduleScheduleLastChangedTime)
	return o
}

// SetPasswordScheduleScheduleLastChangedTime adds the passwordScheduleScheduleLastChangedTime to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetPasswordScheduleScheduleLastChangedTime(passwordScheduleScheduleLastChangedTime *string) {
	o.PasswordScheduleScheduleLastChangedTime = passwordScheduleScheduleLastChangedTime
}

// WithPasswordScheduleScheduleRandomizedMinute adds the passwordScheduleScheduleRandomizedMinute to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithPasswordScheduleScheduleRandomizedMinute(passwordScheduleScheduleRandomizedMinute *int64) *CifsDomainCollectionGetParams {
	o.SetPasswordScheduleScheduleRandomizedMinute(passwordScheduleScheduleRandomizedMinute)
	return o
}

// SetPasswordScheduleScheduleRandomizedMinute adds the passwordScheduleScheduleRandomizedMinute to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetPasswordScheduleScheduleRandomizedMinute(passwordScheduleScheduleRandomizedMinute *int64) {
	o.PasswordScheduleScheduleRandomizedMinute = passwordScheduleScheduleRandomizedMinute
}

// WithPasswordScheduleScheduleWarnMessage adds the passwordScheduleScheduleWarnMessage to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithPasswordScheduleScheduleWarnMessage(passwordScheduleScheduleWarnMessage *string) *CifsDomainCollectionGetParams {
	o.SetPasswordScheduleScheduleWarnMessage(passwordScheduleScheduleWarnMessage)
	return o
}

// SetPasswordScheduleScheduleWarnMessage adds the passwordScheduleScheduleWarnMessage to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetPasswordScheduleScheduleWarnMessage(passwordScheduleScheduleWarnMessage *string) {
	o.PasswordScheduleScheduleWarnMessage = passwordScheduleScheduleWarnMessage
}

// WithPasswordScheduleScheduleWeeklyInterval adds the passwordScheduleScheduleWeeklyInterval to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithPasswordScheduleScheduleWeeklyInterval(passwordScheduleScheduleWeeklyInterval *int64) *CifsDomainCollectionGetParams {
	o.SetPasswordScheduleScheduleWeeklyInterval(passwordScheduleScheduleWeeklyInterval)
	return o
}

// SetPasswordScheduleScheduleWeeklyInterval adds the passwordScheduleScheduleWeeklyInterval to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetPasswordScheduleScheduleWeeklyInterval(passwordScheduleScheduleWeeklyInterval *int64) {
	o.PasswordScheduleScheduleWeeklyInterval = passwordScheduleScheduleWeeklyInterval
}

// WithPreferredDcsFqdn adds the preferredDcsFqdn to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithPreferredDcsFqdn(preferredDcsFqdn *string) *CifsDomainCollectionGetParams {
	o.SetPreferredDcsFqdn(preferredDcsFqdn)
	return o
}

// SetPreferredDcsFqdn adds the preferredDcsFqdn to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetPreferredDcsFqdn(preferredDcsFqdn *string) {
	o.PreferredDcsFqdn = preferredDcsFqdn
}

// WithPreferredDcsServerIP adds the preferredDcsServerIP to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithPreferredDcsServerIP(preferredDcsServerIP *string) *CifsDomainCollectionGetParams {
	o.SetPreferredDcsServerIP(preferredDcsServerIP)
	return o
}

// SetPreferredDcsServerIP adds the preferredDcsServerIp to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetPreferredDcsServerIP(preferredDcsServerIP *string) {
	o.PreferredDcsServerIP = preferredDcsServerIP
}

// WithReturnRecords adds the returnRecords to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithReturnRecords(returnRecords *bool) *CifsDomainCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CifsDomainCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithServerDiscoveryMode adds the serverDiscoveryMode to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithServerDiscoveryMode(serverDiscoveryMode *string) *CifsDomainCollectionGetParams {
	o.SetServerDiscoveryMode(serverDiscoveryMode)
	return o
}

// SetServerDiscoveryMode adds the serverDiscoveryMode to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetServerDiscoveryMode(serverDiscoveryMode *string) {
	o.ServerDiscoveryMode = serverDiscoveryMode
}

// WithSvmName adds the svmName to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithSvmName(svmName *string) *CifsDomainCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithSvmUUID(svmUUID *string) *CifsDomainCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTenantID adds the tenantID to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithTenantID(tenantID *string) *CifsDomainCollectionGetParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetTenantID(tenantID *string) {
	o.TenantID = tenantID
}

// WithTrustRelationshipsHomeDomain adds the trustRelationshipsHomeDomain to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithTrustRelationshipsHomeDomain(trustRelationshipsHomeDomain *string) *CifsDomainCollectionGetParams {
	o.SetTrustRelationshipsHomeDomain(trustRelationshipsHomeDomain)
	return o
}

// SetTrustRelationshipsHomeDomain adds the trustRelationshipsHomeDomain to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetTrustRelationshipsHomeDomain(trustRelationshipsHomeDomain *string) {
	o.TrustRelationshipsHomeDomain = trustRelationshipsHomeDomain
}

// WithTrustRelationshipsNodeName adds the trustRelationshipsNodeName to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithTrustRelationshipsNodeName(trustRelationshipsNodeName *string) *CifsDomainCollectionGetParams {
	o.SetTrustRelationshipsNodeName(trustRelationshipsNodeName)
	return o
}

// SetTrustRelationshipsNodeName adds the trustRelationshipsNodeName to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetTrustRelationshipsNodeName(trustRelationshipsNodeName *string) {
	o.TrustRelationshipsNodeName = trustRelationshipsNodeName
}

// WithTrustRelationshipsNodeUUID adds the trustRelationshipsNodeUUID to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithTrustRelationshipsNodeUUID(trustRelationshipsNodeUUID *string) *CifsDomainCollectionGetParams {
	o.SetTrustRelationshipsNodeUUID(trustRelationshipsNodeUUID)
	return o
}

// SetTrustRelationshipsNodeUUID adds the trustRelationshipsNodeUuid to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetTrustRelationshipsNodeUUID(trustRelationshipsNodeUUID *string) {
	o.TrustRelationshipsNodeUUID = trustRelationshipsNodeUUID
}

// WithTrustRelationshipsTrustedDomains adds the trustRelationshipsTrustedDomains to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) WithTrustRelationshipsTrustedDomains(trustRelationshipsTrustedDomains *string) *CifsDomainCollectionGetParams {
	o.SetTrustRelationshipsTrustedDomains(trustRelationshipsTrustedDomains)
	return o
}

// SetTrustRelationshipsTrustedDomains adds the trustRelationshipsTrustedDomains to the cifs domain collection get params
func (o *CifsDomainCollectionGetParams) SetTrustRelationshipsTrustedDomains(trustRelationshipsTrustedDomains *string) {
	o.TrustRelationshipsTrustedDomains = trustRelationshipsTrustedDomains
}

// WriteToRequest writes these params to a swagger request
func (o *CifsDomainCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClientID != nil {

		// query param client_id
		var qrClientID string

		if o.ClientID != nil {
			qrClientID = *o.ClientID
		}
		qClientID := qrClientID
		if qClientID != "" {

			if err := r.SetQueryParam("client_id", qClientID); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersDomain != nil {

		// query param discovered_servers.domain
		var qrDiscoveredServersDomain string

		if o.DiscoveredServersDomain != nil {
			qrDiscoveredServersDomain = *o.DiscoveredServersDomain
		}
		qDiscoveredServersDomain := qrDiscoveredServersDomain
		if qDiscoveredServersDomain != "" {

			if err := r.SetQueryParam("discovered_servers.domain", qDiscoveredServersDomain); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersNodeName != nil {

		// query param discovered_servers.node.name
		var qrDiscoveredServersNodeName string

		if o.DiscoveredServersNodeName != nil {
			qrDiscoveredServersNodeName = *o.DiscoveredServersNodeName
		}
		qDiscoveredServersNodeName := qrDiscoveredServersNodeName
		if qDiscoveredServersNodeName != "" {

			if err := r.SetQueryParam("discovered_servers.node.name", qDiscoveredServersNodeName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersNodeUUID != nil {

		// query param discovered_servers.node.uuid
		var qrDiscoveredServersNodeUUID string

		if o.DiscoveredServersNodeUUID != nil {
			qrDiscoveredServersNodeUUID = *o.DiscoveredServersNodeUUID
		}
		qDiscoveredServersNodeUUID := qrDiscoveredServersNodeUUID
		if qDiscoveredServersNodeUUID != "" {

			if err := r.SetQueryParam("discovered_servers.node.uuid", qDiscoveredServersNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersPreference != nil {

		// query param discovered_servers.preference
		var qrDiscoveredServersPreference string

		if o.DiscoveredServersPreference != nil {
			qrDiscoveredServersPreference = *o.DiscoveredServersPreference
		}
		qDiscoveredServersPreference := qrDiscoveredServersPreference
		if qDiscoveredServersPreference != "" {

			if err := r.SetQueryParam("discovered_servers.preference", qDiscoveredServersPreference); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerIP != nil {

		// query param discovered_servers.server_ip
		var qrDiscoveredServersServerIP string

		if o.DiscoveredServersServerIP != nil {
			qrDiscoveredServersServerIP = *o.DiscoveredServersServerIP
		}
		qDiscoveredServersServerIP := qrDiscoveredServersServerIP
		if qDiscoveredServersServerIP != "" {

			if err := r.SetQueryParam("discovered_servers.server_ip", qDiscoveredServersServerIP); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerName != nil {

		// query param discovered_servers.server_name
		var qrDiscoveredServersServerName string

		if o.DiscoveredServersServerName != nil {
			qrDiscoveredServersServerName = *o.DiscoveredServersServerName
		}
		qDiscoveredServersServerName := qrDiscoveredServersServerName
		if qDiscoveredServersServerName != "" {

			if err := r.SetQueryParam("discovered_servers.server_name", qDiscoveredServersServerName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerType != nil {

		// query param discovered_servers.server_type
		var qrDiscoveredServersServerType string

		if o.DiscoveredServersServerType != nil {
			qrDiscoveredServersServerType = *o.DiscoveredServersServerType
		}
		qDiscoveredServersServerType := qrDiscoveredServersServerType
		if qDiscoveredServersServerType != "" {

			if err := r.SetQueryParam("discovered_servers.server_type", qDiscoveredServersServerType); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersState != nil {

		// query param discovered_servers.state
		var qrDiscoveredServersState string

		if o.DiscoveredServersState != nil {
			qrDiscoveredServersState = *o.DiscoveredServersState
		}
		qDiscoveredServersState := qrDiscoveredServersState
		if qDiscoveredServersState != "" {

			if err := r.SetQueryParam("discovered_servers.state", qDiscoveredServersState); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NameMappingTrustedDomains != nil {

		// query param name_mapping.trusted_domains
		var qrNameMappingTrustedDomains string

		if o.NameMappingTrustedDomains != nil {
			qrNameMappingTrustedDomains = *o.NameMappingTrustedDomains
		}
		qNameMappingTrustedDomains := qrNameMappingTrustedDomains
		if qNameMappingTrustedDomains != "" {

			if err := r.SetQueryParam("name_mapping.trusted_domains", qNameMappingTrustedDomains); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PasswordScheduleScheduleDescription != nil {

		// query param password_schedule.schedule_description
		var qrPasswordScheduleScheduleDescription string

		if o.PasswordScheduleScheduleDescription != nil {
			qrPasswordScheduleScheduleDescription = *o.PasswordScheduleScheduleDescription
		}
		qPasswordScheduleScheduleDescription := qrPasswordScheduleScheduleDescription
		if qPasswordScheduleScheduleDescription != "" {

			if err := r.SetQueryParam("password_schedule.schedule_description", qPasswordScheduleScheduleDescription); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleEnabled != nil {

		// query param password_schedule.schedule_enabled
		var qrPasswordScheduleScheduleEnabled bool

		if o.PasswordScheduleScheduleEnabled != nil {
			qrPasswordScheduleScheduleEnabled = *o.PasswordScheduleScheduleEnabled
		}
		qPasswordScheduleScheduleEnabled := swag.FormatBool(qrPasswordScheduleScheduleEnabled)
		if qPasswordScheduleScheduleEnabled != "" {

			if err := r.SetQueryParam("password_schedule.schedule_enabled", qPasswordScheduleScheduleEnabled); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleLastChangedTime != nil {

		// query param password_schedule.schedule_last_changed_time
		var qrPasswordScheduleScheduleLastChangedTime string

		if o.PasswordScheduleScheduleLastChangedTime != nil {
			qrPasswordScheduleScheduleLastChangedTime = *o.PasswordScheduleScheduleLastChangedTime
		}
		qPasswordScheduleScheduleLastChangedTime := qrPasswordScheduleScheduleLastChangedTime
		if qPasswordScheduleScheduleLastChangedTime != "" {

			if err := r.SetQueryParam("password_schedule.schedule_last_changed_time", qPasswordScheduleScheduleLastChangedTime); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleRandomizedMinute != nil {

		// query param password_schedule.schedule_randomized_minute
		var qrPasswordScheduleScheduleRandomizedMinute int64

		if o.PasswordScheduleScheduleRandomizedMinute != nil {
			qrPasswordScheduleScheduleRandomizedMinute = *o.PasswordScheduleScheduleRandomizedMinute
		}
		qPasswordScheduleScheduleRandomizedMinute := swag.FormatInt64(qrPasswordScheduleScheduleRandomizedMinute)
		if qPasswordScheduleScheduleRandomizedMinute != "" {

			if err := r.SetQueryParam("password_schedule.schedule_randomized_minute", qPasswordScheduleScheduleRandomizedMinute); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleWarnMessage != nil {

		// query param password_schedule.schedule_warn_message
		var qrPasswordScheduleScheduleWarnMessage string

		if o.PasswordScheduleScheduleWarnMessage != nil {
			qrPasswordScheduleScheduleWarnMessage = *o.PasswordScheduleScheduleWarnMessage
		}
		qPasswordScheduleScheduleWarnMessage := qrPasswordScheduleScheduleWarnMessage
		if qPasswordScheduleScheduleWarnMessage != "" {

			if err := r.SetQueryParam("password_schedule.schedule_warn_message", qPasswordScheduleScheduleWarnMessage); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleWeeklyInterval != nil {

		// query param password_schedule.schedule_weekly_interval
		var qrPasswordScheduleScheduleWeeklyInterval int64

		if o.PasswordScheduleScheduleWeeklyInterval != nil {
			qrPasswordScheduleScheduleWeeklyInterval = *o.PasswordScheduleScheduleWeeklyInterval
		}
		qPasswordScheduleScheduleWeeklyInterval := swag.FormatInt64(qrPasswordScheduleScheduleWeeklyInterval)
		if qPasswordScheduleScheduleWeeklyInterval != "" {

			if err := r.SetQueryParam("password_schedule.schedule_weekly_interval", qPasswordScheduleScheduleWeeklyInterval); err != nil {
				return err
			}
		}
	}

	if o.PreferredDcsFqdn != nil {

		// query param preferred_dcs.fqdn
		var qrPreferredDcsFqdn string

		if o.PreferredDcsFqdn != nil {
			qrPreferredDcsFqdn = *o.PreferredDcsFqdn
		}
		qPreferredDcsFqdn := qrPreferredDcsFqdn
		if qPreferredDcsFqdn != "" {

			if err := r.SetQueryParam("preferred_dcs.fqdn", qPreferredDcsFqdn); err != nil {
				return err
			}
		}
	}

	if o.PreferredDcsServerIP != nil {

		// query param preferred_dcs.server_ip
		var qrPreferredDcsServerIP string

		if o.PreferredDcsServerIP != nil {
			qrPreferredDcsServerIP = *o.PreferredDcsServerIP
		}
		qPreferredDcsServerIP := qrPreferredDcsServerIP
		if qPreferredDcsServerIP != "" {

			if err := r.SetQueryParam("preferred_dcs.server_ip", qPreferredDcsServerIP); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ServerDiscoveryMode != nil {

		// query param server_discovery_mode
		var qrServerDiscoveryMode string

		if o.ServerDiscoveryMode != nil {
			qrServerDiscoveryMode = *o.ServerDiscoveryMode
		}
		qServerDiscoveryMode := qrServerDiscoveryMode
		if qServerDiscoveryMode != "" {

			if err := r.SetQueryParam("server_discovery_mode", qServerDiscoveryMode); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TenantID != nil {

		// query param tenant_id
		var qrTenantID string

		if o.TenantID != nil {
			qrTenantID = *o.TenantID
		}
		qTenantID := qrTenantID
		if qTenantID != "" {

			if err := r.SetQueryParam("tenant_id", qTenantID); err != nil {
				return err
			}
		}
	}

	if o.TrustRelationshipsHomeDomain != nil {

		// query param trust_relationships.home_domain
		var qrTrustRelationshipsHomeDomain string

		if o.TrustRelationshipsHomeDomain != nil {
			qrTrustRelationshipsHomeDomain = *o.TrustRelationshipsHomeDomain
		}
		qTrustRelationshipsHomeDomain := qrTrustRelationshipsHomeDomain
		if qTrustRelationshipsHomeDomain != "" {

			if err := r.SetQueryParam("trust_relationships.home_domain", qTrustRelationshipsHomeDomain); err != nil {
				return err
			}
		}
	}

	if o.TrustRelationshipsNodeName != nil {

		// query param trust_relationships.node.name
		var qrTrustRelationshipsNodeName string

		if o.TrustRelationshipsNodeName != nil {
			qrTrustRelationshipsNodeName = *o.TrustRelationshipsNodeName
		}
		qTrustRelationshipsNodeName := qrTrustRelationshipsNodeName
		if qTrustRelationshipsNodeName != "" {

			if err := r.SetQueryParam("trust_relationships.node.name", qTrustRelationshipsNodeName); err != nil {
				return err
			}
		}
	}

	if o.TrustRelationshipsNodeUUID != nil {

		// query param trust_relationships.node.uuid
		var qrTrustRelationshipsNodeUUID string

		if o.TrustRelationshipsNodeUUID != nil {
			qrTrustRelationshipsNodeUUID = *o.TrustRelationshipsNodeUUID
		}
		qTrustRelationshipsNodeUUID := qrTrustRelationshipsNodeUUID
		if qTrustRelationshipsNodeUUID != "" {

			if err := r.SetQueryParam("trust_relationships.node.uuid", qTrustRelationshipsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.TrustRelationshipsTrustedDomains != nil {

		// query param trust_relationships.trusted_domains
		var qrTrustRelationshipsTrustedDomains string

		if o.TrustRelationshipsTrustedDomains != nil {
			qrTrustRelationshipsTrustedDomains = *o.TrustRelationshipsTrustedDomains
		}
		qTrustRelationshipsTrustedDomains := qrTrustRelationshipsTrustedDomains
		if qTrustRelationshipsTrustedDomains != "" {

			if err := r.SetQueryParam("trust_relationships.trusted_domains", qTrustRelationshipsTrustedDomains); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCifsDomainCollectionGet binds the parameter fields
func (o *CifsDomainCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCifsDomainCollectionGet binds the parameter order_by
func (o *CifsDomainCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
