// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsDomainCollectionGetReader is a Reader for the CifsDomainCollectionGet structure.
type CifsDomainCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsDomainCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsDomainCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsDomainCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsDomainCollectionGetOK creates a CifsDomainCollectionGetOK with default headers values
func NewCifsDomainCollectionGetOK() *CifsDomainCollectionGetOK {
	return &CifsDomainCollectionGetOK{}
}

/*
CifsDomainCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type CifsDomainCollectionGetOK struct {
	Payload *models.CifsDomainResponse
}

// IsSuccess returns true when this cifs domain collection get o k response has a 2xx status code
func (o *CifsDomainCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs domain collection get o k response has a 3xx status code
func (o *CifsDomainCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs domain collection get o k response has a 4xx status code
func (o *CifsDomainCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs domain collection get o k response has a 5xx status code
func (o *CifsDomainCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs domain collection get o k response a status code equal to that given
func (o *CifsDomainCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs domain collection get o k response
func (o *CifsDomainCollectionGetOK) Code() int {
	return 200
}

func (o *CifsDomainCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/domains][%d] cifsDomainCollectionGetOK %s", 200, payload)
}

func (o *CifsDomainCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/domains][%d] cifsDomainCollectionGetOK %s", 200, payload)
}

func (o *CifsDomainCollectionGetOK) GetPayload() *models.CifsDomainResponse {
	return o.Payload
}

func (o *CifsDomainCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CifsDomainResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCifsDomainCollectionGetDefault creates a CifsDomainCollectionGetDefault with default headers values
func NewCifsDomainCollectionGetDefault(code int) *CifsDomainCollectionGetDefault {
	return &CifsDomainCollectionGetDefault{
		_statusCode: code,
	}
}

/*
CifsDomainCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type CifsDomainCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs domain collection get default response has a 2xx status code
func (o *CifsDomainCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs domain collection get default response has a 3xx status code
func (o *CifsDomainCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs domain collection get default response has a 4xx status code
func (o *CifsDomainCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs domain collection get default response has a 5xx status code
func (o *CifsDomainCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs domain collection get default response a status code equal to that given
func (o *CifsDomainCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs domain collection get default response
func (o *CifsDomainCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *CifsDomainCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/domains][%d] cifs_domain_collection_get default %s", o._statusCode, payload)
}

func (o *CifsDomainCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/domains][%d] cifs_domain_collection_get default %s", o._statusCode, payload)
}

func (o *CifsDomainCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsDomainCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
