// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsDomainGetParams creates a new CifsDomainGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsDomainGetParams() *CifsDomainGetParams {
	return &CifsDomainGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsDomainGetParamsWithTimeout creates a new CifsDomainGetParams object
// with the ability to set a timeout on a request.
func NewCifsDomainGetParamsWithTimeout(timeout time.Duration) *CifsDomainGetParams {
	return &CifsDomainGetParams{
		timeout: timeout,
	}
}

// NewCifsDomainGetParamsWithContext creates a new CifsDomainGetParams object
// with the ability to set a context for a request.
func NewCifsDomainGetParamsWithContext(ctx context.Context) *CifsDomainGetParams {
	return &CifsDomainGetParams{
		Context: ctx,
	}
}

// NewCifsDomainGetParamsWithHTTPClient creates a new CifsDomainGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsDomainGetParamsWithHTTPClient(client *http.Client) *CifsDomainGetParams {
	return &CifsDomainGetParams{
		HTTPClient: client,
	}
}

/*
CifsDomainGetParams contains all the parameters to send to the API endpoint

	for the cifs domain get operation.

	Typically these are written to a http.Request.
*/
type CifsDomainGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* RediscoverTrusts.

	   Force the discovery of trusted domains.
	*/
	RediscoverTrusts *bool

	/* ResetDiscoveredServers.

	   Force a rediscovery.
	*/
	ResetDiscoveredServers *bool

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs domain get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsDomainGetParams) WithDefaults() *CifsDomainGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs domain get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsDomainGetParams) SetDefaults() {
	var (
		rediscoverTrustsDefault = bool(false)

		resetDiscoveredServersDefault = bool(false)
	)

	val := CifsDomainGetParams{
		RediscoverTrusts:       &rediscoverTrustsDefault,
		ResetDiscoveredServers: &resetDiscoveredServersDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs domain get params
func (o *CifsDomainGetParams) WithTimeout(timeout time.Duration) *CifsDomainGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs domain get params
func (o *CifsDomainGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs domain get params
func (o *CifsDomainGetParams) WithContext(ctx context.Context) *CifsDomainGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs domain get params
func (o *CifsDomainGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs domain get params
func (o *CifsDomainGetParams) WithHTTPClient(client *http.Client) *CifsDomainGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs domain get params
func (o *CifsDomainGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the cifs domain get params
func (o *CifsDomainGetParams) WithFields(fields []string) *CifsDomainGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cifs domain get params
func (o *CifsDomainGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithRediscoverTrusts adds the rediscoverTrusts to the cifs domain get params
func (o *CifsDomainGetParams) WithRediscoverTrusts(rediscoverTrusts *bool) *CifsDomainGetParams {
	o.SetRediscoverTrusts(rediscoverTrusts)
	return o
}

// SetRediscoverTrusts adds the rediscoverTrusts to the cifs domain get params
func (o *CifsDomainGetParams) SetRediscoverTrusts(rediscoverTrusts *bool) {
	o.RediscoverTrusts = rediscoverTrusts
}

// WithResetDiscoveredServers adds the resetDiscoveredServers to the cifs domain get params
func (o *CifsDomainGetParams) WithResetDiscoveredServers(resetDiscoveredServers *bool) *CifsDomainGetParams {
	o.SetResetDiscoveredServers(resetDiscoveredServers)
	return o
}

// SetResetDiscoveredServers adds the resetDiscoveredServers to the cifs domain get params
func (o *CifsDomainGetParams) SetResetDiscoveredServers(resetDiscoveredServers *bool) {
	o.ResetDiscoveredServers = resetDiscoveredServers
}

// WithSvmUUID adds the svmUUID to the cifs domain get params
func (o *CifsDomainGetParams) WithSvmUUID(svmUUID string) *CifsDomainGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs domain get params
func (o *CifsDomainGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsDomainGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.RediscoverTrusts != nil {

		// query param rediscover_trusts
		var qrRediscoverTrusts bool

		if o.RediscoverTrusts != nil {
			qrRediscoverTrusts = *o.RediscoverTrusts
		}
		qRediscoverTrusts := swag.FormatBool(qrRediscoverTrusts)
		if qRediscoverTrusts != "" {

			if err := r.SetQueryParam("rediscover_trusts", qRediscoverTrusts); err != nil {
				return err
			}
		}
	}

	if o.ResetDiscoveredServers != nil {

		// query param reset_discovered_servers
		var qrResetDiscoveredServers bool

		if o.ResetDiscoveredServers != nil {
			qrResetDiscoveredServers = *o.ResetDiscoveredServers
		}
		qResetDiscoveredServers := swag.FormatBool(qrResetDiscoveredServers)
		if qResetDiscoveredServers != "" {

			if err := r.SetQueryParam("reset_discovered_servers", qResetDiscoveredServers); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCifsDomainGet binds the parameter fields
func (o *CifsDomainGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
