// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsDomainModifyCollectionParams creates a new CifsDomainModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsDomainModifyCollectionParams() *CifsDomainModifyCollectionParams {
	return &CifsDomainModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsDomainModifyCollectionParamsWithTimeout creates a new CifsDomainModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewCifsDomainModifyCollectionParamsWithTimeout(timeout time.Duration) *CifsDomainModifyCollectionParams {
	return &CifsDomainModifyCollectionParams{
		timeout: timeout,
	}
}

// NewCifsDomainModifyCollectionParamsWithContext creates a new CifsDomainModifyCollectionParams object
// with the ability to set a context for a request.
func NewCifsDomainModifyCollectionParamsWithContext(ctx context.Context) *CifsDomainModifyCollectionParams {
	return &CifsDomainModifyCollectionParams{
		Context: ctx,
	}
}

// NewCifsDomainModifyCollectionParamsWithHTTPClient creates a new CifsDomainModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsDomainModifyCollectionParamsWithHTTPClient(client *http.Client) *CifsDomainModifyCollectionParams {
	return &CifsDomainModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
CifsDomainModifyCollectionParams contains all the parameters to send to the API endpoint

	for the cifs domain modify collection operation.

	Typically these are written to a http.Request.
*/
type CifsDomainModifyCollectionParams struct {

	/* CifsPasswordOperation.

	   Specifies the operation to be performed on the domain password.
	*/
	CifsPasswordOperation *string

	/* ClientID.

	   Filter by client_id
	*/
	ClientID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DiscoveredServersDomain.

	   Filter by discovered_servers.domain
	*/
	DiscoveredServersDomain *string

	/* DiscoveredServersNodeName.

	   Filter by discovered_servers.node.name
	*/
	DiscoveredServersNodeName *string

	/* DiscoveredServersNodeUUID.

	   Filter by discovered_servers.node.uuid
	*/
	DiscoveredServersNodeUUID *string

	/* DiscoveredServersPreference.

	   Filter by discovered_servers.preference
	*/
	DiscoveredServersPreference *string

	/* DiscoveredServersServerIP.

	   Filter by discovered_servers.server_ip
	*/
	DiscoveredServersServerIP *string

	/* DiscoveredServersServerName.

	   Filter by discovered_servers.server_name
	*/
	DiscoveredServersServerName *string

	/* DiscoveredServersServerType.

	   Filter by discovered_servers.server_type
	*/
	DiscoveredServersServerType *string

	/* DiscoveredServersState.

	   Filter by discovered_servers.state
	*/
	DiscoveredServersState *string

	/* Info.

	   Info specification
	*/
	Info CifsDomainModifyCollectionBody

	/* NameMappingTrustedDomains.

	   Filter by name_mapping.trusted_domains
	*/
	NameMappingTrustedDomains *string

	/* PasswordScheduleScheduleDescription.

	   Filter by password_schedule.schedule_description
	*/
	PasswordScheduleScheduleDescription *string

	/* PasswordScheduleScheduleEnabled.

	   Filter by password_schedule.schedule_enabled
	*/
	PasswordScheduleScheduleEnabled *bool

	/* PasswordScheduleScheduleLastChangedTime.

	   Filter by password_schedule.schedule_last_changed_time
	*/
	PasswordScheduleScheduleLastChangedTime *string

	/* PasswordScheduleScheduleRandomizedMinute.

	   Filter by password_schedule.schedule_randomized_minute
	*/
	PasswordScheduleScheduleRandomizedMinute *int64

	/* PasswordScheduleScheduleWarnMessage.

	   Filter by password_schedule.schedule_warn_message
	*/
	PasswordScheduleScheduleWarnMessage *string

	/* PasswordScheduleScheduleWeeklyInterval.

	   Filter by password_schedule.schedule_weekly_interval
	*/
	PasswordScheduleScheduleWeeklyInterval *int64

	/* PreferredDcsFqdn.

	   Filter by preferred_dcs.fqdn
	*/
	PreferredDcsFqdn *string

	/* PreferredDcsServerIP.

	   Filter by preferred_dcs.server_ip
	*/
	PreferredDcsServerIP *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* ServerDiscoveryMode.

	   Filter by server_discovery_mode
	*/
	ServerDiscoveryMode *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TenantID.

	   Filter by tenant_id
	*/
	TenantID *string

	/* TrustRelationshipsHomeDomain.

	   Filter by trust_relationships.home_domain
	*/
	TrustRelationshipsHomeDomain *string

	/* TrustRelationshipsNodeName.

	   Filter by trust_relationships.node.name
	*/
	TrustRelationshipsNodeName *string

	/* TrustRelationshipsNodeUUID.

	   Filter by trust_relationships.node.uuid
	*/
	TrustRelationshipsNodeUUID *string

	/* TrustRelationshipsTrustedDomains.

	   Filter by trust_relationships.trusted_domains
	*/
	TrustRelationshipsTrustedDomains *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs domain modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsDomainModifyCollectionParams) WithDefaults() *CifsDomainModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs domain modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsDomainModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CifsDomainModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithTimeout(timeout time.Duration) *CifsDomainModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithContext(ctx context.Context) *CifsDomainModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithHTTPClient(client *http.Client) *CifsDomainModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCifsPasswordOperation adds the cifsPasswordOperation to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithCifsPasswordOperation(cifsPasswordOperation *string) *CifsDomainModifyCollectionParams {
	o.SetCifsPasswordOperation(cifsPasswordOperation)
	return o
}

// SetCifsPasswordOperation adds the cifsPasswordOperation to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetCifsPasswordOperation(cifsPasswordOperation *string) {
	o.CifsPasswordOperation = cifsPasswordOperation
}

// WithClientID adds the clientID to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithClientID(clientID *string) *CifsDomainModifyCollectionParams {
	o.SetClientID(clientID)
	return o
}

// SetClientID adds the clientId to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetClientID(clientID *string) {
	o.ClientID = clientID
}

// WithContinueOnFailure adds the continueOnFailure to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CifsDomainModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDiscoveredServersDomain adds the discoveredServersDomain to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithDiscoveredServersDomain(discoveredServersDomain *string) *CifsDomainModifyCollectionParams {
	o.SetDiscoveredServersDomain(discoveredServersDomain)
	return o
}

// SetDiscoveredServersDomain adds the discoveredServersDomain to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetDiscoveredServersDomain(discoveredServersDomain *string) {
	o.DiscoveredServersDomain = discoveredServersDomain
}

// WithDiscoveredServersNodeName adds the discoveredServersNodeName to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithDiscoveredServersNodeName(discoveredServersNodeName *string) *CifsDomainModifyCollectionParams {
	o.SetDiscoveredServersNodeName(discoveredServersNodeName)
	return o
}

// SetDiscoveredServersNodeName adds the discoveredServersNodeName to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetDiscoveredServersNodeName(discoveredServersNodeName *string) {
	o.DiscoveredServersNodeName = discoveredServersNodeName
}

// WithDiscoveredServersNodeUUID adds the discoveredServersNodeUUID to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithDiscoveredServersNodeUUID(discoveredServersNodeUUID *string) *CifsDomainModifyCollectionParams {
	o.SetDiscoveredServersNodeUUID(discoveredServersNodeUUID)
	return o
}

// SetDiscoveredServersNodeUUID adds the discoveredServersNodeUuid to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetDiscoveredServersNodeUUID(discoveredServersNodeUUID *string) {
	o.DiscoveredServersNodeUUID = discoveredServersNodeUUID
}

// WithDiscoveredServersPreference adds the discoveredServersPreference to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithDiscoveredServersPreference(discoveredServersPreference *string) *CifsDomainModifyCollectionParams {
	o.SetDiscoveredServersPreference(discoveredServersPreference)
	return o
}

// SetDiscoveredServersPreference adds the discoveredServersPreference to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetDiscoveredServersPreference(discoveredServersPreference *string) {
	o.DiscoveredServersPreference = discoveredServersPreference
}

// WithDiscoveredServersServerIP adds the discoveredServersServerIP to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithDiscoveredServersServerIP(discoveredServersServerIP *string) *CifsDomainModifyCollectionParams {
	o.SetDiscoveredServersServerIP(discoveredServersServerIP)
	return o
}

// SetDiscoveredServersServerIP adds the discoveredServersServerIp to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetDiscoveredServersServerIP(discoveredServersServerIP *string) {
	o.DiscoveredServersServerIP = discoveredServersServerIP
}

// WithDiscoveredServersServerName adds the discoveredServersServerName to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithDiscoveredServersServerName(discoveredServersServerName *string) *CifsDomainModifyCollectionParams {
	o.SetDiscoveredServersServerName(discoveredServersServerName)
	return o
}

// SetDiscoveredServersServerName adds the discoveredServersServerName to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetDiscoveredServersServerName(discoveredServersServerName *string) {
	o.DiscoveredServersServerName = discoveredServersServerName
}

// WithDiscoveredServersServerType adds the discoveredServersServerType to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithDiscoveredServersServerType(discoveredServersServerType *string) *CifsDomainModifyCollectionParams {
	o.SetDiscoveredServersServerType(discoveredServersServerType)
	return o
}

// SetDiscoveredServersServerType adds the discoveredServersServerType to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetDiscoveredServersServerType(discoveredServersServerType *string) {
	o.DiscoveredServersServerType = discoveredServersServerType
}

// WithDiscoveredServersState adds the discoveredServersState to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithDiscoveredServersState(discoveredServersState *string) *CifsDomainModifyCollectionParams {
	o.SetDiscoveredServersState(discoveredServersState)
	return o
}

// SetDiscoveredServersState adds the discoveredServersState to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetDiscoveredServersState(discoveredServersState *string) {
	o.DiscoveredServersState = discoveredServersState
}

// WithInfo adds the info to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithInfo(info CifsDomainModifyCollectionBody) *CifsDomainModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetInfo(info CifsDomainModifyCollectionBody) {
	o.Info = info
}

// WithNameMappingTrustedDomains adds the nameMappingTrustedDomains to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithNameMappingTrustedDomains(nameMappingTrustedDomains *string) *CifsDomainModifyCollectionParams {
	o.SetNameMappingTrustedDomains(nameMappingTrustedDomains)
	return o
}

// SetNameMappingTrustedDomains adds the nameMappingTrustedDomains to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetNameMappingTrustedDomains(nameMappingTrustedDomains *string) {
	o.NameMappingTrustedDomains = nameMappingTrustedDomains
}

// WithPasswordScheduleScheduleDescription adds the passwordScheduleScheduleDescription to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithPasswordScheduleScheduleDescription(passwordScheduleScheduleDescription *string) *CifsDomainModifyCollectionParams {
	o.SetPasswordScheduleScheduleDescription(passwordScheduleScheduleDescription)
	return o
}

// SetPasswordScheduleScheduleDescription adds the passwordScheduleScheduleDescription to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetPasswordScheduleScheduleDescription(passwordScheduleScheduleDescription *string) {
	o.PasswordScheduleScheduleDescription = passwordScheduleScheduleDescription
}

// WithPasswordScheduleScheduleEnabled adds the passwordScheduleScheduleEnabled to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithPasswordScheduleScheduleEnabled(passwordScheduleScheduleEnabled *bool) *CifsDomainModifyCollectionParams {
	o.SetPasswordScheduleScheduleEnabled(passwordScheduleScheduleEnabled)
	return o
}

// SetPasswordScheduleScheduleEnabled adds the passwordScheduleScheduleEnabled to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetPasswordScheduleScheduleEnabled(passwordScheduleScheduleEnabled *bool) {
	o.PasswordScheduleScheduleEnabled = passwordScheduleScheduleEnabled
}

// WithPasswordScheduleScheduleLastChangedTime adds the passwordScheduleScheduleLastChangedTime to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithPasswordScheduleScheduleLastChangedTime(passwordScheduleScheduleLastChangedTime *string) *CifsDomainModifyCollectionParams {
	o.SetPasswordScheduleScheduleLastChangedTime(passwordScheduleScheduleLastChangedTime)
	return o
}

// SetPasswordScheduleScheduleLastChangedTime adds the passwordScheduleScheduleLastChangedTime to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetPasswordScheduleScheduleLastChangedTime(passwordScheduleScheduleLastChangedTime *string) {
	o.PasswordScheduleScheduleLastChangedTime = passwordScheduleScheduleLastChangedTime
}

// WithPasswordScheduleScheduleRandomizedMinute adds the passwordScheduleScheduleRandomizedMinute to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithPasswordScheduleScheduleRandomizedMinute(passwordScheduleScheduleRandomizedMinute *int64) *CifsDomainModifyCollectionParams {
	o.SetPasswordScheduleScheduleRandomizedMinute(passwordScheduleScheduleRandomizedMinute)
	return o
}

// SetPasswordScheduleScheduleRandomizedMinute adds the passwordScheduleScheduleRandomizedMinute to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetPasswordScheduleScheduleRandomizedMinute(passwordScheduleScheduleRandomizedMinute *int64) {
	o.PasswordScheduleScheduleRandomizedMinute = passwordScheduleScheduleRandomizedMinute
}

// WithPasswordScheduleScheduleWarnMessage adds the passwordScheduleScheduleWarnMessage to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithPasswordScheduleScheduleWarnMessage(passwordScheduleScheduleWarnMessage *string) *CifsDomainModifyCollectionParams {
	o.SetPasswordScheduleScheduleWarnMessage(passwordScheduleScheduleWarnMessage)
	return o
}

// SetPasswordScheduleScheduleWarnMessage adds the passwordScheduleScheduleWarnMessage to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetPasswordScheduleScheduleWarnMessage(passwordScheduleScheduleWarnMessage *string) {
	o.PasswordScheduleScheduleWarnMessage = passwordScheduleScheduleWarnMessage
}

// WithPasswordScheduleScheduleWeeklyInterval adds the passwordScheduleScheduleWeeklyInterval to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithPasswordScheduleScheduleWeeklyInterval(passwordScheduleScheduleWeeklyInterval *int64) *CifsDomainModifyCollectionParams {
	o.SetPasswordScheduleScheduleWeeklyInterval(passwordScheduleScheduleWeeklyInterval)
	return o
}

// SetPasswordScheduleScheduleWeeklyInterval adds the passwordScheduleScheduleWeeklyInterval to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetPasswordScheduleScheduleWeeklyInterval(passwordScheduleScheduleWeeklyInterval *int64) {
	o.PasswordScheduleScheduleWeeklyInterval = passwordScheduleScheduleWeeklyInterval
}

// WithPreferredDcsFqdn adds the preferredDcsFqdn to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithPreferredDcsFqdn(preferredDcsFqdn *string) *CifsDomainModifyCollectionParams {
	o.SetPreferredDcsFqdn(preferredDcsFqdn)
	return o
}

// SetPreferredDcsFqdn adds the preferredDcsFqdn to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetPreferredDcsFqdn(preferredDcsFqdn *string) {
	o.PreferredDcsFqdn = preferredDcsFqdn
}

// WithPreferredDcsServerIP adds the preferredDcsServerIP to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithPreferredDcsServerIP(preferredDcsServerIP *string) *CifsDomainModifyCollectionParams {
	o.SetPreferredDcsServerIP(preferredDcsServerIP)
	return o
}

// SetPreferredDcsServerIP adds the preferredDcsServerIp to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetPreferredDcsServerIP(preferredDcsServerIP *string) {
	o.PreferredDcsServerIP = preferredDcsServerIP
}

// WithReturnRecords adds the returnRecords to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithReturnRecords(returnRecords *bool) *CifsDomainModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *CifsDomainModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithSerialRecords(serialRecords *bool) *CifsDomainModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServerDiscoveryMode adds the serverDiscoveryMode to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithServerDiscoveryMode(serverDiscoveryMode *string) *CifsDomainModifyCollectionParams {
	o.SetServerDiscoveryMode(serverDiscoveryMode)
	return o
}

// SetServerDiscoveryMode adds the serverDiscoveryMode to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetServerDiscoveryMode(serverDiscoveryMode *string) {
	o.ServerDiscoveryMode = serverDiscoveryMode
}

// WithSvmName adds the svmName to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithSvmName(svmName *string) *CifsDomainModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithSvmUUID(svmUUID *string) *CifsDomainModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTenantID adds the tenantID to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithTenantID(tenantID *string) *CifsDomainModifyCollectionParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetTenantID(tenantID *string) {
	o.TenantID = tenantID
}

// WithTrustRelationshipsHomeDomain adds the trustRelationshipsHomeDomain to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithTrustRelationshipsHomeDomain(trustRelationshipsHomeDomain *string) *CifsDomainModifyCollectionParams {
	o.SetTrustRelationshipsHomeDomain(trustRelationshipsHomeDomain)
	return o
}

// SetTrustRelationshipsHomeDomain adds the trustRelationshipsHomeDomain to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetTrustRelationshipsHomeDomain(trustRelationshipsHomeDomain *string) {
	o.TrustRelationshipsHomeDomain = trustRelationshipsHomeDomain
}

// WithTrustRelationshipsNodeName adds the trustRelationshipsNodeName to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithTrustRelationshipsNodeName(trustRelationshipsNodeName *string) *CifsDomainModifyCollectionParams {
	o.SetTrustRelationshipsNodeName(trustRelationshipsNodeName)
	return o
}

// SetTrustRelationshipsNodeName adds the trustRelationshipsNodeName to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetTrustRelationshipsNodeName(trustRelationshipsNodeName *string) {
	o.TrustRelationshipsNodeName = trustRelationshipsNodeName
}

// WithTrustRelationshipsNodeUUID adds the trustRelationshipsNodeUUID to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithTrustRelationshipsNodeUUID(trustRelationshipsNodeUUID *string) *CifsDomainModifyCollectionParams {
	o.SetTrustRelationshipsNodeUUID(trustRelationshipsNodeUUID)
	return o
}

// SetTrustRelationshipsNodeUUID adds the trustRelationshipsNodeUuid to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetTrustRelationshipsNodeUUID(trustRelationshipsNodeUUID *string) {
	o.TrustRelationshipsNodeUUID = trustRelationshipsNodeUUID
}

// WithTrustRelationshipsTrustedDomains adds the trustRelationshipsTrustedDomains to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) WithTrustRelationshipsTrustedDomains(trustRelationshipsTrustedDomains *string) *CifsDomainModifyCollectionParams {
	o.SetTrustRelationshipsTrustedDomains(trustRelationshipsTrustedDomains)
	return o
}

// SetTrustRelationshipsTrustedDomains adds the trustRelationshipsTrustedDomains to the cifs domain modify collection params
func (o *CifsDomainModifyCollectionParams) SetTrustRelationshipsTrustedDomains(trustRelationshipsTrustedDomains *string) {
	o.TrustRelationshipsTrustedDomains = trustRelationshipsTrustedDomains
}

// WriteToRequest writes these params to a swagger request
func (o *CifsDomainModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CifsPasswordOperation != nil {

		// query param cifs_password_operation
		var qrCifsPasswordOperation string

		if o.CifsPasswordOperation != nil {
			qrCifsPasswordOperation = *o.CifsPasswordOperation
		}
		qCifsPasswordOperation := qrCifsPasswordOperation
		if qCifsPasswordOperation != "" {

			if err := r.SetQueryParam("cifs_password_operation", qCifsPasswordOperation); err != nil {
				return err
			}
		}
	}

	if o.ClientID != nil {

		// query param client_id
		var qrClientID string

		if o.ClientID != nil {
			qrClientID = *o.ClientID
		}
		qClientID := qrClientID
		if qClientID != "" {

			if err := r.SetQueryParam("client_id", qClientID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersDomain != nil {

		// query param discovered_servers.domain
		var qrDiscoveredServersDomain string

		if o.DiscoveredServersDomain != nil {
			qrDiscoveredServersDomain = *o.DiscoveredServersDomain
		}
		qDiscoveredServersDomain := qrDiscoveredServersDomain
		if qDiscoveredServersDomain != "" {

			if err := r.SetQueryParam("discovered_servers.domain", qDiscoveredServersDomain); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersNodeName != nil {

		// query param discovered_servers.node.name
		var qrDiscoveredServersNodeName string

		if o.DiscoveredServersNodeName != nil {
			qrDiscoveredServersNodeName = *o.DiscoveredServersNodeName
		}
		qDiscoveredServersNodeName := qrDiscoveredServersNodeName
		if qDiscoveredServersNodeName != "" {

			if err := r.SetQueryParam("discovered_servers.node.name", qDiscoveredServersNodeName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersNodeUUID != nil {

		// query param discovered_servers.node.uuid
		var qrDiscoveredServersNodeUUID string

		if o.DiscoveredServersNodeUUID != nil {
			qrDiscoveredServersNodeUUID = *o.DiscoveredServersNodeUUID
		}
		qDiscoveredServersNodeUUID := qrDiscoveredServersNodeUUID
		if qDiscoveredServersNodeUUID != "" {

			if err := r.SetQueryParam("discovered_servers.node.uuid", qDiscoveredServersNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersPreference != nil {

		// query param discovered_servers.preference
		var qrDiscoveredServersPreference string

		if o.DiscoveredServersPreference != nil {
			qrDiscoveredServersPreference = *o.DiscoveredServersPreference
		}
		qDiscoveredServersPreference := qrDiscoveredServersPreference
		if qDiscoveredServersPreference != "" {

			if err := r.SetQueryParam("discovered_servers.preference", qDiscoveredServersPreference); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerIP != nil {

		// query param discovered_servers.server_ip
		var qrDiscoveredServersServerIP string

		if o.DiscoveredServersServerIP != nil {
			qrDiscoveredServersServerIP = *o.DiscoveredServersServerIP
		}
		qDiscoveredServersServerIP := qrDiscoveredServersServerIP
		if qDiscoveredServersServerIP != "" {

			if err := r.SetQueryParam("discovered_servers.server_ip", qDiscoveredServersServerIP); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerName != nil {

		// query param discovered_servers.server_name
		var qrDiscoveredServersServerName string

		if o.DiscoveredServersServerName != nil {
			qrDiscoveredServersServerName = *o.DiscoveredServersServerName
		}
		qDiscoveredServersServerName := qrDiscoveredServersServerName
		if qDiscoveredServersServerName != "" {

			if err := r.SetQueryParam("discovered_servers.server_name", qDiscoveredServersServerName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersServerType != nil {

		// query param discovered_servers.server_type
		var qrDiscoveredServersServerType string

		if o.DiscoveredServersServerType != nil {
			qrDiscoveredServersServerType = *o.DiscoveredServersServerType
		}
		qDiscoveredServersServerType := qrDiscoveredServersServerType
		if qDiscoveredServersServerType != "" {

			if err := r.SetQueryParam("discovered_servers.server_type", qDiscoveredServersServerType); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredServersState != nil {

		// query param discovered_servers.state
		var qrDiscoveredServersState string

		if o.DiscoveredServersState != nil {
			qrDiscoveredServersState = *o.DiscoveredServersState
		}
		qDiscoveredServersState := qrDiscoveredServersState
		if qDiscoveredServersState != "" {

			if err := r.SetQueryParam("discovered_servers.state", qDiscoveredServersState); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.NameMappingTrustedDomains != nil {

		// query param name_mapping.trusted_domains
		var qrNameMappingTrustedDomains string

		if o.NameMappingTrustedDomains != nil {
			qrNameMappingTrustedDomains = *o.NameMappingTrustedDomains
		}
		qNameMappingTrustedDomains := qrNameMappingTrustedDomains
		if qNameMappingTrustedDomains != "" {

			if err := r.SetQueryParam("name_mapping.trusted_domains", qNameMappingTrustedDomains); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleDescription != nil {

		// query param password_schedule.schedule_description
		var qrPasswordScheduleScheduleDescription string

		if o.PasswordScheduleScheduleDescription != nil {
			qrPasswordScheduleScheduleDescription = *o.PasswordScheduleScheduleDescription
		}
		qPasswordScheduleScheduleDescription := qrPasswordScheduleScheduleDescription
		if qPasswordScheduleScheduleDescription != "" {

			if err := r.SetQueryParam("password_schedule.schedule_description", qPasswordScheduleScheduleDescription); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleEnabled != nil {

		// query param password_schedule.schedule_enabled
		var qrPasswordScheduleScheduleEnabled bool

		if o.PasswordScheduleScheduleEnabled != nil {
			qrPasswordScheduleScheduleEnabled = *o.PasswordScheduleScheduleEnabled
		}
		qPasswordScheduleScheduleEnabled := swag.FormatBool(qrPasswordScheduleScheduleEnabled)
		if qPasswordScheduleScheduleEnabled != "" {

			if err := r.SetQueryParam("password_schedule.schedule_enabled", qPasswordScheduleScheduleEnabled); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleLastChangedTime != nil {

		// query param password_schedule.schedule_last_changed_time
		var qrPasswordScheduleScheduleLastChangedTime string

		if o.PasswordScheduleScheduleLastChangedTime != nil {
			qrPasswordScheduleScheduleLastChangedTime = *o.PasswordScheduleScheduleLastChangedTime
		}
		qPasswordScheduleScheduleLastChangedTime := qrPasswordScheduleScheduleLastChangedTime
		if qPasswordScheduleScheduleLastChangedTime != "" {

			if err := r.SetQueryParam("password_schedule.schedule_last_changed_time", qPasswordScheduleScheduleLastChangedTime); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleRandomizedMinute != nil {

		// query param password_schedule.schedule_randomized_minute
		var qrPasswordScheduleScheduleRandomizedMinute int64

		if o.PasswordScheduleScheduleRandomizedMinute != nil {
			qrPasswordScheduleScheduleRandomizedMinute = *o.PasswordScheduleScheduleRandomizedMinute
		}
		qPasswordScheduleScheduleRandomizedMinute := swag.FormatInt64(qrPasswordScheduleScheduleRandomizedMinute)
		if qPasswordScheduleScheduleRandomizedMinute != "" {

			if err := r.SetQueryParam("password_schedule.schedule_randomized_minute", qPasswordScheduleScheduleRandomizedMinute); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleWarnMessage != nil {

		// query param password_schedule.schedule_warn_message
		var qrPasswordScheduleScheduleWarnMessage string

		if o.PasswordScheduleScheduleWarnMessage != nil {
			qrPasswordScheduleScheduleWarnMessage = *o.PasswordScheduleScheduleWarnMessage
		}
		qPasswordScheduleScheduleWarnMessage := qrPasswordScheduleScheduleWarnMessage
		if qPasswordScheduleScheduleWarnMessage != "" {

			if err := r.SetQueryParam("password_schedule.schedule_warn_message", qPasswordScheduleScheduleWarnMessage); err != nil {
				return err
			}
		}
	}

	if o.PasswordScheduleScheduleWeeklyInterval != nil {

		// query param password_schedule.schedule_weekly_interval
		var qrPasswordScheduleScheduleWeeklyInterval int64

		if o.PasswordScheduleScheduleWeeklyInterval != nil {
			qrPasswordScheduleScheduleWeeklyInterval = *o.PasswordScheduleScheduleWeeklyInterval
		}
		qPasswordScheduleScheduleWeeklyInterval := swag.FormatInt64(qrPasswordScheduleScheduleWeeklyInterval)
		if qPasswordScheduleScheduleWeeklyInterval != "" {

			if err := r.SetQueryParam("password_schedule.schedule_weekly_interval", qPasswordScheduleScheduleWeeklyInterval); err != nil {
				return err
			}
		}
	}

	if o.PreferredDcsFqdn != nil {

		// query param preferred_dcs.fqdn
		var qrPreferredDcsFqdn string

		if o.PreferredDcsFqdn != nil {
			qrPreferredDcsFqdn = *o.PreferredDcsFqdn
		}
		qPreferredDcsFqdn := qrPreferredDcsFqdn
		if qPreferredDcsFqdn != "" {

			if err := r.SetQueryParam("preferred_dcs.fqdn", qPreferredDcsFqdn); err != nil {
				return err
			}
		}
	}

	if o.PreferredDcsServerIP != nil {

		// query param preferred_dcs.server_ip
		var qrPreferredDcsServerIP string

		if o.PreferredDcsServerIP != nil {
			qrPreferredDcsServerIP = *o.PreferredDcsServerIP
		}
		qPreferredDcsServerIP := qrPreferredDcsServerIP
		if qPreferredDcsServerIP != "" {

			if err := r.SetQueryParam("preferred_dcs.server_ip", qPreferredDcsServerIP); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.ServerDiscoveryMode != nil {

		// query param server_discovery_mode
		var qrServerDiscoveryMode string

		if o.ServerDiscoveryMode != nil {
			qrServerDiscoveryMode = *o.ServerDiscoveryMode
		}
		qServerDiscoveryMode := qrServerDiscoveryMode
		if qServerDiscoveryMode != "" {

			if err := r.SetQueryParam("server_discovery_mode", qServerDiscoveryMode); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TenantID != nil {

		// query param tenant_id
		var qrTenantID string

		if o.TenantID != nil {
			qrTenantID = *o.TenantID
		}
		qTenantID := qrTenantID
		if qTenantID != "" {

			if err := r.SetQueryParam("tenant_id", qTenantID); err != nil {
				return err
			}
		}
	}

	if o.TrustRelationshipsHomeDomain != nil {

		// query param trust_relationships.home_domain
		var qrTrustRelationshipsHomeDomain string

		if o.TrustRelationshipsHomeDomain != nil {
			qrTrustRelationshipsHomeDomain = *o.TrustRelationshipsHomeDomain
		}
		qTrustRelationshipsHomeDomain := qrTrustRelationshipsHomeDomain
		if qTrustRelationshipsHomeDomain != "" {

			if err := r.SetQueryParam("trust_relationships.home_domain", qTrustRelationshipsHomeDomain); err != nil {
				return err
			}
		}
	}

	if o.TrustRelationshipsNodeName != nil {

		// query param trust_relationships.node.name
		var qrTrustRelationshipsNodeName string

		if o.TrustRelationshipsNodeName != nil {
			qrTrustRelationshipsNodeName = *o.TrustRelationshipsNodeName
		}
		qTrustRelationshipsNodeName := qrTrustRelationshipsNodeName
		if qTrustRelationshipsNodeName != "" {

			if err := r.SetQueryParam("trust_relationships.node.name", qTrustRelationshipsNodeName); err != nil {
				return err
			}
		}
	}

	if o.TrustRelationshipsNodeUUID != nil {

		// query param trust_relationships.node.uuid
		var qrTrustRelationshipsNodeUUID string

		if o.TrustRelationshipsNodeUUID != nil {
			qrTrustRelationshipsNodeUUID = *o.TrustRelationshipsNodeUUID
		}
		qTrustRelationshipsNodeUUID := qrTrustRelationshipsNodeUUID
		if qTrustRelationshipsNodeUUID != "" {

			if err := r.SetQueryParam("trust_relationships.node.uuid", qTrustRelationshipsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.TrustRelationshipsTrustedDomains != nil {

		// query param trust_relationships.trusted_domains
		var qrTrustRelationshipsTrustedDomains string

		if o.TrustRelationshipsTrustedDomains != nil {
			qrTrustRelationshipsTrustedDomains = *o.TrustRelationshipsTrustedDomains
		}
		qTrustRelationshipsTrustedDomains := qrTrustRelationshipsTrustedDomains
		if qTrustRelationshipsTrustedDomains != "" {

			if err := r.SetQueryParam("trust_relationships.trusted_domains", qTrustRelationshipsTrustedDomains); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
