// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsDomainModifyCollectionReader is a Reader for the CifsDomainModifyCollection structure.
type CifsDomainModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsDomainModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsDomainModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsDomainModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsDomainModifyCollectionOK creates a CifsDomainModifyCollectionOK with default headers values
func NewCifsDomainModifyCollectionOK() *CifsDomainModifyCollectionOK {
	return &CifsDomainModifyCollectionOK{}
}

/*
CifsDomainModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CifsDomainModifyCollectionOK struct {
}

// IsSuccess returns true when this cifs domain modify collection o k response has a 2xx status code
func (o *CifsDomainModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs domain modify collection o k response has a 3xx status code
func (o *CifsDomainModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs domain modify collection o k response has a 4xx status code
func (o *CifsDomainModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs domain modify collection o k response has a 5xx status code
func (o *CifsDomainModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs domain modify collection o k response a status code equal to that given
func (o *CifsDomainModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs domain modify collection o k response
func (o *CifsDomainModifyCollectionOK) Code() int {
	return 200
}

func (o *CifsDomainModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/domains][%d] cifsDomainModifyCollectionOK", 200)
}

func (o *CifsDomainModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/domains][%d] cifsDomainModifyCollectionOK", 200)
}

func (o *CifsDomainModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsDomainModifyCollectionDefault creates a CifsDomainModifyCollectionDefault with default headers values
func NewCifsDomainModifyCollectionDefault(code int) *CifsDomainModifyCollectionDefault {
	return &CifsDomainModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	CifsDomainModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
|  262278    | Domain user and password are required fields. |
|  655513    | Password update failed due to invalid credentials. |
|  656392    | Preferred DC's need to be configured if CIFS discovery mode is set to none. |
|  656393    | Default site needs to be configured if CIFS discovery mode is set to site.  |
|  656487    | Missing fields when doing CIFS operation with hybrid auth user type. |
*/
type CifsDomainModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs domain modify collection default response has a 2xx status code
func (o *CifsDomainModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs domain modify collection default response has a 3xx status code
func (o *CifsDomainModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs domain modify collection default response has a 4xx status code
func (o *CifsDomainModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs domain modify collection default response has a 5xx status code
func (o *CifsDomainModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs domain modify collection default response a status code equal to that given
func (o *CifsDomainModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs domain modify collection default response
func (o *CifsDomainModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CifsDomainModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/domains][%d] cifs_domain_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsDomainModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/domains][%d] cifs_domain_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsDomainModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsDomainModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CifsDomainModifyCollectionBody cifs domain modify collection body
swagger:model CifsDomainModifyCollectionBody
*/
type CifsDomainModifyCollectionBody struct {

	// ad domain
	AdDomain *models.CifsDomainInlineAdDomain `json:"ad_domain,omitempty"`

	// Specifies the discovered servers records.
	//
	// Read Only: true
	CifsDomainInlineDiscoveredServers []*models.CifsDomainInlineDiscoveredServersInlineArrayItem `json:"discovered_servers,omitempty"`

	// Specifies the preferred DC records.
	//
	// Read Only: true
	CifsDomainInlinePreferredDcs []*models.CifsDomainInlinePreferredDcsInlineArrayItem `json:"preferred_dcs,omitempty"`

	// Specifies the trusted domain records.
	//
	// Read Only: true
	CifsDomainInlineTrustRelationships []*models.CifsDomainInlineTrustRelationshipsInlineArrayItem `json:"trust_relationships,omitempty"`

	// cifs domain response inline records
	CifsDomainResponseInlineRecords []*models.CifsDomain `json:"records,omitempty"`

	// PKCS12 certificate used by the application to prove its identity to AKV.
	// Example: PEM Cert
	// Format: password
	ClientCertificate *strfmt.Password `json:"client_certificate,omitempty"`

	// Application client ID of the deployed Azure application with appropriate access to an AKV or EntraId.
	// Example: e959d1b5-5a63-4284-9268-851e30e3eceb
	ClientID *string `json:"client_id,omitempty"`

	// name mapping
	NameMapping *models.CifsDomainInlineNameMapping `json:"name_mapping,omitempty"`

	// password schedule
	PasswordSchedule *models.CifsDomainInlinePasswordSchedule `json:"password_schedule,omitempty"`

	// Specifies the mode of server discovery.
	//
	// Enum: ["all","site","none"]
	ServerDiscoveryMode *string `json:"server_discovery_mode,omitempty"`

	// svm
	Svm *models.CifsDomainInlineSvm `json:"svm,omitempty"`

	// Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV or EntraId.
	// Example: c9f32fcb-4ab7-40fe-af1b-1850d46cfbbe
	TenantID *string `json:"tenant_id,omitempty"`
}

// Validate validates this cifs domain modify collection body
func (o *CifsDomainModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAdDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsDomainInlineDiscoveredServers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsDomainInlinePreferredDcs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsDomainInlineTrustRelationships(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsDomainResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClientCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNameMapping(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePasswordSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServerDiscoveryMode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainModifyCollectionBody) validateAdDomain(formats strfmt.Registry) error {
	if swag.IsZero(o.AdDomain) { // not required
		return nil
	}

	if o.AdDomain != nil {
		if err := o.AdDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ad_domain")
			}
			return err
		}
	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) validateCifsDomainInlineDiscoveredServers(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsDomainInlineDiscoveredServers) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsDomainInlineDiscoveredServers); i++ {
		if swag.IsZero(o.CifsDomainInlineDiscoveredServers[i]) { // not required
			continue
		}

		if o.CifsDomainInlineDiscoveredServers[i] != nil {
			if err := o.CifsDomainInlineDiscoveredServers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "discovered_servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) validateCifsDomainInlinePreferredDcs(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsDomainInlinePreferredDcs) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsDomainInlinePreferredDcs); i++ {
		if swag.IsZero(o.CifsDomainInlinePreferredDcs[i]) { // not required
			continue
		}

		if o.CifsDomainInlinePreferredDcs[i] != nil {
			if err := o.CifsDomainInlinePreferredDcs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "preferred_dcs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) validateCifsDomainInlineTrustRelationships(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsDomainInlineTrustRelationships) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsDomainInlineTrustRelationships); i++ {
		if swag.IsZero(o.CifsDomainInlineTrustRelationships[i]) { // not required
			continue
		}

		if o.CifsDomainInlineTrustRelationships[i] != nil {
			if err := o.CifsDomainInlineTrustRelationships[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "trust_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) validateCifsDomainResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsDomainResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsDomainResponseInlineRecords); i++ {
		if swag.IsZero(o.CifsDomainResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CifsDomainResponseInlineRecords[i] != nil {
			if err := o.CifsDomainResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) validateClientCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.ClientCertificate) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"client_certificate", "body", "password", o.ClientCertificate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) validateNameMapping(formats strfmt.Registry) error {
	if swag.IsZero(o.NameMapping) { // not required
		return nil
	}

	if o.NameMapping != nil {
		if err := o.NameMapping.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "name_mapping")
			}
			return err
		}
	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) validatePasswordSchedule(formats strfmt.Registry) error {
	if swag.IsZero(o.PasswordSchedule) { // not required
		return nil
	}

	if o.PasswordSchedule != nil {
		if err := o.PasswordSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "password_schedule")
			}
			return err
		}
	}

	return nil
}

var cifsDomainModifyCollectionBodyTypeServerDiscoveryModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","site","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsDomainModifyCollectionBodyTypeServerDiscoveryModePropEnum = append(cifsDomainModifyCollectionBodyTypeServerDiscoveryModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CifsDomainModifyCollectionBody
	// CifsDomainModifyCollectionBody
	// server_discovery_mode
	// ServerDiscoveryMode
	// all
	// END DEBUGGING
	// CifsDomainModifyCollectionBodyServerDiscoveryModeAll captures enum value "all"
	CifsDomainModifyCollectionBodyServerDiscoveryModeAll string = "all"

	// BEGIN DEBUGGING
	// CifsDomainModifyCollectionBody
	// CifsDomainModifyCollectionBody
	// server_discovery_mode
	// ServerDiscoveryMode
	// site
	// END DEBUGGING
	// CifsDomainModifyCollectionBodyServerDiscoveryModeSite captures enum value "site"
	CifsDomainModifyCollectionBodyServerDiscoveryModeSite string = "site"

	// BEGIN DEBUGGING
	// CifsDomainModifyCollectionBody
	// CifsDomainModifyCollectionBody
	// server_discovery_mode
	// ServerDiscoveryMode
	// none
	// END DEBUGGING
	// CifsDomainModifyCollectionBodyServerDiscoveryModeNone captures enum value "none"
	CifsDomainModifyCollectionBodyServerDiscoveryModeNone string = "none"
)

// prop value enum
func (o *CifsDomainModifyCollectionBody) validateServerDiscoveryModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsDomainModifyCollectionBodyTypeServerDiscoveryModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsDomainModifyCollectionBody) validateServerDiscoveryMode(formats strfmt.Registry) error {
	if swag.IsZero(o.ServerDiscoveryMode) { // not required
		return nil
	}

	// value enum
	if err := o.validateServerDiscoveryModeEnum("info"+"."+"server_discovery_mode", "body", *o.ServerDiscoveryMode); err != nil {
		return err
	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain modify collection body based on the context it is used
func (o *CifsDomainModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAdDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsDomainInlineDiscoveredServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsDomainInlinePreferredDcs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsDomainInlineTrustRelationships(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsDomainResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNameMapping(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePasswordSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainModifyCollectionBody) contextValidateAdDomain(ctx context.Context, formats strfmt.Registry) error {

	if o.AdDomain != nil {
		if err := o.AdDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ad_domain")
			}
			return err
		}
	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) contextValidateCifsDomainInlineDiscoveredServers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"discovered_servers", "body", []*models.CifsDomainInlineDiscoveredServersInlineArrayItem(o.CifsDomainInlineDiscoveredServers)); err != nil {
		return err
	}

	for i := 0; i < len(o.CifsDomainInlineDiscoveredServers); i++ {

		if o.CifsDomainInlineDiscoveredServers[i] != nil {
			if err := o.CifsDomainInlineDiscoveredServers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "discovered_servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) contextValidateCifsDomainInlinePreferredDcs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"preferred_dcs", "body", []*models.CifsDomainInlinePreferredDcsInlineArrayItem(o.CifsDomainInlinePreferredDcs)); err != nil {
		return err
	}

	for i := 0; i < len(o.CifsDomainInlinePreferredDcs); i++ {

		if o.CifsDomainInlinePreferredDcs[i] != nil {
			if err := o.CifsDomainInlinePreferredDcs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "preferred_dcs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) contextValidateCifsDomainInlineTrustRelationships(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"trust_relationships", "body", []*models.CifsDomainInlineTrustRelationshipsInlineArrayItem(o.CifsDomainInlineTrustRelationships)); err != nil {
		return err
	}

	for i := 0; i < len(o.CifsDomainInlineTrustRelationships); i++ {

		if o.CifsDomainInlineTrustRelationships[i] != nil {
			if err := o.CifsDomainInlineTrustRelationships[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "trust_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) contextValidateCifsDomainResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsDomainResponseInlineRecords); i++ {

		if o.CifsDomainResponseInlineRecords[i] != nil {
			if err := o.CifsDomainResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) contextValidateNameMapping(ctx context.Context, formats strfmt.Registry) error {

	if o.NameMapping != nil {
		if err := o.NameMapping.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "name_mapping")
			}
			return err
		}
	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) contextValidatePasswordSchedule(ctx context.Context, formats strfmt.Registry) error {

	if o.PasswordSchedule != nil {
		if err := o.PasswordSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "password_schedule")
			}
			return err
		}
	}

	return nil
}

func (o *CifsDomainModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res CifsDomainModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineAdDomain Specifies the credentials of a user with permissions to reset the password in the organizational unit for the machine account.
//
swagger:model cifs_domain_inline_ad_domain
*/
type CifsDomainInlineAdDomain struct {

	// The account password of the user with permissions to reset the password in the organizational unit for the machine account.
	//
	Password *string `json:"password,omitempty"`

	// The username of a user with permissions to reset the password in the organizational unit for the machine account.
	//
	User *string `json:"user,omitempty"`
}

// Validate validates this cifs domain inline ad domain
func (o *CifsDomainInlineAdDomain) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cifs domain inline ad domain based on context it is used
func (o *CifsDomainInlineAdDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineAdDomain) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineAdDomain) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineAdDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineDiscoveredServersInlineArrayItem cifs domain inline discovered servers inline array item
swagger:model cifs_domain_inline_discovered_servers_inline_array_item
*/
type CifsDomainInlineDiscoveredServersInlineArrayItem struct {

	// Fully Qualified Domain Name.
	//
	// Example: test.com
	Domain *string `json:"domain,omitempty"`

	// node
	Node *models.CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode `json:"node,omitempty"`

	// Server Preference
	//
	// Enum: ["unknown","preferred","favored","adequate"]
	Preference *string `json:"preference,omitempty"`

	// Server IP address
	//
	ServerIP *string `json:"server_ip,omitempty"`

	// Server Name
	//
	ServerName *string `json:"server_name,omitempty"`

	// Server Type
	//
	// Enum: ["unknown","kerberos","ms_ldap","ms_dc","ldap"]
	ServerType *string `json:"server_type,omitempty"`

	// Server status
	//
	// Enum: ["ok","unavailable","slow","expired","undetermined","unreachable"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cifs domain inline discovered servers inline array item
func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePreference(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServerType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var cifsDomainInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","preferred","favored","adequate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsDomainInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum = append(cifsDomainInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// unknown
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceUnknown captures enum value "unknown"
	CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceUnknown string = "unknown"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// preferred
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemPreferencePreferred captures enum value "preferred"
	CifsDomainInlineDiscoveredServersInlineArrayItemPreferencePreferred string = "preferred"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// favored
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceFavored captures enum value "favored"
	CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceFavored string = "favored"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// adequate
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceAdequate captures enum value "adequate"
	CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceAdequate string = "adequate"
)

// prop value enum
func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) validatePreferenceEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsDomainInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) validatePreference(formats strfmt.Registry) error {
	if swag.IsZero(o.Preference) { // not required
		return nil
	}

	// value enum
	if err := o.validatePreferenceEnum("preference", "body", *o.Preference); err != nil {
		return err
	}

	return nil
}

var cifsDomainInlineDiscoveredServersInlineArrayItemTypeServerTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","kerberos","ms_ldap","ms_dc","ldap"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsDomainInlineDiscoveredServersInlineArrayItemTypeServerTypePropEnum = append(cifsDomainInlineDiscoveredServersInlineArrayItemTypeServerTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// unknown
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeUnknown captures enum value "unknown"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// kerberos
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeKerberos captures enum value "kerberos"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeKerberos string = "kerberos"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// ms_ldap
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeMsLdap captures enum value "ms_ldap"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeMsLdap string = "ms_ldap"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// ms_dc
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeMsDc captures enum value "ms_dc"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeMsDc string = "ms_dc"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// ldap
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeLdap captures enum value "ldap"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeLdap string = "ldap"
)

// prop value enum
func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) validateServerTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsDomainInlineDiscoveredServersInlineArrayItemTypeServerTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) validateServerType(formats strfmt.Registry) error {
	if swag.IsZero(o.ServerType) { // not required
		return nil
	}

	// value enum
	if err := o.validateServerTypeEnum("server_type", "body", *o.ServerType); err != nil {
		return err
	}

	return nil
}

var cifsDomainInlineDiscoveredServersInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","unavailable","slow","expired","undetermined","unreachable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsDomainInlineDiscoveredServersInlineArrayItemTypeStatePropEnum = append(cifsDomainInlineDiscoveredServersInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateOk captures enum value "ok"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// unavailable
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateUnavailable captures enum value "unavailable"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateUnavailable string = "unavailable"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// slow
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateSlow captures enum value "slow"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateSlow string = "slow"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// expired
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateExpired captures enum value "expired"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateExpired string = "expired"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// undetermined
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateUndetermined captures enum value "undetermined"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateUndetermined string = "undetermined"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// unreachable
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateUnreachable captures enum value "unreachable"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateUnreachable string = "unreachable"
)

// prop value enum
func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsDomainInlineDiscoveredServersInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs domain inline discovered servers inline array item based on the context it is used
func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineDiscoveredServersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineDiscoveredServersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode cifs domain inline discovered servers inline array item inline node
swagger:model cifs_domain_inline_discovered_servers_inline_array_item_inline_node
*/
type CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode struct {

	// links
	Links *models.CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs domain inline discovered servers inline array item inline node
func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline discovered servers inline array item inline node based on the context it is used
func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks cifs domain inline discovered servers inline array item inline node inline links
swagger:model cifs_domain_inline_discovered_servers_inline_array_item_inline_node_inline__links
*/
type CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs domain inline discovered servers inline array item inline node inline links
func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline discovered servers inline array item inline node inline links based on the context it is used
func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineNameMapping Specifies the name mapping search records.
//
swagger:model cifs_domain_inline_name_mapping
*/
type CifsDomainInlineNameMapping struct {

	// trusted domains
	TrustedDomains []*string `json:"trusted_domains,omitempty"`
}

// Validate validates this cifs domain inline name mapping
func (o *CifsDomainInlineNameMapping) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs domain inline name mapping based on the context it is used
func (o *CifsDomainInlineNameMapping) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineNameMapping) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineNameMapping) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineNameMapping
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlinePasswordSchedule Specifies the password schedule records.
//
swagger:model cifs_domain_inline_password_schedule
*/
type CifsDomainInlinePasswordSchedule struct {

	// Day of the week for password change schedule.
	// Example: Sunday
	ScheduleDayOfWeek *string `json:"schedule_day_of_week,omitempty"`

	// Schedule description.
	// Read Only: true
	ScheduleDescription *string `json:"schedule_description,omitempty"`

	// Is password schedule enabled.
	ScheduleEnabled *bool `json:"schedule_enabled,omitempty"`

	// Last successful password change time.
	// Read Only: true
	// Format: date-time
	ScheduleLastChangedTime *strfmt.DateTime `json:"schedule_last_changed_time,omitempty"`

	// Minutes within which schedule start can be randomized.
	// Maximum: 180
	// Minimum: 1
	ScheduleRandomizedMinute *int64 `json:"schedule_randomized_minute,omitempty"`

	// Start time for password change schedule.
	// Example: 36900
	ScheduleTimeOfDay *string `json:"schedule_time_of_day,omitempty"`

	// Warning message in case job is deleted.
	// Read Only: true
	ScheduleWarnMessage *string `json:"schedule_warn_message,omitempty"`

	// Interval in weeks for password change schedule.
	// Maximum: 52
	// Minimum: 1
	ScheduleWeeklyInterval *int64 `json:"schedule_weekly_interval,omitempty"`
}

// Validate validates this cifs domain inline password schedule
func (o *CifsDomainInlinePasswordSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateScheduleLastChangedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScheduleRandomizedMinute(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScheduleWeeklyInterval(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlinePasswordSchedule) validateScheduleLastChangedTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ScheduleLastChangedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"password_schedule"+"."+"schedule_last_changed_time", "body", "date-time", o.ScheduleLastChangedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *CifsDomainInlinePasswordSchedule) validateScheduleRandomizedMinute(formats strfmt.Registry) error {
	if swag.IsZero(o.ScheduleRandomizedMinute) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"password_schedule"+"."+"schedule_randomized_minute", "body", *o.ScheduleRandomizedMinute, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"password_schedule"+"."+"schedule_randomized_minute", "body", *o.ScheduleRandomizedMinute, 180, false); err != nil {
		return err
	}

	return nil
}

func (o *CifsDomainInlinePasswordSchedule) validateScheduleWeeklyInterval(formats strfmt.Registry) error {
	if swag.IsZero(o.ScheduleWeeklyInterval) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"password_schedule"+"."+"schedule_weekly_interval", "body", *o.ScheduleWeeklyInterval, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"password_schedule"+"."+"schedule_weekly_interval", "body", *o.ScheduleWeeklyInterval, 52, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs domain inline password schedule based on the context it is used
func (o *CifsDomainInlinePasswordSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateScheduleDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScheduleLastChangedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScheduleWarnMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlinePasswordSchedule) contextValidateScheduleDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"password_schedule"+"."+"schedule_description", "body", o.ScheduleDescription); err != nil {
		return err
	}

	return nil
}

func (o *CifsDomainInlinePasswordSchedule) contextValidateScheduleLastChangedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"password_schedule"+"."+"schedule_last_changed_time", "body", o.ScheduleLastChangedTime); err != nil {
		return err
	}

	return nil
}

func (o *CifsDomainInlinePasswordSchedule) contextValidateScheduleWarnMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"password_schedule"+"."+"schedule_warn_message", "body", o.ScheduleWarnMessage); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlinePasswordSchedule) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlinePasswordSchedule) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlinePasswordSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlinePreferredDcsInlineArrayItem cifs domain inline preferred dcs inline array item
swagger:model cifs_domain_inline_preferred_dcs_inline_array_item
*/
type CifsDomainInlinePreferredDcsInlineArrayItem struct {

	// Fully Qualified Domain Name.
	//
	// Example: test.com
	// Read Only: true
	Fqdn *string `json:"fqdn,omitempty"`

	// IP address of the preferred domain controller (DC). The address can be either an IPv4 or an IPv6 address.
	//
	// Example: 4.4.4.4
	// Read Only: true
	ServerIP *string `json:"server_ip,omitempty"`
}

// Validate validates this cifs domain inline preferred dcs inline array item
func (o *CifsDomainInlinePreferredDcsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs domain inline preferred dcs inline array item based on the context it is used
func (o *CifsDomainInlinePreferredDcsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFqdn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServerIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlinePreferredDcsInlineArrayItem) contextValidateFqdn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fqdn", "body", o.Fqdn); err != nil {
		return err
	}

	return nil
}

func (o *CifsDomainInlinePreferredDcsInlineArrayItem) contextValidateServerIP(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "server_ip", "body", o.ServerIP); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlinePreferredDcsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlinePreferredDcsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlinePreferredDcsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model cifs_domain_inline_svm
*/
type CifsDomainInlineSvm struct {

	// links
	Links *models.CifsDomainInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs domain inline svm
func (o *CifsDomainInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline svm based on the context it is used
func (o *CifsDomainInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineSvmInlineLinks cifs domain inline svm inline links
swagger:model cifs_domain_inline_svm_inline__links
*/
type CifsDomainInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs domain inline svm inline links
func (o *CifsDomainInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline svm inline links based on the context it is used
func (o *CifsDomainInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineTrustRelationshipsInlineArrayItem cifs domain inline trust relationships inline array item
swagger:model cifs_domain_inline_trust_relationships_inline_array_item
*/
type CifsDomainInlineTrustRelationshipsInlineArrayItem struct {

	// Home Domain Name
	//
	HomeDomain *string `json:"home_domain,omitempty"`

	// node
	Node *models.CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode `json:"node,omitempty"`

	// Trusted Domain Name
	//
	TrustedDomains []*string `json:"trusted_domains"`
}

// Validate validates this cifs domain inline trust relationships inline array item
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineTrustRelationshipsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline trust relationships inline array item based on the context it is used
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineTrustRelationshipsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineTrustRelationshipsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode cifs domain inline trust relationships inline array item inline node
swagger:model cifs_domain_inline_trust_relationships_inline_array_item_inline_node
*/
type CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode struct {

	// links
	Links *models.CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs domain inline trust relationships inline array item inline node
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline trust relationships inline array item inline node based on the context it is used
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks cifs domain inline trust relationships inline array item inline node inline links
swagger:model cifs_domain_inline_trust_relationships_inline_array_item_inline_node_inline__links
*/
type CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs domain inline trust relationships inline array item inline node inline links
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline trust relationships inline array item inline node inline links based on the context it is used
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
