// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewCifsDomainModifyParams creates a new CifsDomainModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsDomainModifyParams() *CifsDomainModifyParams {
	return &CifsDomainModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsDomainModifyParamsWithTimeout creates a new CifsDomainModifyParams object
// with the ability to set a timeout on a request.
func NewCifsDomainModifyParamsWithTimeout(timeout time.Duration) *CifsDomainModifyParams {
	return &CifsDomainModifyParams{
		timeout: timeout,
	}
}

// NewCifsDomainModifyParamsWithContext creates a new CifsDomainModifyParams object
// with the ability to set a context for a request.
func NewCifsDomainModifyParamsWithContext(ctx context.Context) *CifsDomainModifyParams {
	return &CifsDomainModifyParams{
		Context: ctx,
	}
}

// NewCifsDomainModifyParamsWithHTTPClient creates a new CifsDomainModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsDomainModifyParamsWithHTTPClient(client *http.Client) *CifsDomainModifyParams {
	return &CifsDomainModifyParams{
		HTTPClient: client,
	}
}

/*
CifsDomainModifyParams contains all the parameters to send to the API endpoint

	for the cifs domain modify operation.

	Typically these are written to a http.Request.
*/
type CifsDomainModifyParams struct {

	/* CifsPasswordOperation.

	   Specifies the operation to be performed on the domain password.
	*/
	CifsPasswordOperation *string

	/* Info.

	   Info specification
	*/
	Info *models.CifsDomain

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs domain modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsDomainModifyParams) WithDefaults() *CifsDomainModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs domain modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsDomainModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the cifs domain modify params
func (o *CifsDomainModifyParams) WithTimeout(timeout time.Duration) *CifsDomainModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs domain modify params
func (o *CifsDomainModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs domain modify params
func (o *CifsDomainModifyParams) WithContext(ctx context.Context) *CifsDomainModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs domain modify params
func (o *CifsDomainModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs domain modify params
func (o *CifsDomainModifyParams) WithHTTPClient(client *http.Client) *CifsDomainModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs domain modify params
func (o *CifsDomainModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCifsPasswordOperation adds the cifsPasswordOperation to the cifs domain modify params
func (o *CifsDomainModifyParams) WithCifsPasswordOperation(cifsPasswordOperation *string) *CifsDomainModifyParams {
	o.SetCifsPasswordOperation(cifsPasswordOperation)
	return o
}

// SetCifsPasswordOperation adds the cifsPasswordOperation to the cifs domain modify params
func (o *CifsDomainModifyParams) SetCifsPasswordOperation(cifsPasswordOperation *string) {
	o.CifsPasswordOperation = cifsPasswordOperation
}

// WithInfo adds the info to the cifs domain modify params
func (o *CifsDomainModifyParams) WithInfo(info *models.CifsDomain) *CifsDomainModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cifs domain modify params
func (o *CifsDomainModifyParams) SetInfo(info *models.CifsDomain) {
	o.Info = info
}

// WithSvmUUID adds the svmUUID to the cifs domain modify params
func (o *CifsDomainModifyParams) WithSvmUUID(svmUUID string) *CifsDomainModifyParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs domain modify params
func (o *CifsDomainModifyParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsDomainModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CifsPasswordOperation != nil {

		// query param cifs_password_operation
		var qrCifsPasswordOperation string

		if o.CifsPasswordOperation != nil {
			qrCifsPasswordOperation = *o.CifsPasswordOperation
		}
		qCifsPasswordOperation := qrCifsPasswordOperation
		if qCifsPasswordOperation != "" {

			if err := r.SetQueryParam("cifs_password_operation", qCifsPasswordOperation); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
