// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsDomainModifyReader is a Reader for the CifsDomainModify structure.
type CifsDomainModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsDomainModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsDomainModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsDomainModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsDomainModifyOK creates a CifsDomainModifyOK with default headers values
func NewCifsDomainModifyOK() *CifsDomainModifyOK {
	return &CifsDomainModifyOK{}
}

/*
CifsDomainModifyOK describes a response with status code 200, with default header values.

OK
*/
type CifsDomainModifyOK struct {
}

// IsSuccess returns true when this cifs domain modify o k response has a 2xx status code
func (o *CifsDomainModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs domain modify o k response has a 3xx status code
func (o *CifsDomainModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs domain modify o k response has a 4xx status code
func (o *CifsDomainModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs domain modify o k response has a 5xx status code
func (o *CifsDomainModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs domain modify o k response a status code equal to that given
func (o *CifsDomainModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs domain modify o k response
func (o *CifsDomainModifyOK) Code() int {
	return 200
}

func (o *CifsDomainModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/domains/{svm.uuid}][%d] cifsDomainModifyOK", 200)
}

func (o *CifsDomainModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/domains/{svm.uuid}][%d] cifsDomainModifyOK", 200)
}

func (o *CifsDomainModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsDomainModifyDefault creates a CifsDomainModifyDefault with default headers values
func NewCifsDomainModifyDefault(code int) *CifsDomainModifyDefault {
	return &CifsDomainModifyDefault{
		_statusCode: code,
	}
}

/*
	CifsDomainModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
|  262278    | Domain user and password are required fields. |
|  655513    | Password update failed due to invalid credentials. |
|  656392    | Preferred DC's need to be configured if CIFS discovery mode is set to none. |
|  656393    | Default site needs to be configured if CIFS discovery mode is set to site.  |
|  656487    | Missing fields when doing CIFS operation with hybrid auth user type. |
*/
type CifsDomainModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs domain modify default response has a 2xx status code
func (o *CifsDomainModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs domain modify default response has a 3xx status code
func (o *CifsDomainModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs domain modify default response has a 4xx status code
func (o *CifsDomainModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs domain modify default response has a 5xx status code
func (o *CifsDomainModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs domain modify default response a status code equal to that given
func (o *CifsDomainModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs domain modify default response
func (o *CifsDomainModifyDefault) Code() int {
	return o._statusCode
}

func (o *CifsDomainModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/domains/{svm.uuid}][%d] cifs_domain_modify default %s", o._statusCode, payload)
}

func (o *CifsDomainModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/domains/{svm.uuid}][%d] cifs_domain_modify default %s", o._statusCode, payload)
}

func (o *CifsDomainModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsDomainModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
