// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsDomainPreferredDcDeleteCollectionReader is a Reader for the CifsDomainPreferredDcDeleteCollection structure.
type CifsDomainPreferredDcDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsDomainPreferredDcDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsDomainPreferredDcDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsDomainPreferredDcDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsDomainPreferredDcDeleteCollectionOK creates a CifsDomainPreferredDcDeleteCollectionOK with default headers values
func NewCifsDomainPreferredDcDeleteCollectionOK() *CifsDomainPreferredDcDeleteCollectionOK {
	return &CifsDomainPreferredDcDeleteCollectionOK{}
}

/*
CifsDomainPreferredDcDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CifsDomainPreferredDcDeleteCollectionOK struct {
}

// IsSuccess returns true when this cifs domain preferred dc delete collection o k response has a 2xx status code
func (o *CifsDomainPreferredDcDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs domain preferred dc delete collection o k response has a 3xx status code
func (o *CifsDomainPreferredDcDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs domain preferred dc delete collection o k response has a 4xx status code
func (o *CifsDomainPreferredDcDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs domain preferred dc delete collection o k response has a 5xx status code
func (o *CifsDomainPreferredDcDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs domain preferred dc delete collection o k response a status code equal to that given
func (o *CifsDomainPreferredDcDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs domain preferred dc delete collection o k response
func (o *CifsDomainPreferredDcDeleteCollectionOK) Code() int {
	return 200
}

func (o *CifsDomainPreferredDcDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers][%d] cifsDomainPreferredDcDeleteCollectionOK", 200)
}

func (o *CifsDomainPreferredDcDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers][%d] cifsDomainPreferredDcDeleteCollectionOK", 200)
}

func (o *CifsDomainPreferredDcDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsDomainPreferredDcDeleteCollectionDefault creates a CifsDomainPreferredDcDeleteCollectionDefault with default headers values
func NewCifsDomainPreferredDcDeleteCollectionDefault(code int) *CifsDomainPreferredDcDeleteCollectionDefault {
	return &CifsDomainPreferredDcDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	CifsDomainPreferredDcDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655507     | Failed to remove preferred-dc. |
*/
type CifsDomainPreferredDcDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs domain preferred dc delete collection default response has a 2xx status code
func (o *CifsDomainPreferredDcDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs domain preferred dc delete collection default response has a 3xx status code
func (o *CifsDomainPreferredDcDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs domain preferred dc delete collection default response has a 4xx status code
func (o *CifsDomainPreferredDcDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs domain preferred dc delete collection default response has a 5xx status code
func (o *CifsDomainPreferredDcDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs domain preferred dc delete collection default response a status code equal to that given
func (o *CifsDomainPreferredDcDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs domain preferred dc delete collection default response
func (o *CifsDomainPreferredDcDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CifsDomainPreferredDcDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers][%d] cifs_domain_preferred_dc_delete_collection default %s", o._statusCode, payload)
}

func (o *CifsDomainPreferredDcDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers][%d] cifs_domain_preferred_dc_delete_collection default %s", o._statusCode, payload)
}

func (o *CifsDomainPreferredDcDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsDomainPreferredDcDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CifsDomainPreferredDcDeleteCollectionBody cifs domain preferred dc delete collection body
swagger:model CifsDomainPreferredDcDeleteCollectionBody
*/
type CifsDomainPreferredDcDeleteCollectionBody struct {

	// cifs domain preferred dc response inline records
	CifsDomainPreferredDcResponseInlineRecords []*models.CifsDomainPreferredDc `json:"records,omitempty"`
}

// Validate validates this cifs domain preferred dc delete collection body
func (o *CifsDomainPreferredDcDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifsDomainPreferredDcResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainPreferredDcDeleteCollectionBody) validateCifsDomainPreferredDcResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsDomainPreferredDcResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsDomainPreferredDcResponseInlineRecords); i++ {
		if swag.IsZero(o.CifsDomainPreferredDcResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CifsDomainPreferredDcResponseInlineRecords[i] != nil {
			if err := o.CifsDomainPreferredDcResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cifs domain preferred dc delete collection body based on the context it is used
func (o *CifsDomainPreferredDcDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifsDomainPreferredDcResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsDomainPreferredDcDeleteCollectionBody) contextValidateCifsDomainPreferredDcResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsDomainPreferredDcResponseInlineRecords); i++ {

		if o.CifsDomainPreferredDcResponseInlineRecords[i] != nil {
			if err := o.CifsDomainPreferredDcResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsDomainPreferredDcDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsDomainPreferredDcDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res CifsDomainPreferredDcDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
