// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsOpenFileCollectionGetParams creates a new CifsOpenFileCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsOpenFileCollectionGetParams() *CifsOpenFileCollectionGetParams {
	return &CifsOpenFileCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsOpenFileCollectionGetParamsWithTimeout creates a new CifsOpenFileCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCifsOpenFileCollectionGetParamsWithTimeout(timeout time.Duration) *CifsOpenFileCollectionGetParams {
	return &CifsOpenFileCollectionGetParams{
		timeout: timeout,
	}
}

// NewCifsOpenFileCollectionGetParamsWithContext creates a new CifsOpenFileCollectionGetParams object
// with the ability to set a context for a request.
func NewCifsOpenFileCollectionGetParamsWithContext(ctx context.Context) *CifsOpenFileCollectionGetParams {
	return &CifsOpenFileCollectionGetParams{
		Context: ctx,
	}
}

// NewCifsOpenFileCollectionGetParamsWithHTTPClient creates a new CifsOpenFileCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsOpenFileCollectionGetParamsWithHTTPClient(client *http.Client) *CifsOpenFileCollectionGetParams {
	return &CifsOpenFileCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CifsOpenFileCollectionGetParams contains all the parameters to send to the API endpoint

	for the cifs open file collection get operation.

	Typically these are written to a http.Request.
*/
type CifsOpenFileCollectionGetParams struct {

	/* ConnectionCount.

	   Filter by connection.count
	*/
	ConnectionCount *int64

	/* ConnectionIdentifier.

	   Filter by connection.identifier
	*/
	ConnectionIdentifier *int64

	/* ContinuouslyAvailable.

	   Filter by continuously_available
	*/
	ContinuouslyAvailable *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Identifier.

	   Filter by identifier
	*/
	Identifier *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OpenMode.

	   Filter by open_mode
	*/
	OpenMode *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Path.

	   Filter by path
	*/
	Path *string

	/* RangeLocksCount.

	   Filter by range_locks_count
	*/
	RangeLocksCount *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SessionIdentifier.

	   Filter by session.identifier
	*/
	SessionIdentifier *int64

	/* ShareMode.

	   Filter by share.mode
	*/
	ShareMode *string

	/* ShareName.

	   Filter by share.name
	*/
	ShareName *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs open file collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsOpenFileCollectionGetParams) WithDefaults() *CifsOpenFileCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs open file collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsOpenFileCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CifsOpenFileCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithTimeout(timeout time.Duration) *CifsOpenFileCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithContext(ctx context.Context) *CifsOpenFileCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithHTTPClient(client *http.Client) *CifsOpenFileCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConnectionCount adds the connectionCount to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithConnectionCount(connectionCount *int64) *CifsOpenFileCollectionGetParams {
	o.SetConnectionCount(connectionCount)
	return o
}

// SetConnectionCount adds the connectionCount to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetConnectionCount(connectionCount *int64) {
	o.ConnectionCount = connectionCount
}

// WithConnectionIdentifier adds the connectionIdentifier to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithConnectionIdentifier(connectionIdentifier *int64) *CifsOpenFileCollectionGetParams {
	o.SetConnectionIdentifier(connectionIdentifier)
	return o
}

// SetConnectionIdentifier adds the connectionIdentifier to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetConnectionIdentifier(connectionIdentifier *int64) {
	o.ConnectionIdentifier = connectionIdentifier
}

// WithContinuouslyAvailable adds the continuouslyAvailable to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithContinuouslyAvailable(continuouslyAvailable *string) *CifsOpenFileCollectionGetParams {
	o.SetContinuouslyAvailable(continuouslyAvailable)
	return o
}

// SetContinuouslyAvailable adds the continuouslyAvailable to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetContinuouslyAvailable(continuouslyAvailable *string) {
	o.ContinuouslyAvailable = continuouslyAvailable
}

// WithFields adds the fields to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithFields(fields []string) *CifsOpenFileCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIdentifier adds the identifier to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithIdentifier(identifier *int64) *CifsOpenFileCollectionGetParams {
	o.SetIdentifier(identifier)
	return o
}

// SetIdentifier adds the identifier to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetIdentifier(identifier *int64) {
	o.Identifier = identifier
}

// WithMaxRecords adds the maxRecords to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithMaxRecords(maxRecords *int64) *CifsOpenFileCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithNodeName(nodeName *string) *CifsOpenFileCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithNodeUUID(nodeUUID *string) *CifsOpenFileCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOpenMode adds the openMode to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithOpenMode(openMode *string) *CifsOpenFileCollectionGetParams {
	o.SetOpenMode(openMode)
	return o
}

// SetOpenMode adds the openMode to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetOpenMode(openMode *string) {
	o.OpenMode = openMode
}

// WithOrderBy adds the orderBy to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithOrderBy(orderBy []string) *CifsOpenFileCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPath adds the path to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithPath(path *string) *CifsOpenFileCollectionGetParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetPath(path *string) {
	o.Path = path
}

// WithRangeLocksCount adds the rangeLocksCount to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithRangeLocksCount(rangeLocksCount *int64) *CifsOpenFileCollectionGetParams {
	o.SetRangeLocksCount(rangeLocksCount)
	return o
}

// SetRangeLocksCount adds the rangeLocksCount to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetRangeLocksCount(rangeLocksCount *int64) {
	o.RangeLocksCount = rangeLocksCount
}

// WithReturnRecords adds the returnRecords to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithReturnRecords(returnRecords *bool) *CifsOpenFileCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CifsOpenFileCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSessionIdentifier adds the sessionIdentifier to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithSessionIdentifier(sessionIdentifier *int64) *CifsOpenFileCollectionGetParams {
	o.SetSessionIdentifier(sessionIdentifier)
	return o
}

// SetSessionIdentifier adds the sessionIdentifier to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetSessionIdentifier(sessionIdentifier *int64) {
	o.SessionIdentifier = sessionIdentifier
}

// WithShareMode adds the shareMode to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithShareMode(shareMode *string) *CifsOpenFileCollectionGetParams {
	o.SetShareMode(shareMode)
	return o
}

// SetShareMode adds the shareMode to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetShareMode(shareMode *string) {
	o.ShareMode = shareMode
}

// WithShareName adds the shareName to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithShareName(shareName *string) *CifsOpenFileCollectionGetParams {
	o.SetShareName(shareName)
	return o
}

// SetShareName adds the shareName to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetShareName(shareName *string) {
	o.ShareName = shareName
}

// WithSvmName adds the svmName to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithSvmName(svmName *string) *CifsOpenFileCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithSvmUUID(svmUUID *string) *CifsOpenFileCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithType(typeVar *string) *CifsOpenFileCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithVolumeName adds the volumeName to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithVolumeName(volumeName *string) *CifsOpenFileCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) WithVolumeUUID(volumeUUID *string) *CifsOpenFileCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the cifs open file collection get params
func (o *CifsOpenFileCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsOpenFileCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ConnectionCount != nil {

		// query param connection.count
		var qrConnectionCount int64

		if o.ConnectionCount != nil {
			qrConnectionCount = *o.ConnectionCount
		}
		qConnectionCount := swag.FormatInt64(qrConnectionCount)
		if qConnectionCount != "" {

			if err := r.SetQueryParam("connection.count", qConnectionCount); err != nil {
				return err
			}
		}
	}

	if o.ConnectionIdentifier != nil {

		// query param connection.identifier
		var qrConnectionIdentifier int64

		if o.ConnectionIdentifier != nil {
			qrConnectionIdentifier = *o.ConnectionIdentifier
		}
		qConnectionIdentifier := swag.FormatInt64(qrConnectionIdentifier)
		if qConnectionIdentifier != "" {

			if err := r.SetQueryParam("connection.identifier", qConnectionIdentifier); err != nil {
				return err
			}
		}
	}

	if o.ContinuouslyAvailable != nil {

		// query param continuously_available
		var qrContinuouslyAvailable string

		if o.ContinuouslyAvailable != nil {
			qrContinuouslyAvailable = *o.ContinuouslyAvailable
		}
		qContinuouslyAvailable := qrContinuouslyAvailable
		if qContinuouslyAvailable != "" {

			if err := r.SetQueryParam("continuously_available", qContinuouslyAvailable); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Identifier != nil {

		// query param identifier
		var qrIdentifier int64

		if o.Identifier != nil {
			qrIdentifier = *o.Identifier
		}
		qIdentifier := swag.FormatInt64(qrIdentifier)
		if qIdentifier != "" {

			if err := r.SetQueryParam("identifier", qIdentifier); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OpenMode != nil {

		// query param open_mode
		var qrOpenMode string

		if o.OpenMode != nil {
			qrOpenMode = *o.OpenMode
		}
		qOpenMode := qrOpenMode
		if qOpenMode != "" {

			if err := r.SetQueryParam("open_mode", qOpenMode); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Path != nil {

		// query param path
		var qrPath string

		if o.Path != nil {
			qrPath = *o.Path
		}
		qPath := qrPath
		if qPath != "" {

			if err := r.SetQueryParam("path", qPath); err != nil {
				return err
			}
		}
	}

	if o.RangeLocksCount != nil {

		// query param range_locks_count
		var qrRangeLocksCount int64

		if o.RangeLocksCount != nil {
			qrRangeLocksCount = *o.RangeLocksCount
		}
		qRangeLocksCount := swag.FormatInt64(qrRangeLocksCount)
		if qRangeLocksCount != "" {

			if err := r.SetQueryParam("range_locks_count", qRangeLocksCount); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SessionIdentifier != nil {

		// query param session.identifier
		var qrSessionIdentifier int64

		if o.SessionIdentifier != nil {
			qrSessionIdentifier = *o.SessionIdentifier
		}
		qSessionIdentifier := swag.FormatInt64(qrSessionIdentifier)
		if qSessionIdentifier != "" {

			if err := r.SetQueryParam("session.identifier", qSessionIdentifier); err != nil {
				return err
			}
		}
	}

	if o.ShareMode != nil {

		// query param share.mode
		var qrShareMode string

		if o.ShareMode != nil {
			qrShareMode = *o.ShareMode
		}
		qShareMode := qrShareMode
		if qShareMode != "" {

			if err := r.SetQueryParam("share.mode", qShareMode); err != nil {
				return err
			}
		}
	}

	if o.ShareName != nil {

		// query param share.name
		var qrShareName string

		if o.ShareName != nil {
			qrShareName = *o.ShareName
		}
		qShareName := qrShareName
		if qShareName != "" {

			if err := r.SetQueryParam("share.name", qShareName); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCifsOpenFileCollectionGet binds the parameter fields
func (o *CifsOpenFileCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCifsOpenFileCollectionGet binds the parameter order_by
func (o *CifsOpenFileCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
