// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsOpenFileCollectionGetReader is a Reader for the CifsOpenFileCollectionGet structure.
type CifsOpenFileCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsOpenFileCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsOpenFileCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsOpenFileCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsOpenFileCollectionGetOK creates a CifsOpenFileCollectionGetOK with default headers values
func NewCifsOpenFileCollectionGetOK() *CifsOpenFileCollectionGetOK {
	return &CifsOpenFileCollectionGetOK{}
}

/*
CifsOpenFileCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type CifsOpenFileCollectionGetOK struct {
	Payload *models.CifsOpenFileResponse
}

// IsSuccess returns true when this cifs open file collection get o k response has a 2xx status code
func (o *CifsOpenFileCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs open file collection get o k response has a 3xx status code
func (o *CifsOpenFileCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs open file collection get o k response has a 4xx status code
func (o *CifsOpenFileCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs open file collection get o k response has a 5xx status code
func (o *CifsOpenFileCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs open file collection get o k response a status code equal to that given
func (o *CifsOpenFileCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs open file collection get o k response
func (o *CifsOpenFileCollectionGetOK) Code() int {
	return 200
}

func (o *CifsOpenFileCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/session/files][%d] cifsOpenFileCollectionGetOK %s", 200, payload)
}

func (o *CifsOpenFileCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/session/files][%d] cifsOpenFileCollectionGetOK %s", 200, payload)
}

func (o *CifsOpenFileCollectionGetOK) GetPayload() *models.CifsOpenFileResponse {
	return o.Payload
}

func (o *CifsOpenFileCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CifsOpenFileResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCifsOpenFileCollectionGetDefault creates a CifsOpenFileCollectionGetDefault with default headers values
func NewCifsOpenFileCollectionGetDefault(code int) *CifsOpenFileCollectionGetDefault {
	return &CifsOpenFileCollectionGetDefault{
		_statusCode: code,
	}
}

/*
CifsOpenFileCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type CifsOpenFileCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs open file collection get default response has a 2xx status code
func (o *CifsOpenFileCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs open file collection get default response has a 3xx status code
func (o *CifsOpenFileCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs open file collection get default response has a 4xx status code
func (o *CifsOpenFileCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs open file collection get default response has a 5xx status code
func (o *CifsOpenFileCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs open file collection get default response a status code equal to that given
func (o *CifsOpenFileCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs open file collection get default response
func (o *CifsOpenFileCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *CifsOpenFileCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/session/files][%d] cifs_open_file_collection_get default %s", o._statusCode, payload)
}

func (o *CifsOpenFileCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/cifs/session/files][%d] cifs_open_file_collection_get default %s", o._statusCode, payload)
}

func (o *CifsOpenFileCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsOpenFileCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
