// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsOpenFileDeleteCollectionParams creates a new CifsOpenFileDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsOpenFileDeleteCollectionParams() *CifsOpenFileDeleteCollectionParams {
	return &CifsOpenFileDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsOpenFileDeleteCollectionParamsWithTimeout creates a new CifsOpenFileDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewCifsOpenFileDeleteCollectionParamsWithTimeout(timeout time.Duration) *CifsOpenFileDeleteCollectionParams {
	return &CifsOpenFileDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewCifsOpenFileDeleteCollectionParamsWithContext creates a new CifsOpenFileDeleteCollectionParams object
// with the ability to set a context for a request.
func NewCifsOpenFileDeleteCollectionParamsWithContext(ctx context.Context) *CifsOpenFileDeleteCollectionParams {
	return &CifsOpenFileDeleteCollectionParams{
		Context: ctx,
	}
}

// NewCifsOpenFileDeleteCollectionParamsWithHTTPClient creates a new CifsOpenFileDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsOpenFileDeleteCollectionParamsWithHTTPClient(client *http.Client) *CifsOpenFileDeleteCollectionParams {
	return &CifsOpenFileDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
CifsOpenFileDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the cifs open file delete collection operation.

	Typically these are written to a http.Request.
*/
type CifsOpenFileDeleteCollectionParams struct {

	/* ConnectionCount.

	   Filter by connection.count
	*/
	ConnectionCount *int64

	/* ConnectionIdentifier.

	   Filter by connection.identifier
	*/
	ConnectionIdentifier *int64

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* ContinuouslyAvailable.

	   Filter by continuously_available
	*/
	ContinuouslyAvailable *string

	/* Identifier.

	   Filter by identifier
	*/
	Identifier *int64

	/* Info.

	   Info specification
	*/
	Info CifsOpenFileDeleteCollectionBody

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OpenMode.

	   Filter by open_mode
	*/
	OpenMode *string

	/* Path.

	   Filter by path
	*/
	Path *string

	/* RangeLocksCount.

	   Filter by range_locks_count
	*/
	RangeLocksCount *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SessionIdentifier.

	   Filter by session.identifier
	*/
	SessionIdentifier *int64

	/* ShareMode.

	   Filter by share.mode
	*/
	ShareMode *string

	/* ShareName.

	   Filter by share.name
	*/
	ShareName *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs open file delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsOpenFileDeleteCollectionParams) WithDefaults() *CifsOpenFileDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs open file delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsOpenFileDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CifsOpenFileDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithTimeout(timeout time.Duration) *CifsOpenFileDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithContext(ctx context.Context) *CifsOpenFileDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithHTTPClient(client *http.Client) *CifsOpenFileDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConnectionCount adds the connectionCount to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithConnectionCount(connectionCount *int64) *CifsOpenFileDeleteCollectionParams {
	o.SetConnectionCount(connectionCount)
	return o
}

// SetConnectionCount adds the connectionCount to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetConnectionCount(connectionCount *int64) {
	o.ConnectionCount = connectionCount
}

// WithConnectionIdentifier adds the connectionIdentifier to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithConnectionIdentifier(connectionIdentifier *int64) *CifsOpenFileDeleteCollectionParams {
	o.SetConnectionIdentifier(connectionIdentifier)
	return o
}

// SetConnectionIdentifier adds the connectionIdentifier to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetConnectionIdentifier(connectionIdentifier *int64) {
	o.ConnectionIdentifier = connectionIdentifier
}

// WithContinueOnFailure adds the continueOnFailure to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CifsOpenFileDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithContinuouslyAvailable adds the continuouslyAvailable to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithContinuouslyAvailable(continuouslyAvailable *string) *CifsOpenFileDeleteCollectionParams {
	o.SetContinuouslyAvailable(continuouslyAvailable)
	return o
}

// SetContinuouslyAvailable adds the continuouslyAvailable to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetContinuouslyAvailable(continuouslyAvailable *string) {
	o.ContinuouslyAvailable = continuouslyAvailable
}

// WithIdentifier adds the identifier to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithIdentifier(identifier *int64) *CifsOpenFileDeleteCollectionParams {
	o.SetIdentifier(identifier)
	return o
}

// SetIdentifier adds the identifier to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetIdentifier(identifier *int64) {
	o.Identifier = identifier
}

// WithInfo adds the info to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithInfo(info CifsOpenFileDeleteCollectionBody) *CifsOpenFileDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetInfo(info CifsOpenFileDeleteCollectionBody) {
	o.Info = info
}

// WithNodeName adds the nodeName to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithNodeName(nodeName *string) *CifsOpenFileDeleteCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithNodeUUID(nodeUUID *string) *CifsOpenFileDeleteCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOpenMode adds the openMode to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithOpenMode(openMode *string) *CifsOpenFileDeleteCollectionParams {
	o.SetOpenMode(openMode)
	return o
}

// SetOpenMode adds the openMode to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetOpenMode(openMode *string) {
	o.OpenMode = openMode
}

// WithPath adds the path to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithPath(path *string) *CifsOpenFileDeleteCollectionParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetPath(path *string) {
	o.Path = path
}

// WithRangeLocksCount adds the rangeLocksCount to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithRangeLocksCount(rangeLocksCount *int64) *CifsOpenFileDeleteCollectionParams {
	o.SetRangeLocksCount(rangeLocksCount)
	return o
}

// SetRangeLocksCount adds the rangeLocksCount to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetRangeLocksCount(rangeLocksCount *int64) {
	o.RangeLocksCount = rangeLocksCount
}

// WithReturnRecords adds the returnRecords to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *CifsOpenFileDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *CifsOpenFileDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *CifsOpenFileDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSessionIdentifier adds the sessionIdentifier to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithSessionIdentifier(sessionIdentifier *int64) *CifsOpenFileDeleteCollectionParams {
	o.SetSessionIdentifier(sessionIdentifier)
	return o
}

// SetSessionIdentifier adds the sessionIdentifier to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetSessionIdentifier(sessionIdentifier *int64) {
	o.SessionIdentifier = sessionIdentifier
}

// WithShareMode adds the shareMode to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithShareMode(shareMode *string) *CifsOpenFileDeleteCollectionParams {
	o.SetShareMode(shareMode)
	return o
}

// SetShareMode adds the shareMode to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetShareMode(shareMode *string) {
	o.ShareMode = shareMode
}

// WithShareName adds the shareName to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithShareName(shareName *string) *CifsOpenFileDeleteCollectionParams {
	o.SetShareName(shareName)
	return o
}

// SetShareName adds the shareName to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetShareName(shareName *string) {
	o.ShareName = shareName
}

// WithSvmName adds the svmName to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithSvmName(svmName *string) *CifsOpenFileDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithSvmUUID(svmUUID *string) *CifsOpenFileDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithType(typeVar *string) *CifsOpenFileDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithVolumeName adds the volumeName to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithVolumeName(volumeName *string) *CifsOpenFileDeleteCollectionParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) WithVolumeUUID(volumeUUID *string) *CifsOpenFileDeleteCollectionParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the cifs open file delete collection params
func (o *CifsOpenFileDeleteCollectionParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsOpenFileDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ConnectionCount != nil {

		// query param connection.count
		var qrConnectionCount int64

		if o.ConnectionCount != nil {
			qrConnectionCount = *o.ConnectionCount
		}
		qConnectionCount := swag.FormatInt64(qrConnectionCount)
		if qConnectionCount != "" {

			if err := r.SetQueryParam("connection.count", qConnectionCount); err != nil {
				return err
			}
		}
	}

	if o.ConnectionIdentifier != nil {

		// query param connection.identifier
		var qrConnectionIdentifier int64

		if o.ConnectionIdentifier != nil {
			qrConnectionIdentifier = *o.ConnectionIdentifier
		}
		qConnectionIdentifier := swag.FormatInt64(qrConnectionIdentifier)
		if qConnectionIdentifier != "" {

			if err := r.SetQueryParam("connection.identifier", qConnectionIdentifier); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.ContinuouslyAvailable != nil {

		// query param continuously_available
		var qrContinuouslyAvailable string

		if o.ContinuouslyAvailable != nil {
			qrContinuouslyAvailable = *o.ContinuouslyAvailable
		}
		qContinuouslyAvailable := qrContinuouslyAvailable
		if qContinuouslyAvailable != "" {

			if err := r.SetQueryParam("continuously_available", qContinuouslyAvailable); err != nil {
				return err
			}
		}
	}

	if o.Identifier != nil {

		// query param identifier
		var qrIdentifier int64

		if o.Identifier != nil {
			qrIdentifier = *o.Identifier
		}
		qIdentifier := swag.FormatInt64(qrIdentifier)
		if qIdentifier != "" {

			if err := r.SetQueryParam("identifier", qIdentifier); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OpenMode != nil {

		// query param open_mode
		var qrOpenMode string

		if o.OpenMode != nil {
			qrOpenMode = *o.OpenMode
		}
		qOpenMode := qrOpenMode
		if qOpenMode != "" {

			if err := r.SetQueryParam("open_mode", qOpenMode); err != nil {
				return err
			}
		}
	}

	if o.Path != nil {

		// query param path
		var qrPath string

		if o.Path != nil {
			qrPath = *o.Path
		}
		qPath := qrPath
		if qPath != "" {

			if err := r.SetQueryParam("path", qPath); err != nil {
				return err
			}
		}
	}

	if o.RangeLocksCount != nil {

		// query param range_locks_count
		var qrRangeLocksCount int64

		if o.RangeLocksCount != nil {
			qrRangeLocksCount = *o.RangeLocksCount
		}
		qRangeLocksCount := swag.FormatInt64(qrRangeLocksCount)
		if qRangeLocksCount != "" {

			if err := r.SetQueryParam("range_locks_count", qRangeLocksCount); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SessionIdentifier != nil {

		// query param session.identifier
		var qrSessionIdentifier int64

		if o.SessionIdentifier != nil {
			qrSessionIdentifier = *o.SessionIdentifier
		}
		qSessionIdentifier := swag.FormatInt64(qrSessionIdentifier)
		if qSessionIdentifier != "" {

			if err := r.SetQueryParam("session.identifier", qSessionIdentifier); err != nil {
				return err
			}
		}
	}

	if o.ShareMode != nil {

		// query param share.mode
		var qrShareMode string

		if o.ShareMode != nil {
			qrShareMode = *o.ShareMode
		}
		qShareMode := qrShareMode
		if qShareMode != "" {

			if err := r.SetQueryParam("share.mode", qShareMode); err != nil {
				return err
			}
		}
	}

	if o.ShareName != nil {

		// query param share.name
		var qrShareName string

		if o.ShareName != nil {
			qrShareName = *o.ShareName
		}
		qShareName := qrShareName
		if qShareName != "" {

			if err := r.SetQueryParam("share.name", qShareName); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
