// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsOpenFileDeleteParams creates a new CifsOpenFileDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsOpenFileDeleteParams() *CifsOpenFileDeleteParams {
	return &CifsOpenFileDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsOpenFileDeleteParamsWithTimeout creates a new CifsOpenFileDeleteParams object
// with the ability to set a timeout on a request.
func NewCifsOpenFileDeleteParamsWithTimeout(timeout time.Duration) *CifsOpenFileDeleteParams {
	return &CifsOpenFileDeleteParams{
		timeout: timeout,
	}
}

// NewCifsOpenFileDeleteParamsWithContext creates a new CifsOpenFileDeleteParams object
// with the ability to set a context for a request.
func NewCifsOpenFileDeleteParamsWithContext(ctx context.Context) *CifsOpenFileDeleteParams {
	return &CifsOpenFileDeleteParams{
		Context: ctx,
	}
}

// NewCifsOpenFileDeleteParamsWithHTTPClient creates a new CifsOpenFileDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsOpenFileDeleteParamsWithHTTPClient(client *http.Client) *CifsOpenFileDeleteParams {
	return &CifsOpenFileDeleteParams{
		HTTPClient: client,
	}
}

/*
CifsOpenFileDeleteParams contains all the parameters to send to the API endpoint

	for the cifs open file delete operation.

	Typically these are written to a http.Request.
*/
type CifsOpenFileDeleteParams struct {

	/* ConnectionIdentifier.

	   Connection ID
	*/
	ConnectionIdentifier int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Identifier.

	   File ID

	   Format: int64
	*/
	Identifier int64

	/* NodeUUID.

	   Node UUID.
	*/
	NodeUUID string

	/* SessionIdentifier.

	   Session ID

	   Format: int64
	*/
	SessionIdentifier int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs open file delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsOpenFileDeleteParams) WithDefaults() *CifsOpenFileDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs open file delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsOpenFileDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithTimeout(timeout time.Duration) *CifsOpenFileDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithContext(ctx context.Context) *CifsOpenFileDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithHTTPClient(client *http.Client) *CifsOpenFileDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConnectionIdentifier adds the connectionIdentifier to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithConnectionIdentifier(connectionIdentifier int64) *CifsOpenFileDeleteParams {
	o.SetConnectionIdentifier(connectionIdentifier)
	return o
}

// SetConnectionIdentifier adds the connectionIdentifier to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetConnectionIdentifier(connectionIdentifier int64) {
	o.ConnectionIdentifier = connectionIdentifier
}

// WithFields adds the fields to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithFields(fields []string) *CifsOpenFileDeleteParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIdentifier adds the identifier to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithIdentifier(identifier int64) *CifsOpenFileDeleteParams {
	o.SetIdentifier(identifier)
	return o
}

// SetIdentifier adds the identifier to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetIdentifier(identifier int64) {
	o.Identifier = identifier
}

// WithNodeUUID adds the nodeUUID to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithNodeUUID(nodeUUID string) *CifsOpenFileDeleteParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithSessionIdentifier adds the sessionIdentifier to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithSessionIdentifier(sessionIdentifier int64) *CifsOpenFileDeleteParams {
	o.SetSessionIdentifier(sessionIdentifier)
	return o
}

// SetSessionIdentifier adds the sessionIdentifier to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetSessionIdentifier(sessionIdentifier int64) {
	o.SessionIdentifier = sessionIdentifier
}

// WithSvmUUID adds the svmUUID to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) WithSvmUUID(svmUUID string) *CifsOpenFileDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs open file delete params
func (o *CifsOpenFileDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsOpenFileDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param connection.identifier
	if err := r.SetPathParam("connection.identifier", swag.FormatInt64(o.ConnectionIdentifier)); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param identifier
	if err := r.SetPathParam("identifier", swag.FormatInt64(o.Identifier)); err != nil {
		return err
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	// path param session.identifier
	if err := r.SetPathParam("session.identifier", swag.FormatInt64(o.SessionIdentifier)); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCifsOpenFileDelete binds the parameter fields
func (o *CifsOpenFileDeleteParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
