// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsSearchPathCollectionGetParams creates a new CifsSearchPathCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsSearchPathCollectionGetParams() *CifsSearchPathCollectionGetParams {
	return &CifsSearchPathCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsSearchPathCollectionGetParamsWithTimeout creates a new CifsSearchPathCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCifsSearchPathCollectionGetParamsWithTimeout(timeout time.Duration) *CifsSearchPathCollectionGetParams {
	return &CifsSearchPathCollectionGetParams{
		timeout: timeout,
	}
}

// NewCifsSearchPathCollectionGetParamsWithContext creates a new CifsSearchPathCollectionGetParams object
// with the ability to set a context for a request.
func NewCifsSearchPathCollectionGetParamsWithContext(ctx context.Context) *CifsSearchPathCollectionGetParams {
	return &CifsSearchPathCollectionGetParams{
		Context: ctx,
	}
}

// NewCifsSearchPathCollectionGetParamsWithHTTPClient creates a new CifsSearchPathCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsSearchPathCollectionGetParamsWithHTTPClient(client *http.Client) *CifsSearchPathCollectionGetParams {
	return &CifsSearchPathCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CifsSearchPathCollectionGetParams contains all the parameters to send to the API endpoint

	for the cifs search path collection get operation.

	Typically these are written to a http.Request.
*/
type CifsSearchPathCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Path.

	   Filter by path
	*/
	Path *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs search path collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSearchPathCollectionGetParams) WithDefaults() *CifsSearchPathCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs search path collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSearchPathCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CifsSearchPathCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithTimeout(timeout time.Duration) *CifsSearchPathCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithContext(ctx context.Context) *CifsSearchPathCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithHTTPClient(client *http.Client) *CifsSearchPathCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithFields(fields []string) *CifsSearchPathCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithIndex(index *int64) *CifsSearchPathCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithMaxRecords adds the maxRecords to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithMaxRecords(maxRecords *int64) *CifsSearchPathCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithOrderBy(orderBy []string) *CifsSearchPathCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPath adds the path to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithPath(path *string) *CifsSearchPathCollectionGetParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetPath(path *string) {
	o.Path = path
}

// WithReturnRecords adds the returnRecords to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithReturnRecords(returnRecords *bool) *CifsSearchPathCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CifsSearchPathCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithSvmName(svmName *string) *CifsSearchPathCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) WithSvmUUID(svmUUID *string) *CifsSearchPathCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs search path collection get params
func (o *CifsSearchPathCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsSearchPathCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Path != nil {

		// query param path
		var qrPath string

		if o.Path != nil {
			qrPath = *o.Path
		}
		qPath := qrPath
		if qPath != "" {

			if err := r.SetQueryParam("path", qPath); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCifsSearchPathCollectionGet binds the parameter fields
func (o *CifsSearchPathCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCifsSearchPathCollectionGet binds the parameter order_by
func (o *CifsSearchPathCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
