// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsSearchPathCreateReader is a Reader for the CifsSearchPathCreate structure.
type CifsSearchPathCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsSearchPathCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCifsSearchPathCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsSearchPathCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsSearchPathCreateCreated creates a CifsSearchPathCreateCreated with default headers values
func NewCifsSearchPathCreateCreated() *CifsSearchPathCreateCreated {
	return &CifsSearchPathCreateCreated{}
}

/*
CifsSearchPathCreateCreated describes a response with status code 201, with default header values.

Created
*/
type CifsSearchPathCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.CifsSearchPathResponse
}

// IsSuccess returns true when this cifs search path create created response has a 2xx status code
func (o *CifsSearchPathCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs search path create created response has a 3xx status code
func (o *CifsSearchPathCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs search path create created response has a 4xx status code
func (o *CifsSearchPathCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs search path create created response has a 5xx status code
func (o *CifsSearchPathCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs search path create created response a status code equal to that given
func (o *CifsSearchPathCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the cifs search path create created response
func (o *CifsSearchPathCreateCreated) Code() int {
	return 201
}

func (o *CifsSearchPathCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/home-directory/search-paths][%d] cifsSearchPathCreateCreated %s", 201, payload)
}

func (o *CifsSearchPathCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/home-directory/search-paths][%d] cifsSearchPathCreateCreated %s", 201, payload)
}

func (o *CifsSearchPathCreateCreated) GetPayload() *models.CifsSearchPathResponse {
	return o.Payload
}

func (o *CifsSearchPathCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.CifsSearchPathResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCifsSearchPathCreateDefault creates a CifsSearchPathCreateDefault with default headers values
func NewCifsSearchPathCreateDefault(code int) *CifsSearchPathCreateDefault {
	return &CifsSearchPathCreateDefault{
		_statusCode: code,
	}
}

/*
	CifsSearchPathCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655551     | Invalid home-directory search-path path    |
| 655462     | The specified path is an invalid file-type |
*/
type CifsSearchPathCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs search path create default response has a 2xx status code
func (o *CifsSearchPathCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs search path create default response has a 3xx status code
func (o *CifsSearchPathCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs search path create default response has a 4xx status code
func (o *CifsSearchPathCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs search path create default response has a 5xx status code
func (o *CifsSearchPathCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs search path create default response a status code equal to that given
func (o *CifsSearchPathCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs search path create default response
func (o *CifsSearchPathCreateDefault) Code() int {
	return o._statusCode
}

func (o *CifsSearchPathCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/home-directory/search-paths][%d] cifs_search_path_create default %s", o._statusCode, payload)
}

func (o *CifsSearchPathCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/home-directory/search-paths][%d] cifs_search_path_create default %s", o._statusCode, payload)
}

func (o *CifsSearchPathCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsSearchPathCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
