// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsSearchPathDeleteCollectionParams creates a new CifsSearchPathDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsSearchPathDeleteCollectionParams() *CifsSearchPathDeleteCollectionParams {
	return &CifsSearchPathDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsSearchPathDeleteCollectionParamsWithTimeout creates a new CifsSearchPathDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewCifsSearchPathDeleteCollectionParamsWithTimeout(timeout time.Duration) *CifsSearchPathDeleteCollectionParams {
	return &CifsSearchPathDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewCifsSearchPathDeleteCollectionParamsWithContext creates a new CifsSearchPathDeleteCollectionParams object
// with the ability to set a context for a request.
func NewCifsSearchPathDeleteCollectionParamsWithContext(ctx context.Context) *CifsSearchPathDeleteCollectionParams {
	return &CifsSearchPathDeleteCollectionParams{
		Context: ctx,
	}
}

// NewCifsSearchPathDeleteCollectionParamsWithHTTPClient creates a new CifsSearchPathDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsSearchPathDeleteCollectionParamsWithHTTPClient(client *http.Client) *CifsSearchPathDeleteCollectionParams {
	return &CifsSearchPathDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
CifsSearchPathDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the cifs search path delete collection operation.

	Typically these are written to a http.Request.
*/
type CifsSearchPathDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* Info.

	   Info specification
	*/
	Info CifsSearchPathDeleteCollectionBody

	/* Path.

	   Filter by path
	*/
	Path *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs search path delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSearchPathDeleteCollectionParams) WithDefaults() *CifsSearchPathDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs search path delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSearchPathDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CifsSearchPathDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithTimeout(timeout time.Duration) *CifsSearchPathDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithContext(ctx context.Context) *CifsSearchPathDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithHTTPClient(client *http.Client) *CifsSearchPathDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CifsSearchPathDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithIndex adds the index to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithIndex(index *int64) *CifsSearchPathDeleteCollectionParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetIndex(index *int64) {
	o.Index = index
}

// WithInfo adds the info to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithInfo(info CifsSearchPathDeleteCollectionBody) *CifsSearchPathDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetInfo(info CifsSearchPathDeleteCollectionBody) {
	o.Info = info
}

// WithPath adds the path to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithPath(path *string) *CifsSearchPathDeleteCollectionParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetPath(path *string) {
	o.Path = path
}

// WithReturnRecords adds the returnRecords to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *CifsSearchPathDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *CifsSearchPathDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *CifsSearchPathDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithSvmName(svmName *string) *CifsSearchPathDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) WithSvmUUID(svmUUID *string) *CifsSearchPathDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs search path delete collection params
func (o *CifsSearchPathDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsSearchPathDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Path != nil {

		// query param path
		var qrPath string

		if o.Path != nil {
			qrPath = *o.Path
		}
		qPath := qrPath
		if qPath != "" {

			if err := r.SetQueryParam("path", qPath); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
