// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsSearchPathDeleteCollectionReader is a Reader for the CifsSearchPathDeleteCollection structure.
type CifsSearchPathDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsSearchPathDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsSearchPathDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsSearchPathDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsSearchPathDeleteCollectionOK creates a CifsSearchPathDeleteCollectionOK with default headers values
func NewCifsSearchPathDeleteCollectionOK() *CifsSearchPathDeleteCollectionOK {
	return &CifsSearchPathDeleteCollectionOK{}
}

/*
CifsSearchPathDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CifsSearchPathDeleteCollectionOK struct {
}

// IsSuccess returns true when this cifs search path delete collection o k response has a 2xx status code
func (o *CifsSearchPathDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs search path delete collection o k response has a 3xx status code
func (o *CifsSearchPathDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs search path delete collection o k response has a 4xx status code
func (o *CifsSearchPathDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs search path delete collection o k response has a 5xx status code
func (o *CifsSearchPathDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs search path delete collection o k response a status code equal to that given
func (o *CifsSearchPathDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs search path delete collection o k response
func (o *CifsSearchPathDeleteCollectionOK) Code() int {
	return 200
}

func (o *CifsSearchPathDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/home-directory/search-paths][%d] cifsSearchPathDeleteCollectionOK", 200)
}

func (o *CifsSearchPathDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/home-directory/search-paths][%d] cifsSearchPathDeleteCollectionOK", 200)
}

func (o *CifsSearchPathDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsSearchPathDeleteCollectionDefault creates a CifsSearchPathDeleteCollectionDefault with default headers values
func NewCifsSearchPathDeleteCollectionDefault(code int) *CifsSearchPathDeleteCollectionDefault {
	return &CifsSearchPathDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
CifsSearchPathDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type CifsSearchPathDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs search path delete collection default response has a 2xx status code
func (o *CifsSearchPathDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs search path delete collection default response has a 3xx status code
func (o *CifsSearchPathDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs search path delete collection default response has a 4xx status code
func (o *CifsSearchPathDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs search path delete collection default response has a 5xx status code
func (o *CifsSearchPathDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs search path delete collection default response a status code equal to that given
func (o *CifsSearchPathDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs search path delete collection default response
func (o *CifsSearchPathDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CifsSearchPathDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/home-directory/search-paths][%d] cifs_search_path_delete_collection default %s", o._statusCode, payload)
}

func (o *CifsSearchPathDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/home-directory/search-paths][%d] cifs_search_path_delete_collection default %s", o._statusCode, payload)
}

func (o *CifsSearchPathDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsSearchPathDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CifsSearchPathDeleteCollectionBody cifs search path delete collection body
swagger:model CifsSearchPathDeleteCollectionBody
*/
type CifsSearchPathDeleteCollectionBody struct {

	// cifs search path response inline records
	CifsSearchPathResponseInlineRecords []*models.CifsSearchPath `json:"records,omitempty"`
}

// Validate validates this cifs search path delete collection body
func (o *CifsSearchPathDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifsSearchPathResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSearchPathDeleteCollectionBody) validateCifsSearchPathResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsSearchPathResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsSearchPathResponseInlineRecords); i++ {
		if swag.IsZero(o.CifsSearchPathResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CifsSearchPathResponseInlineRecords[i] != nil {
			if err := o.CifsSearchPathResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cifs search path delete collection body based on the context it is used
func (o *CifsSearchPathDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifsSearchPathResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSearchPathDeleteCollectionBody) contextValidateCifsSearchPathResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsSearchPathResponseInlineRecords); i++ {

		if o.CifsSearchPathResponseInlineRecords[i] != nil {
			if err := o.CifsSearchPathResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsSearchPathDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsSearchPathDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res CifsSearchPathDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
