// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsSearchPathModifyCollectionReader is a Reader for the CifsSearchPathModifyCollection structure.
type CifsSearchPathModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsSearchPathModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsSearchPathModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsSearchPathModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsSearchPathModifyCollectionOK creates a CifsSearchPathModifyCollectionOK with default headers values
func NewCifsSearchPathModifyCollectionOK() *CifsSearchPathModifyCollectionOK {
	return &CifsSearchPathModifyCollectionOK{}
}

/*
CifsSearchPathModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CifsSearchPathModifyCollectionOK struct {
}

// IsSuccess returns true when this cifs search path modify collection o k response has a 2xx status code
func (o *CifsSearchPathModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs search path modify collection o k response has a 3xx status code
func (o *CifsSearchPathModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs search path modify collection o k response has a 4xx status code
func (o *CifsSearchPathModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs search path modify collection o k response has a 5xx status code
func (o *CifsSearchPathModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs search path modify collection o k response a status code equal to that given
func (o *CifsSearchPathModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs search path modify collection o k response
func (o *CifsSearchPathModifyCollectionOK) Code() int {
	return 200
}

func (o *CifsSearchPathModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/home-directory/search-paths][%d] cifsSearchPathModifyCollectionOK", 200)
}

func (o *CifsSearchPathModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/home-directory/search-paths][%d] cifsSearchPathModifyCollectionOK", 200)
}

func (o *CifsSearchPathModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewCifsSearchPathModifyCollectionDefault creates a CifsSearchPathModifyCollectionDefault with default headers values
func NewCifsSearchPathModifyCollectionDefault(code int) *CifsSearchPathModifyCollectionDefault {
	return &CifsSearchPathModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	CifsSearchPathModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655463     | Failed to reorder the search-path because the new-index is invalid. It cannot be '0' and it cannot go beyond the current entries |
*/
type CifsSearchPathModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs search path modify collection default response has a 2xx status code
func (o *CifsSearchPathModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs search path modify collection default response has a 3xx status code
func (o *CifsSearchPathModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs search path modify collection default response has a 4xx status code
func (o *CifsSearchPathModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs search path modify collection default response has a 5xx status code
func (o *CifsSearchPathModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs search path modify collection default response a status code equal to that given
func (o *CifsSearchPathModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs search path modify collection default response
func (o *CifsSearchPathModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CifsSearchPathModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/home-directory/search-paths][%d] cifs_search_path_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsSearchPathModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/home-directory/search-paths][%d] cifs_search_path_modify_collection default %s", o._statusCode, payload)
}

func (o *CifsSearchPathModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsSearchPathModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CifsSearchPathModifyCollectionBody cifs search path modify collection body
swagger:model CifsSearchPathModifyCollectionBody
*/
type CifsSearchPathModifyCollectionBody struct {

	// cifs search path response inline records
	CifsSearchPathResponseInlineRecords []*models.CifsSearchPath `json:"records,omitempty"`

	// The position in the list of paths that is searched to find the home directory of the CIFS client. Not available in POST.
	// Read Only: true
	Index *int64 `json:"index,omitempty"`

	// The file system path that is searched to find the home directory of the CIFS client.
	// Example: /HomeDirectory/EngDomain
	Path *string `json:"path,omitempty"`

	// svm
	Svm *models.CifsSearchPathInlineSvm `json:"svm,omitempty"`
}

// Validate validates this cifs search path modify collection body
func (o *CifsSearchPathModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifsSearchPathResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSearchPathModifyCollectionBody) validateCifsSearchPathResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsSearchPathResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsSearchPathResponseInlineRecords); i++ {
		if swag.IsZero(o.CifsSearchPathResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CifsSearchPathResponseInlineRecords[i] != nil {
			if err := o.CifsSearchPathResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsSearchPathModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs search path modify collection body based on the context it is used
func (o *CifsSearchPathModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifsSearchPathResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIndex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSearchPathModifyCollectionBody) contextValidateCifsSearchPathResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsSearchPathResponseInlineRecords); i++ {

		if o.CifsSearchPathResponseInlineRecords[i] != nil {
			if err := o.CifsSearchPathResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CifsSearchPathModifyCollectionBody) contextValidateIndex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"index", "body", o.Index); err != nil {
		return err
	}

	return nil
}

func (o *CifsSearchPathModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsSearchPathModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsSearchPathModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res CifsSearchPathModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsSearchPathInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model cifs_search_path_inline_svm
*/
type CifsSearchPathInlineSvm struct {

	// links
	Links *models.CifsSearchPathInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs search path inline svm
func (o *CifsSearchPathInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSearchPathInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs search path inline svm based on the context it is used
func (o *CifsSearchPathInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSearchPathInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsSearchPathInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsSearchPathInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsSearchPathInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CifsSearchPathInlineSvmInlineLinks cifs search path inline svm inline links
swagger:model cifs_search_path_inline_svm_inline__links
*/
type CifsSearchPathInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cifs search path inline svm inline links
func (o *CifsSearchPathInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSearchPathInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs search path inline svm inline links based on the context it is used
func (o *CifsSearchPathInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsSearchPathInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsSearchPathInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsSearchPathInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsSearchPathInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
