// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCifsSearchPathModifyParams creates a new CifsSearchPathModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCifsSearchPathModifyParams() *CifsSearchPathModifyParams {
	return &CifsSearchPathModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCifsSearchPathModifyParamsWithTimeout creates a new CifsSearchPathModifyParams object
// with the ability to set a timeout on a request.
func NewCifsSearchPathModifyParamsWithTimeout(timeout time.Duration) *CifsSearchPathModifyParams {
	return &CifsSearchPathModifyParams{
		timeout: timeout,
	}
}

// NewCifsSearchPathModifyParamsWithContext creates a new CifsSearchPathModifyParams object
// with the ability to set a context for a request.
func NewCifsSearchPathModifyParamsWithContext(ctx context.Context) *CifsSearchPathModifyParams {
	return &CifsSearchPathModifyParams{
		Context: ctx,
	}
}

// NewCifsSearchPathModifyParamsWithHTTPClient creates a new CifsSearchPathModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewCifsSearchPathModifyParamsWithHTTPClient(client *http.Client) *CifsSearchPathModifyParams {
	return &CifsSearchPathModifyParams{
		HTTPClient: client,
	}
}

/*
CifsSearchPathModifyParams contains all the parameters to send to the API endpoint

	for the cifs search path modify operation.

	Typically these are written to a http.Request.
*/
type CifsSearchPathModifyParams struct {

	/* Index.

	   Home directory search path index
	*/
	Index int64

	/* NewIndex.

	   New position for the home directory search path
	*/
	NewIndex *int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cifs search path modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSearchPathModifyParams) WithDefaults() *CifsSearchPathModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cifs search path modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CifsSearchPathModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the cifs search path modify params
func (o *CifsSearchPathModifyParams) WithTimeout(timeout time.Duration) *CifsSearchPathModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cifs search path modify params
func (o *CifsSearchPathModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cifs search path modify params
func (o *CifsSearchPathModifyParams) WithContext(ctx context.Context) *CifsSearchPathModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cifs search path modify params
func (o *CifsSearchPathModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cifs search path modify params
func (o *CifsSearchPathModifyParams) WithHTTPClient(client *http.Client) *CifsSearchPathModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cifs search path modify params
func (o *CifsSearchPathModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIndex adds the index to the cifs search path modify params
func (o *CifsSearchPathModifyParams) WithIndex(index int64) *CifsSearchPathModifyParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the cifs search path modify params
func (o *CifsSearchPathModifyParams) SetIndex(index int64) {
	o.Index = index
}

// WithNewIndex adds the newIndex to the cifs search path modify params
func (o *CifsSearchPathModifyParams) WithNewIndex(newIndex *int64) *CifsSearchPathModifyParams {
	o.SetNewIndex(newIndex)
	return o
}

// SetNewIndex adds the newIndex to the cifs search path modify params
func (o *CifsSearchPathModifyParams) SetNewIndex(newIndex *int64) {
	o.NewIndex = newIndex
}

// WithSvmUUID adds the svmUUID to the cifs search path modify params
func (o *CifsSearchPathModifyParams) WithSvmUUID(svmUUID string) *CifsSearchPathModifyParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cifs search path modify params
func (o *CifsSearchPathModifyParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CifsSearchPathModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param index
	if err := r.SetPathParam("index", swag.FormatInt64(o.Index)); err != nil {
		return err
	}

	if o.NewIndex != nil {

		// query param new_index
		var qrNewIndex int64

		if o.NewIndex != nil {
			qrNewIndex = *o.NewIndex
		}
		qNewIndex := swag.FormatInt64(qrNewIndex)
		if qNewIndex != "" {

			if err := r.SetQueryParam("new_index", qNewIndex); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
