// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CifsServiceDeleteCollectionReader is a Reader for the CifsServiceDeleteCollection structure.
type CifsServiceDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CifsServiceDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCifsServiceDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewCifsServiceDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCifsServiceDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCifsServiceDeleteCollectionOK creates a CifsServiceDeleteCollectionOK with default headers values
func NewCifsServiceDeleteCollectionOK() *CifsServiceDeleteCollectionOK {
	return &CifsServiceDeleteCollectionOK{}
}

/*
CifsServiceDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CifsServiceDeleteCollectionOK struct {
	Payload *models.CifsServiceJobLinkResponse
}

// IsSuccess returns true when this cifs service delete collection o k response has a 2xx status code
func (o *CifsServiceDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs service delete collection o k response has a 3xx status code
func (o *CifsServiceDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs service delete collection o k response has a 4xx status code
func (o *CifsServiceDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs service delete collection o k response has a 5xx status code
func (o *CifsServiceDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs service delete collection o k response a status code equal to that given
func (o *CifsServiceDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cifs service delete collection o k response
func (o *CifsServiceDeleteCollectionOK) Code() int {
	return 200
}

func (o *CifsServiceDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/services][%d] cifsServiceDeleteCollectionOK %s", 200, payload)
}

func (o *CifsServiceDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/services][%d] cifsServiceDeleteCollectionOK %s", 200, payload)
}

func (o *CifsServiceDeleteCollectionOK) GetPayload() *models.CifsServiceJobLinkResponse {
	return o.Payload
}

func (o *CifsServiceDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CifsServiceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCifsServiceDeleteCollectionAccepted creates a CifsServiceDeleteCollectionAccepted with default headers values
func NewCifsServiceDeleteCollectionAccepted() *CifsServiceDeleteCollectionAccepted {
	return &CifsServiceDeleteCollectionAccepted{}
}

/*
CifsServiceDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type CifsServiceDeleteCollectionAccepted struct {
	Payload *models.CifsServiceJobLinkResponse
}

// IsSuccess returns true when this cifs service delete collection accepted response has a 2xx status code
func (o *CifsServiceDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cifs service delete collection accepted response has a 3xx status code
func (o *CifsServiceDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cifs service delete collection accepted response has a 4xx status code
func (o *CifsServiceDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this cifs service delete collection accepted response has a 5xx status code
func (o *CifsServiceDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this cifs service delete collection accepted response a status code equal to that given
func (o *CifsServiceDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the cifs service delete collection accepted response
func (o *CifsServiceDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *CifsServiceDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/services][%d] cifsServiceDeleteCollectionAccepted %s", 202, payload)
}

func (o *CifsServiceDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/services][%d] cifsServiceDeleteCollectionAccepted %s", 202, payload)
}

func (o *CifsServiceDeleteCollectionAccepted) GetPayload() *models.CifsServiceJobLinkResponse {
	return o.Payload
}

func (o *CifsServiceDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CifsServiceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCifsServiceDeleteCollectionDefault creates a CifsServiceDeleteCollectionDefault with default headers values
func NewCifsServiceDeleteCollectionDefault(code int) *CifsServiceDeleteCollectionDefault {
	return &CifsServiceDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	CifsServiceDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655525     | In order to delete an Active Directory machine account for the CIFS server, you must supply the name and password of a Windows account with sufficient privileges.|
| 3735751    | Failed to authenticate and retrieve the access token from the Azure OAuth host. |
| 3735752    | Failed to extract the private key from the Azure Key Vault certificate. |
| 3735753    | Unsupported content_type in the Azure secrets response. |
| 3735754    | Failed to parse the JSON response from Azure Key Vault. |
| 3735755    | REST API call to Azure failed. |
| 3735756    | Invalid client certificate. |
| 3735757    | Failed to generate client assertion. |
| 3735762    | The provided Azure Key Vault configuration is incorrect. |
| 3735763    | The provided Azure Key Vault configuration is incomplete. |
| 3735764    | Request to Azure failed. Reason - Azure error code and Azure error message. |
| 655563     | NetBIOS name contains characters that are not allowed. |
| 655562     | NetBIOS name is longer than 15 characters. |
| 655923     | Retrieving credentials from AKV is not supported because the effective cluster version is not ONTAP 9.15.0 or later. |
| 656487     | Missing fields when doing CIFS operation with hybrid auth user type. |
*/
type CifsServiceDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cifs service delete collection default response has a 2xx status code
func (o *CifsServiceDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cifs service delete collection default response has a 3xx status code
func (o *CifsServiceDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cifs service delete collection default response has a 4xx status code
func (o *CifsServiceDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cifs service delete collection default response has a 5xx status code
func (o *CifsServiceDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cifs service delete collection default response a status code equal to that given
func (o *CifsServiceDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cifs service delete collection default response
func (o *CifsServiceDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CifsServiceDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/services][%d] cifs_service_delete_collection default %s", o._statusCode, payload)
}

func (o *CifsServiceDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/services][%d] cifs_service_delete_collection default %s", o._statusCode, payload)
}

func (o *CifsServiceDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CifsServiceDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CifsServiceDeleteCollectionBody cifs service delete collection body
swagger:model CifsServiceDeleteCollectionBody
*/
type CifsServiceDeleteCollectionBody struct {

	// cifs service response inline records
	CifsServiceResponseInlineRecords []*models.CifsService `json:"records,omitempty"`
}

// Validate validates this cifs service delete collection body
func (o *CifsServiceDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifsServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceDeleteCollectionBody) validateCifsServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CifsServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.CifsServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CifsServiceResponseInlineRecords[i] != nil {
			if err := o.CifsServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cifs service delete collection body based on the context it is used
func (o *CifsServiceDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifsServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CifsServiceDeleteCollectionBody) contextValidateCifsServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CifsServiceResponseInlineRecords); i++ {

		if o.CifsServiceResponseInlineRecords[i] != nil {
			if err := o.CifsServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *CifsServiceDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CifsServiceDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res CifsServiceDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
